/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.GetMetaRequest;
import com.couchbase.client.core.msg.kv.GetMetaResponse;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.ExistsResult;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandler;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001A4Q!\u0002\u0004\u0001\u0015IA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006g\u0001!\t\u0001\u000e\u0005\u0006Q\u0002!\t%\u001b\u0002\u000e\u000bbL7\u000f^:IC:$G.\u001a:\u000b\u0005\u001dA\u0011\u0001\u00035b]\u0012dWM]:\u000b\u0005%Q\u0011AA6w\u0015\tYA\"A\u0003tG\u0006d\u0017M\u0003\u0002\u000e\u001d\u000511\r\\5f]RT!a\u0004\t\u0002\u0013\r|Wo\u00195cCN,'\"A\t\u0002\u0007\r|WnE\u0002\u0001'a\u0001\"\u0001\u0006\f\u000e\u0003UQ\u0011aC\u0005\u0003/U\u0011a!\u00118z%\u00164\u0007\u0003B\r\u001b9\u0015j\u0011AB\u0005\u00037\u0019\u0011acS3z-\u0006dW/\u001a*fcV,7\u000f\u001e%b]\u0012dWM\u001d\t\u0003;\rj\u0011A\b\u0006\u0003\u0013}Q!\u0001I\u0011\u0002\u00075\u001cxM\u0003\u0002#\u0019\u0005!1m\u001c:f\u0013\t!cDA\bHKRlU\r^1SKN\u0004xN\\:f!\t1s%D\u0001\t\u0013\tA\u0003B\u0001\u0007Fq&\u001cHo\u001d*fgVdG/\u0001\u0002ia\u000e\u0001\u0001C\u0001\u0017.\u001b\u0005Q\u0011B\u0001\u0018\u000b\u00055A\u0015M\u001c3mKJ\u0004\u0016M]1ng\u00061A(\u001b8jiz\"\"!\r\u001a\u0011\u0005e\u0001\u0001\"B\u0015\u0003\u0001\u0004Y\u0013a\u0002:fcV,7\u000f\u001e\u000b\u0006kyZU+\u0018\t\u0004meZT\"A\u001c\u000b\u0005a*\u0012\u0001B;uS2L!AO\u001c\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\u001ey%\u0011QH\b\u0002\u000f\u000f\u0016$X*\u001a;b%\u0016\fX/Z:u\u0011\u0015y4\u00011\u0001A\u0003\tIG\r\u0005\u0002B\u0011:\u0011!I\u0012\t\u0003\u0007Vi\u0011\u0001\u0012\u0006\u0003\u000b*\na\u0001\u0010:p_Rt\u0014BA$\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d+\u0002\"\u0002'\u0004\u0001\u0004i\u0015a\u0002;j[\u0016|W\u000f\u001e\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA\u0001^5nK*\t!+\u0001\u0003kCZ\f\u0017B\u0001+P\u0005!!UO]1uS>t\u0007\"\u0002,\u0004\u0001\u00049\u0016!\u0004:fiJL8\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0002Y76\t\u0011L\u0003\u0002[C\u0005)!/\u001a;ss&\u0011A,\u0017\u0002\u000e%\u0016$(/_*ue\u0006$XmZ=\t\u000by\u001b\u0001\u0019A0\u0002\u0015A\f'/\u001a8u'B\fg\u000eE\u0002\u0015A\nL!!Y\u000b\u0003\r=\u0003H/[8o!\t\u0019g-D\u0001e\u0015\t)\u0017%A\u0002d]\u000eL!a\u001a3\u0003\u0017I+\u0017/^3tiN\u0003\u0018M\\\u0001\te\u0016\u001c\bo\u001c8tKR!QE\u001b8p\u0011\u0015\u0019D\u00011\u0001l!\riB\u000eH\u0005\u0003[z\u0011qbS3z-\u0006dW/\u001a*fcV,7\u000f\u001e\u0005\u0006\u007f\u0011\u0001\r\u0001\u0011\u0005\u0006Q\u0012\u0001\r\u0001\b")
public class ExistsHandler
implements KeyValueRequestHandler<GetMetaResponse, ExistsResult> {
    private final HandlerParams hp;

    public Try<GetMetaRequest> request(String id, Duration timeout, RetryStrategy retryStrategy, Option<RequestSpan> parentSpan) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null))));
        return validations.isFailure() ? validations : new Success((Object)new GetMetaRequest(id, timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, this.hp.tracer().internalSpan("exists", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms()))));
    }

    @Override
    public ExistsResult response(KeyValueRequest<GetMetaResponse> request, String id, GetMetaResponse response) {
        ExistsResult existsResult;
        ResponseStatus responseStatus = response.status();
        if (ResponseStatus.SUCCESS.equals(responseStatus)) {
            existsResult = new ExistsResult(true, response.cas());
        } else if (ResponseStatus.NOT_FOUND.equals(responseStatus)) {
            existsResult = new ExistsResult(false, 0L);
        } else {
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        return existsResult;
    }

    public ExistsHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

