/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.msg.kv.GetResponse;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.AsyncCollection;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.durability.Durability$Disabled$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.kv.ExistsOptions;
import com.couchbase.client.scala.kv.ExistsResult;
import com.couchbase.client.scala.kv.GetAllReplicasOptions;
import com.couchbase.client.scala.kv.GetAllReplicasOptions$;
import com.couchbase.client.scala.kv.GetAndLockOptions;
import com.couchbase.client.scala.kv.GetAndTouchOptions;
import com.couchbase.client.scala.kv.GetAnyReplicaOptions;
import com.couchbase.client.scala.kv.GetAnyReplicaOptions$;
import com.couchbase.client.scala.kv.GetOptions;
import com.couchbase.client.scala.kv.GetReplicaResult;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.InsertOptions;
import com.couchbase.client.scala.kv.LookupInOptions;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.MutateInOptions;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.RemoveOptions;
import com.couchbase.client.scala.kv.ReplaceOptions;
import com.couchbase.client.scala.kv.StoreSemantics;
import com.couchbase.client.scala.kv.StoreSemantics$Replace$;
import com.couchbase.client.scala.kv.TouchOptions;
import com.couchbase.client.scala.kv.UnlockOptions;
import com.couchbase.client.scala.kv.UpsertOptions;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import com.couchbase.client.scala.util.TimeoutUtil$;
import java.io.Serializable;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\u0005h\u0001B!C\u0001-C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\t5\u0002\u0011\r\u0011\"\u0001C7\"1Q\u000e\u0001Q\u0001\nqC\u0001B\u001c\u0001C\u0002\u0013\u0005!i\u001c\u0005\u0007a\u0002\u0001\u000b\u0011B3\t\u000fE\u0004!\u0019!C\u0005e\"1\u0011\u0010\u0001Q\u0001\nMDqA\u001f\u0001C\u0002\u0013%1\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002?\t\u0013\u0005\u0015\u0001A1A\u0005\f\u0005\u001d\u0001\u0002CA\t\u0001\u0001\u0006I!!\u0003\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002\"CAE\u0001E\u0005I\u0011AAF\u0011%\t)\u000bAI\u0001\n\u0003\t9\u000bC\u0004\u0002.\u0001!\t!a,\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"I\u0011Q\u001e\u0001\u0012\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0003o\u0004\u0011\u0013!C\u0001\u0003sD\u0011\"!@\u0001#\u0003%\t!a@\t\u000f\u0005-\u0007\u0001\"\u0001\u0003\u0004!9!Q\u0004\u0001\u0005\u0002\t}\u0001\"\u0003B\u001b\u0001E\u0005I\u0011\u0001B\u001c\u0011%\u0011Y\u0004AI\u0001\n\u0003\u0011i\u0004C\u0004\u0003\u001e\u0001!\tA!\u0011\t\u000f\tm\u0003\u0001\"\u0001\u0003^!I!q\r\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001f\u0005\n\u0005S\u0002\u0011\u0013!C\u0001\u0003\u001bC\u0011Ba\u001b\u0001#\u0003%\t!!+\t\u000f\tm\u0003\u0001\"\u0001\u0003n!9!\u0011\u0010\u0001\u0005\u0002\tm\u0004\"\u0003BE\u0001E\u0005I\u0011AAU\u0011\u001d\u0011I\b\u0001C\u0001\u0005\u0017CqAa&\u0001\t\u0003\u0011I\nC\u0005\u0003R\u0002\t\n\u0011\"\u0001\u0002r\"I!1\u001b\u0001\u0012\u0002\u0013\u0005!Q\u001b\u0005\n\u00053\u0004\u0011\u0013!C\u0001\u0003\u001bC\u0011Ba7\u0001#\u0003%\t!!+\t\u000f\t]\u0005\u0001\"\u0001\u0003^\"9!1\u001e\u0001\u0005\u0002\t5\b\"\u0003B|\u0001E\u0005I\u0011AAU\u0011\u001d\u0011Y\u000f\u0001C\u0001\u0005sDqaa\u0002\u0001\t\u0003\u0019I\u0001C\u0005\u0004\u001a\u0001\t\n\u0011\"\u0001\u0002*\"91q\u0001\u0001\u0005\u0002\rm\u0001bBB\u0015\u0001\u0011\u000511\u0006\u0005\n\u0007k\u0001\u0011\u0013!C\u0001\u0003SCqa!\u000b\u0001\t\u0003\u00199\u0004C\u0004\u0004F\u0001!\taa\u0012\t\u0013\r}\u0003!%A\u0005\u0002\u0005%\u0006bBB#\u0001\u0011\u00051\u0011\r\u0005\b\u0007_\u0002A\u0011AB9\u0011%\u0019y\bAI\u0001\n\u0003\tI\u000bC\u0004\u0004p\u0001!\ta!!\t\u000f\r5\u0005\u0001\"\u0001\u0004\u0010\"I11\u0014\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0016\u0005\b\u0007\u001b\u0003A\u0011ABO\u0011\u001d\u0019I\u000b\u0001C\u0001\u0007WC\u0011ba-\u0001#\u0003%\t!!+\t\u000f\r%\u0006\u0001\"\u0001\u00046\"911\u0019\u0001\u0005\u0002\r\u0015\u0007\"CBj\u0001E\u0005I\u0011AAU\u0011\u001d\u0019\u0019\r\u0001C\u0001\u0007+\u0014!CU3bGRLg/Z\"pY2,7\r^5p]*\u00111\tR\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u000b\u001a\u000baa\u00197jK:$(BA$I\u0003%\u0019w.^2iE\u0006\u001cXMC\u0001J\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\n\u0005\u0002N\u001f6\taJC\u0001D\u0013\t\u0001fJ\u0001\u0004B]f\u0014VMZ\u0001\u0006CNLhn\u0019\t\u0003'Rk\u0011AQ\u0005\u0003+\n\u0013q\"Q:z]\u000e\u001cu\u000e\u001c7fGRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005aK\u0006CA*\u0001\u0011\u0015\t&\u00011\u0001S\u0003%Yg\u000fV5nK>,H/F\u0001]!\u0011iUlX3\n\u0005ys%!\u0003$v]\u000e$\u0018n\u001c82!\t\u00017-D\u0001b\u0015\t\u0011')\u0001\u0006ekJ\f'-\u001b7jifL!\u0001Z1\u0003\u0015\u0011+(/\u00192jY&$\u0018\u0010\u0005\u0002gW6\tqM\u0003\u0002iS\u0006AA-\u001e:bi&|gN\u0003\u0002k\u001d\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u00051<'\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u0015-4H+[7f_V$\b%A\u0007lmJ+\u0017\r\u001a+j[\u0016|W\u000f^\u000b\u0002K\u0006q1N\u001e*fC\u0012$\u0016.\\3pkR\u0004\u0013aC3om&\u0014xN\\7f]R,\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m\n\u000b1!\u001a8w\u0013\tAXO\u0001\nDYV\u001cH/\u001a:F]ZL'o\u001c8nK:$\u0018\u0001D3om&\u0014xN\\7f]R\u0004\u0013\u0001B2pe\u0016,\u0012\u0001 \t\u0003{~l\u0011A \u0006\u0003u\u0012K1!!\u0001\u007f\u0005\u0011\u0019uN]3\u0002\u000b\r|'/\u001a\u0011\u0002\u0005\u0015\u001cWCAA\u0005!\u0011\tY!!\u0004\u000e\u0003%L1!a\u0004j\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002\nAA\\1nKV\u0011\u0011q\u0003\t\u0005\u00033\t9C\u0004\u0003\u0002\u001c\u0005\r\u0002cAA\u000f\u001d6\u0011\u0011q\u0004\u0006\u0004\u0003CQ\u0015A\u0002\u001fs_>$h(C\u0002\u0002&9\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0015\u0003W\u0011aa\u0015;sS:<'bAA\u0013\u001d\u00061\u0011N\\:feR,B!!\r\u0002jQQ\u00111GA>\u0003\u007f\n\u0019)!\"\u0015\t\u0005U\u0012Q\u000b\t\u0007\u0003o\t)%!\u0013\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007\r\u000byDC\u0002{\u0003\u0003R!!a\u0011\u0002\u000fI,\u0017m\u0019;pe&!\u0011qIA\u001d\u0005\u0015\u0019Vj\u001c8p!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(\u0005\u0006\u00111N^\u0005\u0005\u0003'\niE\u0001\bNkR\fG/[8o%\u0016\u001cX\u000f\u001c;\t\u000f\u0005]c\u0002q\u0001\u0002Z\u0005Q1/\u001a:jC2L'0\u001a:\u0011\r\u0005m\u0013\u0011MA3\u001b\t\tiFC\u0002\u0002`\t\u000bQaY8eK\u000eLA!a\u0019\u0002^\tq!j]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003BA4\u0003Sb\u0001\u0001B\u0004\u0002l9\u0011\r!!\u001c\u0003\u0003Q\u000bB!a\u001c\u0002vA\u0019Q*!\u001d\n\u0007\u0005MdJA\u0004O_RD\u0017N\\4\u0011\u00075\u000b9(C\u0002\u0002z9\u00131!\u00118z\u0011\u001d\tiH\u0004a\u0001\u0003/\t!!\u001b3\t\u000f\u0005\u0005e\u00021\u0001\u0002f\u000591m\u001c8uK:$\bb\u00022\u000f!\u0003\u0005\ra\u0018\u0005\t\u0003\u000fs\u0001\u0013!a\u0001K\u00069A/[7f_V$\u0018\u0001E5og\u0016\u0014H\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\ti)a)\u0016\u0005\u0005=%fA0\u0002\u0012.\u0012\u00111\u0013\t\u0005\u0003+\u000by*\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001e:\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t+a&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0004\u0002l=\u0011\r!!\u001c\u0002!%t7/\u001a:uI\u0011,g-Y;mi\u0012\"T\u0003BAU\u0003[+\"!a++\u0007\u0015\f\t\nB\u0004\u0002lA\u0011\r!!\u001c\u0016\t\u0005E\u00161\u0018\u000b\t\u0003g\u000bi,a0\u0002BR!\u0011QGA[\u0011\u001d\t9&\u0005a\u0002\u0003o\u0003b!a\u0017\u0002b\u0005e\u0006\u0003BA4\u0003w#q!a\u001b\u0012\u0005\u0004\ti\u0007C\u0004\u0002~E\u0001\r!a\u0006\t\u000f\u0005\u0005\u0015\u00031\u0001\u0002:\"9\u00111Y\tA\u0002\u0005\u0015\u0017aB8qi&|gn\u001d\t\u0005\u0003\u0017\n9-\u0003\u0003\u0002J\u00065#!D%og\u0016\u0014Ho\u00149uS>t7/A\u0004sKBd\u0017mY3\u0016\t\u0005=\u0017\u0011\u001c\u000b\r\u0003#\fY.!8\u0002`\u0006%\u00181\u001e\u000b\u0005\u0003k\t\u0019\u000eC\u0004\u0002XI\u0001\u001d!!6\u0011\r\u0005m\u0013\u0011MAl!\u0011\t9'!7\u0005\u000f\u0005-$C1\u0001\u0002n!9\u0011Q\u0010\nA\u0002\u0005]\u0001bBAA%\u0001\u0007\u0011q\u001b\u0005\n\u0003C\u0014\u0002\u0013!a\u0001\u0003G\f1aY1t!\ri\u0015Q]\u0005\u0004\u0003Ot%\u0001\u0002'p]\u001eDqA\u0019\n\u0011\u0002\u0003\u0007q\f\u0003\u0005\u0002\bJ\u0001\n\u00111\u0001f\u0003E\u0011X\r\u001d7bG\u0016$C-\u001a4bk2$HeM\u000b\u0005\u0003c\f)0\u0006\u0002\u0002t*\"\u00111]AI\t\u001d\tYg\u0005b\u0001\u0003[\n\u0011C]3qY\u0006\u001cW\r\n3fM\u0006,H\u000e\u001e\u00135+\u0011\ti)a?\u0005\u000f\u0005-DC1\u0001\u0002n\u0005\t\"/\u001a9mC\u000e,G\u0005Z3gCVdG\u000fJ\u001b\u0016\t\u0005%&\u0011\u0001\u0003\b\u0003W*\"\u0019AA7+\u0011\u0011)Aa\u0004\u0015\u0011\t\u001d!\u0011\u0003B\n\u0005+!B!!\u000e\u0003\n!9\u0011q\u000b\fA\u0004\t-\u0001CBA.\u0003C\u0012i\u0001\u0005\u0003\u0002h\t=AaBA6-\t\u0007\u0011Q\u000e\u0005\b\u0003{2\u0002\u0019AA\f\u0011\u001d\t\tI\u0006a\u0001\u0005\u001bAq!a1\u0017\u0001\u0004\u00119\u0002\u0005\u0003\u0002L\te\u0011\u0002\u0002B\u000e\u0003\u001b\u0012aBU3qY\u0006\u001cWm\u00149uS>t7/\u0001\u0004vaN,'\u000f^\u000b\u0005\u0005C\u0011Y\u0003\u0006\u0006\u0003$\t5\"q\u0006B\u0019\u0005g!B!!\u000e\u0003&!9\u0011qK\fA\u0004\t\u001d\u0002CBA.\u0003C\u0012I\u0003\u0005\u0003\u0002h\t-BaBA6/\t\u0007\u0011Q\u000e\u0005\b\u0003{:\u0002\u0019AA\f\u0011\u001d\t\ti\u0006a\u0001\u0005SAqAY\f\u0011\u0002\u0003\u0007q\f\u0003\u0005\u0002\b^\u0001\n\u00111\u0001f\u0003A)\bo]3si\u0012\"WMZ1vYR$3'\u0006\u0003\u0002\u000e\neBaBA61\t\u0007\u0011QN\u0001\u0011kB\u001cXM\u001d;%I\u00164\u0017-\u001e7uIQ*B!!+\u0003@\u00119\u00111N\rC\u0002\u00055T\u0003\u0002B\"\u0005\u001b\"\u0002B!\u0012\u0003P\tE#1\u000b\u000b\u0005\u0003k\u00119\u0005C\u0004\u0002Xi\u0001\u001dA!\u0013\u0011\r\u0005m\u0013\u0011\rB&!\u0011\t9G!\u0014\u0005\u000f\u0005-$D1\u0001\u0002n!9\u0011Q\u0010\u000eA\u0002\u0005]\u0001bBAA5\u0001\u0007!1\n\u0005\b\u0003\u0007T\u0002\u0019\u0001B+!\u0011\tYEa\u0016\n\t\te\u0013Q\n\u0002\u000e+B\u001cXM\u001d;PaRLwN\\:\u0002\rI,Wn\u001c<f))\t)Da\u0018\u0003b\t\r$Q\r\u0005\b\u0003{Z\u0002\u0019AA\f\u0011%\t\to\u0007I\u0001\u0002\u0004\t\u0019\u000fC\u0004c7A\u0005\t\u0019A0\t\u0011\u0005\u001d5\u0004%AA\u0002\u0015\f\u0001C]3n_Z,G\u0005Z3gCVdG\u000f\n\u001a\u0002!I,Wn\u001c<fI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u0005:f[>4X\r\n3fM\u0006,H\u000e\u001e\u00135)\u0019\t)Da\u001c\u0003r!9\u0011QP\u0010A\u0002\u0005]\u0001bBAb?\u0001\u0007!1\u000f\t\u0005\u0003\u0017\u0012)(\u0003\u0003\u0003x\u00055#!\u0004*f[>4Xm\u00149uS>t7/A\u0002hKR$bA! \u0003\u0006\n\u001d\u0005CBA\u001c\u0003\u000b\u0012y\b\u0005\u0003\u0002L\t\u0005\u0015\u0002\u0002BB\u0003\u001b\u0012\u0011bR3u%\u0016\u001cX\u000f\u001c;\t\u000f\u0005u\u0004\u00051\u0001\u0002\u0018!A\u0011q\u0011\u0011\u0011\u0002\u0003\u0007Q-A\u0007hKR$C-\u001a4bk2$HE\r\u000b\u0007\u0005{\u0012iIa$\t\u000f\u0005u$\u00051\u0001\u0002\u0018!9\u00111\u0019\u0012A\u0002\tE\u0005\u0003BA&\u0005'KAA!&\u0002N\tQq)\u001a;PaRLwN\\:\u0002\u00115,H/\u0019;f\u0013:$bBa'\u0003$\n\u0015&\u0011\u0019Bb\u0005\u001b\u0014y\r\u0005\u0004\u00028\u0005\u0015#Q\u0014\t\u0005\u0003\u0017\u0012y*\u0003\u0003\u0003\"\u00065#AD'vi\u0006$X-\u00138SKN,H\u000e\u001e\u0005\b\u0003{\u001a\u0003\u0019AA\f\u0011\u001d\u00119k\ta\u0001\u0005S\u000bAa\u001d9fGB1!1\u0016B[\u0005wsAA!,\u00032:!\u0011Q\u0004BX\u0013\u0005\u0019\u0015b\u0001BZ\u001d\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\\\u0005s\u00131aU3r\u0015\r\u0011\u0019L\u0014\t\u0005\u0003\u0017\u0012i,\u0003\u0003\u0003@\u00065#\u0001D'vi\u0006$X-\u00138Ta\u0016\u001c\u0007\"CAqGA\u0005\t\u0019AAr\u0011%\u0011)m\tI\u0001\u0002\u0004\u00119-\u0001\u0005e_\u000e,X.\u001a8u!\u0011\tYE!3\n\t\t-\u0017Q\n\u0002\u000f'R|'/Z*f[\u0006tG/[2t\u0011\u001d\u00117\u0005%AA\u0002}C\u0001\"a\"$!\u0003\u0005\r!Z\u0001\u0013[V$\u0018\r^3J]\u0012\"WMZ1vYR$3'\u0001\nnkR\fG/Z%oI\u0011,g-Y;mi\u0012\"TC\u0001BlU\u0011\u00119-!%\u0002%5,H/\u0019;f\u0013:$C-\u001a4bk2$H%N\u0001\u0013[V$\u0018\r^3J]\u0012\"WMZ1vYR$c\u0007\u0006\u0005\u0003\u001c\n}'\u0011\u001dBr\u0011\u001d\ti\b\u000ba\u0001\u0003/AqAa*)\u0001\u0004\u0011I\u000bC\u0004\u0002D\"\u0002\rA!:\u0011\t\u0005-#q]\u0005\u0005\u0005S\fiEA\bNkR\fG/Z%o\u001fB$\u0018n\u001c8t\u0003)9W\r^!oI2{7m\u001b\u000b\t\u0005{\u0012yO!=\u0003v\"9\u0011QP\u0015A\u0002\u0005]\u0001B\u0002BzS\u0001\u0007Q-\u0001\u0005m_\u000e\\G+[7f\u0011!\t9)\u000bI\u0001\u0002\u0004)\u0017\u0001F4fi\u0006sG\rT8dW\u0012\"WMZ1vYR$3\u0007\u0006\u0005\u0003~\tm(Q B\u0000\u0011\u001d\tih\u000ba\u0001\u0003/AaAa=,\u0001\u0004)\u0007bBAbW\u0001\u00071\u0011\u0001\t\u0005\u0003\u0017\u001a\u0019!\u0003\u0003\u0004\u0006\u00055#!E$fi\u0006sG\rT8dW>\u0003H/[8og\u00061QO\u001c7pG.$\u0002ba\u0003\u0004\u0014\rU1q\u0003\t\u0007\u0003o\t)e!\u0004\u0011\u00075\u001by!C\u0002\u0004\u00129\u0013A!\u00168ji\"9\u0011Q\u0010\u0017A\u0002\u0005]\u0001bBAqY\u0001\u0007\u00111\u001d\u0005\t\u0003\u000fc\u0003\u0013!a\u0001K\u0006\u0001RO\u001c7pG.$C-\u001a4bk2$He\r\u000b\t\u0007\u0017\u0019iba\b\u0004\"!9\u0011Q\u0010\u0018A\u0002\u0005]\u0001bBAq]\u0001\u0007\u00111\u001d\u0005\b\u0003\u0007t\u0003\u0019AB\u0012!\u0011\tYe!\n\n\t\r\u001d\u0012Q\n\u0002\u000e+:dwnY6PaRLwN\\:\u0002\u0017\u001d,G/\u00118e)>,8\r\u001b\u000b\t\u0005{\u001aica\f\u00044!9\u0011QP\u0018A\u0002\u0005]\u0001BBB\u0019_\u0001\u0007Q-\u0001\u0004fqBL'/\u001f\u0005\t\u0003\u000f{\u0003\u0013!a\u0001K\u0006)r-\u001a;B]\u0012$v.^2iI\u0011,g-Y;mi\u0012\u001aD\u0003\u0003B?\u0007s\u0019Yd!\u0010\t\u000f\u0005u\u0014\u00071\u0001\u0002\u0018!11\u0011G\u0019A\u0002\u0015Dq!a12\u0001\u0004\u0019y\u0004\u0005\u0003\u0002L\r\u0005\u0013\u0002BB\"\u0003\u001b\u0012!cR3u\u0003:$Gk\\;dQ>\u0003H/[8og\u0006AAn\\8lkBLe\u000e\u0006\u0005\u0004J\rE31KB/!\u0019\t9$!\u0012\u0004LA!\u00111JB'\u0013\u0011\u0019y%!\u0014\u0003\u001d1{wn[;q\u0013:\u0014Vm];mi\"9\u0011Q\u0010\u001aA\u0002\u0005]\u0001b\u0002BTe\u0001\u00071Q\u000b\t\u0007\u0005W\u0013)la\u0016\u0011\t\u0005-3\u0011L\u0005\u0005\u00077\niE\u0001\u0007M_>\\W\u000f]%o'B,7\r\u0003\u0005\u0002\bJ\u0002\n\u00111\u0001f\u0003Iawn\\6va&sG\u0005Z3gCVdG\u000fJ\u001a\u0015\u0011\r%31MB3\u0007OBq!! 5\u0001\u0004\t9\u0002C\u0004\u0003(R\u0002\ra!\u0016\t\u000f\u0005\rG\u00071\u0001\u0004jA!\u00111JB6\u0013\u0011\u0019i'!\u0014\u0003\u001f1{wn[;q\u0013:|\u0005\u000f^5p]N\fQbZ3u\u0003:L(+\u001a9mS\u000e\fGCBB:\u0007w\u001ai\b\u0005\u0004\u00028\u0005\u00153Q\u000f\t\u0005\u0003\u0017\u001a9(\u0003\u0003\u0004z\u00055#\u0001E$fiJ+\u0007\u000f\\5dCJ+7/\u001e7u\u0011\u001d\ti(\u000ea\u0001\u0003/A\u0001\"a\"6!\u0003\u0005\r!Z\u0001\u0018O\u0016$\u0018I\\=SKBd\u0017nY1%I\u00164\u0017-\u001e7uII\"baa\u001d\u0004\u0004\u000e\u0015\u0005bBA?o\u0001\u0007\u0011q\u0003\u0005\b\u0003\u0007<\u0004\u0019ABD!\u0011\tYe!#\n\t\r-\u0015Q\n\u0002\u0015\u000f\u0016$\u0018I\\=SKBd\u0017nY1PaRLwN\\:\u0002\u001d\u001d,G/\u00117m%\u0016\u0004H.[2bgR11\u0011SBL\u00073\u0003b!a\u000e\u0004\u0014\u000eU\u0014\u0002BBK\u0003s\u0011Qa\u0015$mkbDq!! 9\u0001\u0004\t9\u0002\u0003\u0005\u0002\bb\u0002\n\u00111\u0001f\u0003a9W\r^!mYJ+\u0007\u000f\\5dCN$C-\u001a4bk2$HE\r\u000b\u0007\u0007#\u001byj!)\t\u000f\u0005u$\b1\u0001\u0002\u0018!9\u00111\u0019\u001eA\u0002\r\r\u0006\u0003BA&\u0007KKAaa*\u0002N\t)r)\u001a;BY2\u0014V\r\u001d7jG\u0006\u001cx\n\u001d;j_:\u001c\u0018!\u0002;pk\u000eDG\u0003CA\u001b\u0007[\u001byk!-\t\u000f\u0005u4\b1\u0001\u0002\u0018!11\u0011G\u001eA\u0002\u0015D\u0001\"a\"<!\u0003\u0005\r!Z\u0001\u0010i>,8\r\u001b\u0013eK\u001a\fW\u000f\u001c;%gQA\u0011QGB\\\u0007s\u001bY\fC\u0004\u0002~u\u0002\r!a\u0006\t\r\rER\b1\u0001f\u0011\u001d\t\u0019-\u0010a\u0001\u0007{\u0003B!a\u0013\u0004@&!1\u0011YA'\u00051!v.^2i\u001fB$\u0018n\u001c8t\u0003\u0019)\u00070[:ugR11qYBh\u0007#\u0004b!a\u000e\u0002F\r%\u0007\u0003BA&\u0007\u0017LAa!4\u0002N\taQ\t_5tiN\u0014Vm];mi\"9\u0011Q\u0010 A\u0002\u0005]\u0001\u0002CAD}A\u0005\t\u0019A3\u0002!\u0015D\u0018n\u001d;tI\u0011,g-Y;mi\u0012\u0012DCBBd\u0007/\u001cI\u000eC\u0004\u0002~\u0001\u0003\r!a\u0006\t\u000f\u0005\r\u0007\t1\u0001\u0004\\B!\u00111JBo\u0013\u0011\u0019y.!\u0014\u0003\u001b\u0015C\u0018n\u001d;t\u001fB$\u0018n\u001c8t\u0001")
public class ReactiveCollection {
    private final AsyncCollection async;
    private final Function1<Durability, Duration> kvTimeout;
    private final Duration kvReadTimeout;
    private final ClusterEnvironment environment;
    private final Core core;
    private final ExecutionContext ec;

    public Function1<Durability, Duration> kvTimeout() {
        return this.kvTimeout;
    }

    public Duration kvReadTimeout() {
        return this.kvReadTimeout;
    }

    private ClusterEnvironment environment() {
        return this.environment;
    }

    private Core core() {
        return this.core;
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    public String name() {
        return this.async.name();
    }

    public <T> SMono<MutationResult> insert(String id, T content, Durability durability, Duration timeout, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.insert(id, content, durability, timeout, serializer), this.ec()));
    }

    public <T> SMono<MutationResult> insert(String id, T content, InsertOptions options, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.insert(id, content, options, serializer), this.ec()));
    }

    public <T> Durability insert$default$3() {
        return Durability$Disabled$.MODULE$;
    }

    public <T> Duration insert$default$4() {
        return Duration$.MODULE$.MinusInf();
    }

    public <T> SMono<MutationResult> replace(String id, T content, long cas, Durability durability, Duration timeout, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.replace(id, content, cas, durability, timeout, serializer), this.ec()));
    }

    public <T> SMono<MutationResult> replace(String id, T content, ReplaceOptions options, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.replace(id, content, options, serializer), this.ec()));
    }

    public <T> long replace$default$3() {
        return 0L;
    }

    public <T> Durability replace$default$4() {
        return Durability$Disabled$.MODULE$;
    }

    public <T> Duration replace$default$5() {
        return Duration$.MODULE$.MinusInf();
    }

    public <T> SMono<MutationResult> upsert(String id, T content, Durability durability, Duration timeout, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.upsert(id, content, durability, timeout, serializer), this.ec()));
    }

    public <T> SMono<MutationResult> upsert(String id, T content, UpsertOptions options, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.upsert(id, content, options, serializer), this.ec()));
    }

    public <T> Durability upsert$default$3() {
        return Durability$Disabled$.MODULE$;
    }

    public <T> Duration upsert$default$4() {
        return Duration$.MODULE$.MinusInf();
    }

    public SMono<MutationResult> remove(String id, long cas, Durability durability, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.remove(id, cas, durability, timeout), this.ec()));
    }

    public SMono<MutationResult> remove(String id, RemoveOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.remove(id, options), this.ec()));
    }

    public long remove$default$2() {
        return 0L;
    }

    public Durability remove$default$3() {
        return Durability$Disabled$.MODULE$;
    }

    public Duration remove$default$4() {
        return Duration$.MODULE$.MinusInf();
    }

    public SMono<GetResult> get(String id, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.get(id, timeout), this.ec()));
    }

    public SMono<GetResult> get(String id, GetOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.get(id, options), this.ec()));
    }

    public Duration get$default$2() {
        return this.kvReadTimeout();
    }

    public SMono<MutateInResult> mutateIn(String id, Seq<MutateInSpec> spec, long cas, StoreSemantics document, Durability durability, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.mutateIn(id, spec, cas, document, durability, timeout), this.ec()));
    }

    public SMono<MutateInResult> mutateIn(String id, Seq<MutateInSpec> spec, MutateInOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.mutateIn(id, spec, options), this.ec()));
    }

    public long mutateIn$default$3() {
        return 0L;
    }

    public StoreSemantics mutateIn$default$4() {
        return StoreSemantics$Replace$.MODULE$;
    }

    public Durability mutateIn$default$5() {
        return Durability$Disabled$.MODULE$;
    }

    public Duration mutateIn$default$6() {
        return Duration$.MODULE$.MinusInf();
    }

    public SMono<GetResult> getAndLock(String id, Duration lockTime, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndLock(id, lockTime, timeout), this.ec()));
    }

    public SMono<GetResult> getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndLock(id, lockTime, options), this.ec()));
    }

    public Duration getAndLock$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<BoxedUnit> unlock(String id, long cas, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.unlock(id, cas, timeout), this.ec()));
    }

    public SMono<BoxedUnit> unlock(String id, long cas, UnlockOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.unlock(id, cas, options), this.ec()));
    }

    public Duration unlock$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<GetResult> getAndTouch(String id, Duration expiry, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndTouch(id, expiry, timeout), this.ec()));
    }

    public SMono<GetResult> getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndTouch(id, expiry, options), this.ec()));
    }

    public Duration getAndTouch$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<LookupInResult> lookupIn(String id, Seq<LookupInSpec> spec, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.lookupIn(id, spec, timeout), this.ec()));
    }

    public SMono<LookupInResult> lookupIn(String id, Seq<LookupInSpec> spec, LookupInOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.lookupIn(id, spec, options), this.ec()));
    }

    public Duration lookupIn$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<GetReplicaResult> getAnyReplica(String id, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> this.getAnyReplica(id, new GetAnyReplicaOptions(GetAnyReplicaOptions$.MODULE$.apply$default$1(), GetAnyReplicaOptions$.MODULE$.apply$default$2(), GetAnyReplicaOptions$.MODULE$.apply$default$3(), GetAnyReplicaOptions$.MODULE$.apply$default$4()).timeout(timeout)));
    }

    public SMono<GetReplicaResult> getAnyReplica(String id, GetAnyReplicaOptions options) {
        Duration duration = options.timeout();
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        Duration timeout = !(duration != null ? !duration.equals(infinite) : infinite != null) ? this.kvReadTimeout() : options.timeout();
        return this.getAllReplicas(id, options.convert()).timeout(timeout).next();
    }

    public Duration getAnyReplica$default$2() {
        return this.kvReadTimeout();
    }

    public SFlux<GetReplicaResult> getAllReplicas(String id, Duration timeout) {
        return this.getAllReplicas(id, new GetAllReplicasOptions(GetAllReplicasOptions$.MODULE$.apply$default$1(), GetAllReplicasOptions$.MODULE$.apply$default$2(), GetAllReplicasOptions$.MODULE$.apply$default$3(), GetAllReplicasOptions$.MODULE$.apply$default$4()).timeout(timeout));
    }

    public SFlux<GetReplicaResult> getAllReplicas(String id, GetAllReplicasOptions options) {
        Success success;
        Seq reqs;
        SFlux sFlux;
        RetryStrategy retryStrategy = (RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.environment().retryStrategy());
        Transcoder transcoder = (Transcoder)options.transcoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.environment().transcoder());
        Duration duration = options.timeout();
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        Duration timeout = !(duration != null ? !duration.equals(infinite) : infinite != null) ? this.kvReadTimeout() : options.timeout();
        Try<Seq<GetRequest>> reqsTry = this.async.getFromReplicaHandler().requestAll(id, DurationConversions$.MODULE$.scalaDurationToJava(timeout), retryStrategy, options.parentSpan());
        Try<Seq<GetRequest>> try_ = reqsTry;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            sFlux = SFlux$.MODULE$.raiseError(err, SFlux$.MODULE$.raiseError$default$2());
        } else if (try_ instanceof Success && (reqs = (Seq)(success = (Success)try_).value()) != null) {
            Seq seq = reqs;
            sFlux = SFlux$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
                Seq monos = (Seq)seq.map((Function1 & Serializable & scala.Serializable)request -> {
                    this.core().send((Request)request);
                    return FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), true).flatMap((Function1 & Serializable & scala.Serializable)r -> {
                        SMono sMono;
                        GetRequest getRequest = request;
                        boolean bl = getRequest == null;
                        boolean isReplica = bl;
                        Option<GetReplicaResult> option = $this.async.getFromReplicaHandler().response((KeyValueRequest<GetResponse>)request, id, (GetResponse)r, isReplica, transcoder);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            GetReplicaResult getResult = (GetReplicaResult)some.value();
                            sMono = SMono$.MODULE$.just((Object)getResult);
                        } else {
                            sMono = SMono$.MODULE$.empty();
                        }
                        return sMono;
                    }).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> request.context().logicallyComplete());
                }, Seq$.MODULE$.canBuildFrom());
                return SFlux$.MODULE$.mergeSequential(monos, SFlux$.MODULE$.mergeSequential$default$2(), SFlux$.MODULE$.mergeSequential$default$3()).timeout(timeout);
            });
        } else {
            throw new MatchError(try_);
        }
        return sFlux;
    }

    public Duration getAllReplicas$default$2() {
        return this.kvReadTimeout();
    }

    public SMono<MutationResult> touch(String id, Duration expiry, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.touch(id, expiry, timeout), this.ec()));
    }

    public SMono<MutationResult> touch(String id, Duration expiry, TouchOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.touch(id, expiry, options), this.ec()));
    }

    public Duration touch$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<ExistsResult> exists(String id, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.exists(id, timeout), this.ec()));
    }

    public SMono<ExistsResult> exists(String id, ExistsOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.exists(id, options), this.ec()));
    }

    public Duration exists$default$2() {
        return this.kvReadTimeout();
    }

    public ReactiveCollection(AsyncCollection async) {
        this.async = async;
        this.kvTimeout = (Function1 & Serializable & scala.Serializable)durability -> TimeoutUtil$.MODULE$.kvTimeout($this.async.environment(), (Durability)durability);
        this.kvReadTimeout = async.kvReadTimeout();
        this.environment = async.environment();
        this.core = async.core();
        this.ec = async.ec();
    }
}

