/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.transactions;

import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.transaction.CoreTransactionGetResult;
import com.couchbase.client.core.transaction.CoreTransactionOptionalGetMultiResult;
import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.transactions.TransactionDocumentSpec;
import com.couchbase.client.kotlin.transactions.TransactionGetResult;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0086\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/couchbase/client/kotlin/transactions/TransactionGetMultiResult;", "", "specs", "", "Lcom/couchbase/client/kotlin/transactions/TransactionDocumentSpec;", "coreResults", "Lcom/couchbase/client/core/transaction/CoreTransactionOptionalGetMultiResult;", "defaultJsonSerializer", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "(Ljava/util/List;Ljava/util/List;Lcom/couchbase/client/kotlin/codec/JsonSerializer;)V", "get", "Lcom/couchbase/client/kotlin/transactions/TransactionGetResult;", "spec", "getOrNull", "kotlin-client"})
@SourceDebugExtension(value={"SMAP\nTransactionGetMultiResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionGetMultiResult.kt\ncom/couchbase/client/kotlin/transactions/TransactionGetMultiResult\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class TransactionGetMultiResult {
    @NotNull
    private final List<TransactionDocumentSpec> specs;
    @NotNull
    private final List<CoreTransactionOptionalGetMultiResult> coreResults;
    @NotNull
    private final JsonSerializer defaultJsonSerializer;

    public TransactionGetMultiResult(@NotNull List<TransactionDocumentSpec> specs, @NotNull List<? extends CoreTransactionOptionalGetMultiResult> coreResults, @NotNull JsonSerializer defaultJsonSerializer) {
        Intrinsics.checkNotNullParameter(specs, (String)"specs");
        Intrinsics.checkNotNullParameter(coreResults, (String)"coreResults");
        Intrinsics.checkNotNullParameter((Object)defaultJsonSerializer, (String)"defaultJsonSerializer");
        this.specs = specs;
        this.coreResults = coreResults;
        this.defaultJsonSerializer = defaultJsonSerializer;
    }

    @NotNull
    public final TransactionGetResult get(@NotNull TransactionDocumentSpec spec2) {
        Intrinsics.checkNotNullParameter((Object)spec2, (String)"spec");
        TransactionGetResult transactionGetResult = this.getOrNull(spec2);
        if (transactionGetResult == null) {
            throw new DocumentNotFoundException((ErrorContext)ReducedKeyValueErrorContext.create((String)spec2.getDocumentId(), (CollectionIdentifier)spec2.getCollection().getCollectionId$kotlin_client()));
        }
        return transactionGetResult;
    }

    @Nullable
    public final TransactionGetResult getOrNull(@NotNull TransactionDocumentSpec spec2) {
        TransactionGetResult transactionGetResult;
        Intrinsics.checkNotNullParameter((Object)spec2, (String)"spec");
        int index = this.specs.indexOf(spec2);
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The spec '" + spec2 + "' is not present in this result. Expected one of: " + this.specs;
            throw new IllegalArgumentException(string.toString());
        }
        Optional optional = this.coreResults.get((int)index).internal;
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"internal");
        CoreTransactionGetResult coreTransactionGetResult = (CoreTransactionGetResult)OptionalsKt.getOrNull((Optional)optional);
        if (coreTransactionGetResult != null) {
            CoreTransactionGetResult it = coreTransactionGetResult;
            boolean bl = false;
            transactionGetResult = new TransactionGetResult(it, this.defaultJsonSerializer);
        } else {
            transactionGetResult = null;
        }
        return transactionGetResult;
    }
}

