/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.search;

import com.couchbase.client.core.api.search.sort.CoreSearchSort;
import com.couchbase.client.kotlin.search.Direction;
import com.couchbase.client.kotlin.search.FieldType;
import com.couchbase.client.kotlin.search.GeoDistanceUnit;
import com.couchbase.client.kotlin.search.GeoPoint;
import com.couchbase.client.kotlin.search.Missing;
import com.couchbase.client.kotlin.search.Mode;
import com.couchbase.client.kotlin.search.SearchSortComponent;
import com.couchbase.client.kotlin.search.SearchSortField;
import com.couchbase.client.kotlin.search.SearchSortFromString;
import com.couchbase.client.kotlin.search.SearchSortGeoDistance;
import com.couchbase.client.kotlin.search.SearchSortId;
import com.couchbase.client.kotlin.search.SearchSortScore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/couchbase/client/kotlin/search/SearchSort;", "", "e", "Lcom/couchbase/client/kotlin/search/SearchSortComponent;", "(Lcom/couchbase/client/kotlin/search/SearchSortComponent;)V", "components", "", "(Ljava/util/List;)V", "core", "Lcom/couchbase/client/core/api/search/sort/CoreSearchSort;", "getCore$kotlin_client", "()Ljava/util/List;", "then", "other", "toString", "", "Companion", "kotlin-client"})
@SourceDebugExtension(value={"SMAP\nSearchSort.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchSort.kt\ncom/couchbase/client/kotlin/search/SearchSort\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1549#2:193\n1620#2,3:194\n*S KotlinDebug\n*F\n+ 1 SearchSort.kt\ncom/couchbase/client/kotlin/search/SearchSort\n*L\n65#1:193\n65#1:194,3\n*E\n"})
public final class SearchSort {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<SearchSortComponent> components;
    @NotNull
    private final List<CoreSearchSort> core;

    /*
     * WARNING - void declaration
     */
    public SearchSort(@NotNull List<? extends SearchSortComponent> components) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(components, (String)"components");
        this.components = components;
        Iterable iterable = this.components;
        SearchSort searchSort = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SearchSortComponent searchSortComponent = (SearchSortComponent)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getCore$kotlin_client());
        }
        searchSort.core = (List)destination$iv$iv;
    }

    public SearchSort(@NotNull SearchSortComponent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this(CollectionsKt.listOf((Object)e));
    }

    @NotNull
    public final List<CoreSearchSort> getCore$kotlin_client() {
        return this.core;
    }

    @NotNull
    public final SearchSort then(@NotNull SearchSort other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new SearchSort(CollectionsKt.plus((Collection)this.components, (Iterable)other.components));
    }

    @NotNull
    public String toString() {
        return "SearchSort(" + this.components + ')';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\b\"\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ6\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J*\u0010\u0016\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001b\u001a\u00020\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u001d\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a8\u0006\u001e"}, d2={"Lcom/couchbase/client/kotlin/search/SearchSort$Companion;", "", "()V", "by", "Lcom/couchbase/client/kotlin/search/SearchSort;", "firstSort", "", "remainingSorts", "", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/couchbase/client/kotlin/search/SearchSort;", "sorts", "", "byField", "field", "type", "Lcom/couchbase/client/kotlin/search/FieldType;", "mode", "Lcom/couchbase/client/kotlin/search/Mode;", "missing", "Lcom/couchbase/client/kotlin/search/Missing;", "direction", "Lcom/couchbase/client/kotlin/search/Direction;", "byGeoDistance", "location", "Lcom/couchbase/client/kotlin/search/GeoPoint;", "unit", "Lcom/couchbase/client/kotlin/search/GeoDistanceUnit;", "byId", "byScore", "of", "kotlin-client"})
    @SourceDebugExtension(value={"SMAP\nSearchSort.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchSort.kt\ncom/couchbase/client/kotlin/search/SearchSort$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1549#2:193\n1620#2,3:194\n1360#2:197\n1446#2,5:198\n*S KotlinDebug\n*F\n+ 1 SearchSort.kt\ncom/couchbase/client/kotlin/search/SearchSort$Companion\n*L\n135#1:193\n135#1:194,3\n142#1:197\n142#1:198,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SearchSort byScore(@NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            return new SearchSort(new SearchSortScore(direction));
        }

        public static /* synthetic */ SearchSort byScore$default(Companion companion, Direction direction, int n, Object object) {
            if ((n & 1) != 0) {
                direction = Direction.DESCENDING;
            }
            return companion.byScore(direction);
        }

        @NotNull
        public final SearchSort byId(@NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            return new SearchSort(new SearchSortId(direction));
        }

        public static /* synthetic */ SearchSort byId$default(Companion companion, Direction direction, int n, Object object) {
            if ((n & 1) != 0) {
                direction = Direction.ASCENDING;
            }
            return companion.byId(direction);
        }

        @NotNull
        public final SearchSort byField(@NotNull String field, @NotNull FieldType type, @NotNull Mode mode, @NotNull Missing missing, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)((Object)missing), (String)"missing");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            return new SearchSort(new SearchSortField(field, type, mode, missing, direction));
        }

        public static /* synthetic */ SearchSort byField$default(Companion companion, String string, FieldType fieldType, Mode mode, Missing missing, Direction direction, int n, Object object) {
            if ((n & 2) != 0) {
                fieldType = FieldType.AUTO;
            }
            if ((n & 4) != 0) {
                mode = Mode.DEFAULT;
            }
            if ((n & 8) != 0) {
                missing = Missing.LAST;
            }
            if ((n & 0x10) != 0) {
                direction = Direction.ASCENDING;
            }
            return companion.byField(string, fieldType, mode, missing, direction);
        }

        @NotNull
        public final SearchSort byGeoDistance(@NotNull String field, @NotNull GeoPoint location, @NotNull GeoDistanceUnit unit, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            return new SearchSort(new SearchSortGeoDistance(field, location, unit, direction));
        }

        public static /* synthetic */ SearchSort byGeoDistance$default(Companion companion, String string, GeoPoint geoPoint, GeoDistanceUnit geoDistanceUnit, Direction direction, int n, Object object) {
            if ((n & 4) != 0) {
                geoDistanceUnit = GeoDistanceUnit.METERS;
            }
            if ((n & 8) != 0) {
                direction = Direction.ASCENDING;
            }
            return companion.byGeoDistance(string, geoPoint, geoDistanceUnit, direction);
        }

        @NotNull
        public final SearchSort by(@NotNull String firstSort, String ... remainingSorts) {
            Intrinsics.checkNotNullParameter((Object)firstSort, (String)"firstSort");
            Intrinsics.checkNotNullParameter((Object)remainingSorts, (String)"remainingSorts");
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)firstSort);
            spreadBuilder.addSpread((Object)remainingSorts);
            return this.by(CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SearchSort by(@NotNull List<String> sorts) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(sorts, (String)"sorts");
            Iterable $this$map$iv = sorts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(new SearchSortFromString((String)it));
            }
            List list = (List)destination$iv$iv;
            return new SearchSort(list);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SearchSort of(@NotNull List<SearchSort> sorts) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(sorts, (String)"sorts");
            Iterable $this$flatMap$iv = sorts;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                SearchSort it = (SearchSort)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.components;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            return new SearchSort(list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

