/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.manager.query;

import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.error.IndexesNotReadyException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.manager.CoreQueryIndexManager;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.kotlin.Cluster;
import com.couchbase.client.kotlin.CommonOptions;
import com.couchbase.client.kotlin.Keyspace;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import com.couchbase.client.kotlin.internal.RetryKt;
import com.couchbase.client.kotlin.internal.RetryTimeoutException;
import com.couchbase.client.kotlin.manager.query.QueryIndex;
import com.couchbase.client.kotlin.manager.query.QueryIndexManager;
import com.couchbase.client.kotlin.manager.query.QueryIndexManagerKt;
import com.couchbase.client.kotlin.query.QueryFlowItem;
import com.couchbase.client.kotlin.query.QueryParameters;
import com.couchbase.client.kotlin.query.QueryResult;
import com.couchbase.client.kotlin.query.QueryResultKt;
import com.couchbase.client.kotlin.query.QueryRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJq\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0016\b\u0002\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018Jg\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0016\b\u0002\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJC\u0010\u001b\u001a\u00020\u00062\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001e2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ-\u0010 \u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000e2\b\b\u0002\u0010!\u001a\u00020\u00122\b\b\u0002\u0010\t\u001a\u00020\nH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J5\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010!\u001a\u00020\u0012H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J-\u0010%\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010!\u001a\u00020\u0012H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J;\u0010'\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0)2\b\b\u0002\u0010*\u001a\u00020\u00122\b\b\u0002\u0010\t\u001a\u00020\nH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J)\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJA\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u00020\u000e2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\t\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102JK\u00103\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\b\b\u0002\u0010*\u001a\u00020\u00122\u0006\u00104\u001a\u0002052\b\b\u0002\u0010\t\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b6\u00107R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00068"}, d2={"Lcom/couchbase/client/kotlin/manager/query/QueryIndexManager;", "", "cluster", "Lcom/couchbase/client/kotlin/Cluster;", "(Lcom/couchbase/client/kotlin/Cluster;)V", "buildDeferredIndexes", "", "keyspace", "Lcom/couchbase/client/kotlin/Keyspace;", "common", "Lcom/couchbase/client/kotlin/CommonOptions;", "(Lcom/couchbase/client/kotlin/Keyspace;Lcom/couchbase/client/kotlin/CommonOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createIndex", "indexName", "", "fields", "", "ignoreIfExists", "", "deferred", "numReplicas", "", "with", "", "(Lcom/couchbase/client/kotlin/Keyspace;Ljava/lang/String;Ljava/util/Collection;Lcom/couchbase/client/kotlin/CommonOptions;ZZLjava/lang/Integer;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createPrimaryIndex", "(Lcom/couchbase/client/kotlin/Keyspace;Lcom/couchbase/client/kotlin/CommonOptions;Ljava/lang/String;ZZLjava/lang/Integer;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doCreate", "statement", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/StringBuilder;Ljava/util/Map;ZLcom/couchbase/client/kotlin/CommonOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doDrop", "ignoreIfNotExists", "(Ljava/lang/String;ZLcom/couchbase/client/kotlin/CommonOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropIndex", "(Lcom/couchbase/client/kotlin/Keyspace;Ljava/lang/String;Lcom/couchbase/client/kotlin/CommonOptions;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropPrimaryIndex", "(Lcom/couchbase/client/kotlin/Keyspace;Lcom/couchbase/client/kotlin/CommonOptions;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "failIfIndexesOffline", "indexNames", "", "includePrimary", "(Lcom/couchbase/client/kotlin/Keyspace;Ljava/util/Set;ZLcom/couchbase/client/kotlin/CommonOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllIndexes", "", "Lcom/couchbase/client/kotlin/manager/query/QueryIndex;", "bucket", "scope", "collection", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/couchbase/client/kotlin/CommonOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "watchIndexes", "timeout", "Lkotlin/time/Duration;", "watchIndexes-gwCluXo", "(Lcom/couchbase/client/kotlin/Keyspace;Ljava/util/Collection;ZJLcom/couchbase/client/kotlin/CommonOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kotlin-client"})
public final class QueryIndexManager {
    @NotNull
    private final Cluster cluster;

    public QueryIndexManager(@NotNull Cluster cluster2) {
        Intrinsics.checkNotNullParameter((Object)cluster2, (String)"cluster");
        this.cluster = cluster2;
    }

    @Nullable
    public final Object createPrimaryIndex(@NotNull Keyspace keyspace, @NotNull CommonOptions common, @Nullable String indexName, boolean ignoreIfExists, boolean deferred, @Nullable Integer numReplicas, @NotNull Map<String, ? extends Object> with, @NotNull Continuation<? super Unit> $completion) {
        Integer n = numReplicas;
        if (!((n != null ? n : 0) >= 0)) {
            boolean $i$a$-require-QueryIndexManager$createPrimaryIndex$32 = false;
            String $i$a$-require-QueryIndexManager$createPrimaryIndex$32 = "Number of replicas must be >= 0, but got " + numReplicas;
            throw new IllegalArgumentException($i$a$-require-QueryIndexManager$createPrimaryIndex$32.toString());
        }
        Map actualWith = MapsKt.toMutableMap(with);
        LangExtensionsKt.putIfTrue(actualWith, "defer_build", deferred);
        LangExtensionsKt.putIfNotNull(actualWith, "num_replicas", numReplicas);
        StringBuilder stringBuilder = new StringBuilder().append("CREATE PRIMARY INDEX ");
        String string = indexName;
        if (string == null || (string = QueryIndexManagerKt.access$quote(string)) == null) {
            string = "";
        }
        StringBuilder statement2 = new StringBuilder(stringBuilder.append(string).append(" ON ").append(QueryIndexManagerKt.access$quote(keyspace)).toString());
        Object object = this.doCreate(statement2, actualWith, ignoreIfExists, common, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object createPrimaryIndex$default(QueryIndexManager queryIndexManager, Keyspace keyspace, CommonOptions commonOptions, String string, boolean bl, boolean bl2, Integer n, Map map2, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            n = null;
        }
        if ((n2 & 0x40) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return queryIndexManager.createPrimaryIndex(keyspace, commonOptions, string, bl, bl2, n, map2, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object dropPrimaryIndex(@NotNull Keyspace keyspace, @NotNull CommonOptions common, boolean ignoreIfNotExists, @NotNull Continuation<? super Unit> $completion) {
        String statement2 = "DROP PRIMARY INDEX ON " + QueryIndexManagerKt.access$quote(keyspace);
        Object object = this.doDrop(statement2, ignoreIfNotExists, common, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object dropPrimaryIndex$default(QueryIndexManager queryIndexManager, Keyspace keyspace, CommonOptions commonOptions, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return queryIndexManager.dropPrimaryIndex(keyspace, commonOptions, bl, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object dropIndex(@NotNull Keyspace keyspace, @NotNull String indexName, @NotNull CommonOptions common, boolean ignoreIfNotExists, @NotNull Continuation<? super Unit> $completion) {
        String string;
        if (QueryIndexManagerKt.access$isDefaultCollection(keyspace)) {
            String[] stringArray = new String[]{keyspace.getBucket(), indexName};
            string = "DROP INDEX " + QueryIndexManagerKt.access$quote(stringArray);
        } else {
            string = "DROP INDEX " + QueryIndexManagerKt.access$quote(indexName) + " ON " + QueryIndexManagerKt.access$quote(keyspace);
        }
        String statement2 = string;
        Object object = this.doDrop(statement2, ignoreIfNotExists, common, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object dropIndex$default(QueryIndexManager queryIndexManager, Keyspace keyspace, String string, CommonOptions commonOptions, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return queryIndexManager.dropIndex(keyspace, string, commonOptions, bl, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object createIndex(@NotNull Keyspace keyspace, @NotNull String indexName, @NotNull Collection<String> fields, @NotNull CommonOptions common, boolean ignoreIfExists, boolean deferred, @Nullable Integer numReplicas, @NotNull Map<String, ? extends Object> with, @NotNull Continuation<? super Unit> $completion) {
        Integer n = numReplicas;
        if (!((n != null ? n : 0) >= 0)) {
            boolean $i$a$-require-QueryIndexManager$createIndex$42 = false;
            String $i$a$-require-QueryIndexManager$createIndex$42 = "Number of replicas must be >= 0, but got " + numReplicas;
            throw new IllegalArgumentException($i$a$-require-QueryIndexManager$createIndex$42.toString());
        }
        if (!(!fields.isEmpty())) {
            boolean $i$a$-require-QueryIndexManager$createIndex$52 = false;
            String $i$a$-require-QueryIndexManager$createIndex$52 = "Must specify at least one field to index.";
            throw new IllegalArgumentException($i$a$-require-QueryIndexManager$createIndex$52.toString());
        }
        Map actualWith = MapsKt.toMutableMap(with);
        LangExtensionsKt.putIfTrue(actualWith, "defer_build", deferred);
        LangExtensionsKt.putIfNotNull(actualWith, "num_replicas", numReplicas);
        String formattedFields = '(' + CollectionsKt.joinToString$default((Iterable)fields, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')';
        StringBuilder statement2 = new StringBuilder("CREATE INDEX " + QueryIndexManagerKt.access$quote(indexName) + " ON " + QueryIndexManagerKt.access$quote(keyspace) + formattedFields);
        Object object = this.doCreate(statement2, actualWith, ignoreIfExists, common, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object createIndex$default(QueryIndexManager queryIndexManager, Keyspace keyspace, String string, Collection collection2, CommonOptions commonOptions, boolean bl, boolean bl2, Integer n, Map map2, Continuation continuation, int n2, Object object) {
        if ((n2 & 8) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            n = null;
        }
        if ((n2 & 0x80) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return queryIndexManager.createIndex(keyspace, string, collection2, commonOptions, bl, bl2, n, map2, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object doCreate(StringBuilder var1_1, Map<String, ? extends Object> var2_2, boolean var3_3, CommonOptions var4_4, Continuation<? super Unit> var5_5) {
        if (!(var5_5 instanceof doCreate.1)) ** GOTO lbl-1000
        var12_6 = var5_5;
        if ((var12_6.label & -2147483648) != 0) {
            var12_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ QueryIndexManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return QueryIndexManager.access$doCreate(this.this$0, null, null, false, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (with.isEmpty() == false) {
                    statement.append(" WITH ").append(Mapper.encodeAsString((Object)with));
                }
                var6_9 = statement.toString();
                Intrinsics.checkNotNullExpressionValue((Object)var6_9, (String)"statement.toString()");
                $continuation.Z$0 = ignoreIfExists;
                $continuation.label = 1;
                v0 = QueryResultKt.execute((Flow<? extends QueryFlowItem>)Cluster.query$default(this.cluster, var6_9, (CommonOptions)common, null, false, null, null, false, false, false, false, null, null, null, null, null, null, null, null, 262140, null), (Continuation<? super QueryResult>)$continuation);
                ** if (v0 != var13_8) goto lbl-1000
lbl23:
                // 1 sources

                return var13_8;
lbl-1000:
                // 1 sources

                {
                }
            }
            case 1: {
                ignoreIfExists = $continuation.Z$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable t) {
                    if (!ignoreIfExists) ** GOTO lbl39
                    $this$hasCause$iv = t;
                    $i$f$hasCause = false;
                    $this$findCause$iv$iv = $this$hasCause$iv;
                    $i$f$findCause = false;
                    if ((Throwable)CbThrowables.findCause((Throwable)$this$findCause$iv$iv, IndexExistsException.class).orElse(null) != null) ** GOTO lbl40
lbl39:
                    // 2 sources

                    throw t;
                }
lbl40:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object doDrop(String var1_1, boolean var2_2, CommonOptions var3_3, Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof doDrop.1)) ** GOTO lbl-1000
        var11_5 = var4_4;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ QueryIndexManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return QueryIndexManager.access$doDrop(this.this$0, null, false, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.Z$0 = ignoreIfNotExists;
                $continuation.label = 1;
                v0 = QueryResultKt.execute((Flow<? extends QueryFlowItem>)Cluster.query$default(this.cluster, var1_1, var3_3, null, false, null, null, false, false, false, false, null, null, null, null, null, null, null, null, 262140, null), (Continuation<? super QueryResult>)$continuation);
                ** if (v0 != var12_7) goto lbl-1000
lbl18:
                // 1 sources

                return var12_7;
lbl-1000:
                // 1 sources

                {
                }
            }
            case 1: {
                ignoreIfNotExists = $continuation.Z$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable t) {
                    if (!ignoreIfNotExists) ** GOTO lbl34
                    $this$hasCause$iv = t;
                    $i$f$hasCause = false;
                    $this$findCause$iv$iv = $this$hasCause$iv;
                    $i$f$findCause = false;
                    if ((Throwable)CbThrowables.findCause((Throwable)$this$findCause$iv$iv, IndexNotFoundException.class).orElse(null) != null) ** GOTO lbl35
lbl34:
                    // 2 sources

                    throw t;
                }
lbl35:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object doDrop$default(QueryIndexManager queryIndexManager, String string, boolean bl, CommonOptions commonOptions, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        return queryIndexManager.doDrop(string, bl, commonOptions, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object getAllIndexes(@NotNull Keyspace keyspace, @NotNull CommonOptions common, @NotNull Continuation<? super List<QueryIndex>> $completion) {
        return this.getAllIndexes(keyspace.getBucket(), keyspace.getScope(), keyspace.getCollection(), common, $completion);
    }

    public static /* synthetic */ Object getAllIndexes$default(QueryIndexManager queryIndexManager, Keyspace keyspace, CommonOptions commonOptions, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        return queryIndexManager.getAllIndexes(keyspace, commonOptions, (Continuation<? super List<QueryIndex>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getAllIndexes(@NotNull String var1_1, @Nullable String var2_2, @Nullable String var3_3, @NotNull CommonOptions var4_4, @NotNull Continuation<? super List<QueryIndex>> var5_5) {
        if (!(var5_5 instanceof getAllIndexes.2)) ** GOTO lbl-1000
        var17_6 = var5_5;
        if ((var17_6.label & -2147483648) != 0) {
            var17_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                /* synthetic */ Object result;
                final /* synthetic */ QueryIndexManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getAllIndexes(null, null, null, null, (Continuation<? super List<QueryIndex>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_9 = this.cluster;
                var7_10 = CoreQueryIndexManager.getStatementForGetAllIndexes((String)bucket, (String)scope, (String)collection);
                var9_12 = CoreQueryIndexManager.getNamedParamsForGetAllIndexes((String)bucket, (String)scope, (String)collection);
                Intrinsics.checkNotNullExpressionValue((Object)var9_12, (String)"getNamedParamsForGetAllI\u2026ucket, scope, collection)");
                var8_13 = QueryParameters.Companion.named(var9_12);
                Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"getStatementForGetAllInd\u2026ucket, scope, collection)");
                $continuation.label = 1;
                v0 = QueryResultKt.execute((Flow<? extends QueryFlowItem>)Cluster.query$default(var6_9, var7_10, (CommonOptions)common, (QueryParameters)var8_13, false, null, null, true, false, false, false, null, null, null, null, null, null, null, null, 262072, null), (Continuation<? super QueryResult>)$continuation);
                if (v0 == var18_8) {
                    return var18_8;
                }
                ** GOTO lbl26
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                $this$map$iv = ((QueryResult)v0).getRows();
                $i$f$map = false;
                var8_13 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var13_17 = (QueryRow)item$iv$iv;
                    var15_19 = destination$iv$iv;
                    $i$a$-map-QueryIndexManager$getAllIndexes$3 = false;
                    var15_19.add(QueryIndex.Companion.parse$kotlin_client(it.getContent()));
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object getAllIndexes$default(QueryIndexManager queryIndexManager, String string, String string2, String string3, CommonOptions commonOptions, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        return queryIndexManager.getAllIndexes(string, string2, string3, commonOptions, (Continuation<? super List<QueryIndex>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object buildDeferredIndexes(@NotNull Keyspace var1_1, @NotNull CommonOptions var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof buildDeferredIndexes.1)) ** GOTO lbl-1000
        var16_4 = var3_3;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ QueryIndexManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.buildDeferredIndexes(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = keyspace;
                $continuation.L$2 = common;
                $continuation.label = 1;
                v0 = this.getAllIndexes(keyspace, common, (Continuation<? super List<QueryIndex>>)$continuation);
                if (v0 == var17_6) {
                    return var17_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                common = (CommonOptions)$continuation.L$2;
                keyspace = (Keyspace)$continuation.L$1;
                this = (QueryIndexManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                $this$filter$iv = (Iterable)v0;
                $i$f$filter = false;
                var7_9 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (QueryIndex)element$iv$iv;
                    $i$a$-filter-QueryIndexManager$buildDeferredIndexes$indexNames$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getState(), (Object)"deferred")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (QueryIndex)item$iv$iv;
                    var14_16 = destination$iv$iv;
                    $i$a$-map-QueryIndexManager$buildDeferredIndexes$indexNames$2 = false;
                    var14_16.add(it.getName());
                }
                indexNames = (List)destination$iv$iv;
                if (indexNames.isEmpty()) {
                    return Unit.INSTANCE;
                }
                statement = "BUILD INDEX ON " + QueryIndexManagerKt.access$quote(keyspace) + " (" + CollectionsKt.joinToString$default((Iterable)indexNames, (CharSequence)",", null, null, (int)0, null, (Function1)buildDeferredIndexes.statement.1.INSTANCE, (int)30, null) + ')';
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = QueryResultKt.execute((Flow<? extends QueryFlowItem>)Cluster.query$default(this.cluster, statement, var2_2, null, false, null, null, false, false, false, false, null, null, null, null, null, null, null, null, 262140, null), (Continuation<? super QueryResult>)$continuation);
                if (v1 == var17_6) {
                    return var17_6;
                }
                ** GOTO lbl65
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl65:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object buildDeferredIndexes$default(QueryIndexManager queryIndexManager, Keyspace keyspace, CommonOptions commonOptions, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        return queryIndexManager.buildDeferredIndexes(keyspace, commonOptions, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object watchIndexes-gwCluXo(@NotNull Keyspace var1_1, @NotNull Collection<String> var2_2, boolean var3_3, long var4_4, @NotNull CommonOptions var6_5, @NotNull Continuation<? super Unit> var7_6) {
        if (!(var7_6 instanceof watchIndexes.1)) ** GOTO lbl-1000
        var14_7 = var7_6;
        if ((var14_7.label & -2147483648) != 0) {
            var14_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var7_6){
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ QueryIndexManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.watchIndexes-gwCluXo(null, null, false, 0L, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                indexNameSet = CollectionsKt.toSet((Iterable)((Iterable)indexNames));
                $continuation.J$0 = timeout;
                $continuation.label = 1;
                v0 = RetryKt.retry-rnQQ1Ag(timeout, (Function1<? super Throwable, Boolean>)((Function1)watchIndexes.2.INSTANCE), (Function1)new Function1<Continuation<? super Unit>, Object>(this, (Keyspace)keyspace, (Set<String>)indexNameSet, includePrimary != false, (CommonOptions)common, null){
                    int label;
                    final /* synthetic */ QueryIndexManager this$0;
                    final /* synthetic */ Keyspace $keyspace;
                    final /* synthetic */ Set<String> $indexNameSet;
                    final /* synthetic */ boolean $includePrimary;
                    final /* synthetic */ CommonOptions $common;
                    {
                        this.this$0 = $receiver;
                        this.$keyspace = $keyspace;
                        this.$indexNameSet = $indexNameSet;
                        this.$includePrimary = $includePrimary;
                        this.$common = $common;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = QueryIndexManager.access$failIfIndexesOffline(this.this$0, this.$keyspace, this.$indexNameSet, this.$includePrimary, this.$common, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v0 != var15_9) goto lbl20
lbl19:
                // 1 sources

                return var15_9;
lbl20:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                timeout = $continuation.J$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (RetryTimeoutException t) {
                    msg = new StringBuilder("A requested index is still not ready after " + Duration.toString-impl((long)timeout) + '.');
                    $this$findCause$iv = t.getLastError();
                    $i$f$findCause = false;
                    v1 = (IndexesNotReadyException)((Throwable)CbThrowables.findCause((Throwable)$this$findCause$iv, IndexesNotReadyException.class).orElse(null));
                    if (v1 != null) {
                        notReady = v1;
                        $i$a$-let-QueryIndexManager$watchIndexes$4 = false;
                        msg.append(" Unready index keyspace/name -> state: ").append(RedactableArgument.redactMeta((Object)notReady.indexNameToState()));
                    }
                    throw new UnambiguousTimeoutException(msg.toString(), null);
                }
lbl40:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object watchIndexes-gwCluXo$default(QueryIndexManager queryIndexManager, Keyspace keyspace, Collection collection2, boolean bl, long l, CommonOptions commonOptions, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        return queryIndexManager.watchIndexes-gwCluXo(keyspace, collection2, bl, l, commonOptions, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object failIfIndexesOffline(Keyspace var1_1, Set<String> var2_2, boolean var3_3, CommonOptions var4_4, Continuation<? super Unit> var5_5) {
        if (!(var5_5 instanceof failIfIndexesOffline.1)) ** GOTO lbl-1000
        var23_6 = var5_5;
        if ((var23_6.label & -2147483648) != 0) {
            var23_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ QueryIndexManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return QueryIndexManager.access$failIfIndexesOffline(this.this$0, null, null, false, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = indexNames;
                $continuation.Z$0 = includePrimary;
                $continuation.label = 1;
                v0 = this.getAllIndexes((Keyspace)keyspace, (CommonOptions)common, (Continuation<? super List<QueryIndex>>)$continuation);
                if (v0 == var24_8) {
                    return var24_8;
                }
                ** GOTO lbl24
            }
            case 1: {
                includePrimary = $continuation.Z$0;
                indexNames = (Set)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                $this$filter$iv = (Iterable)v0;
                $i$f$filter = false;
                var9_12 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var12_21 = $this$filterTo$iv$iv.iterator();
                while (var12_21.hasNext()) {
                    element$iv$iv = var12_21.next();
                    it = (QueryIndex)element$iv$iv;
                    $i$a$-filter-QueryIndexManager$failIfIndexesOffline$indexes$1 = false;
                    if (!(indexNames.contains(it.getName()) != false || includePrimary != false && it.getPrimary() != false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                indexes = (List)destination$iv$iv;
                if (!includePrimary) ** GOTO lbl54
                $this$any$iv = indexes;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl45
                v1 = false;
                ** GOTO lbl52
lbl45:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (QueryIndex)element$iv;
                    $i$a$-any-QueryIndexManager$failIfIndexesOffline$2 = false;
                    if (!it.getPrimary()) continue;
                    v1 = true;
                    ** GOTO lbl52
                }
                v1 = false;
lbl52:
                // 3 sources

                if (!v1) {
                    throw new IndexNotFoundException("#primary");
                }
lbl54:
                // 3 sources

                $i$f$any = indexes;
                var19_35 = indexNames;
                $i$f$map = false;
                element$iv = $this$map$iv;
                destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    $i$a$-filter-QueryIndexManager$failIfIndexesOffline$indexes$1 = (QueryIndex)item$iv$iv;
                    var20_39 = destination$iv$iv /* !! */ ;
                    $i$a$-map-QueryIndexManager$failIfIndexesOffline$missingIndexNames$1 = false;
                    var20_39.add(it.getName());
                }
                missingIndexNames = SetsKt.minus((Set)var19_35, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv /* !! */ )));
                if (((Collection)missingIndexNames).isEmpty() == false) {
                    throw new IndexNotFoundException(missingIndexNames.toString());
                }
                $this$filter$iv = indexes;
                $i$f$filter = false;
                destination$iv$iv /* !! */  = $this$filter$iv;
                destination$iv$iv /* !! */  = new ArrayList<E>();
                $i$f$filterTo = false;
                for (E element$iv$iv : $this$filterTo$iv$iv) {
                    it = (QueryIndex)element$iv$iv;
                    $i$a$-filter-QueryIndexManager$failIfIndexesOffline$offlineIndexNameToState$1 = false;
                    if (!(Intrinsics.areEqual((Object)it.getState(), (Object)"online") == false)) continue;
                    destination$iv$iv /* !! */ .add(element$iv$iv);
                }
                $this$associateBy$iv = (List)destination$iv$iv /* !! */ ;
                $i$f$associateBy = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                destination$iv$iv /* !! */  = $this$associateBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    $i$a$-filter-QueryIndexManager$failIfIndexesOffline$offlineIndexNameToState$1 = (QueryIndex)element$iv$iv;
                    var19_35 = destination$iv$iv;
                    $i$a$-associateBy-QueryIndexManager$failIfIndexesOffline$offlineIndexNameToState$2 = false;
                    it = (QueryIndex)element$iv$iv;
                    var20_39 = it.getKeyspace().format$kotlin_client() + '/' + it.getName();
                    $i$a$-associateBy-QueryIndexManager$failIfIndexesOffline$offlineIndexNameToState$3 = false;
                    var21_43 = p0.getState();
                    var19_35.put(var20_39, var21_43);
                }
                offlineIndexNameToState = destination$iv$iv;
                if (offlineIndexNameToState.isEmpty() == false) {
                    throw new IndexesNotReadyException(offlineIndexNameToState);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object failIfIndexesOffline$default(QueryIndexManager queryIndexManager, Keyspace keyspace, Set set, boolean bl, CommonOptions commonOptions, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        return queryIndexManager.failIfIndexesOffline(keyspace, set, bl, commonOptions, (Continuation<? super Unit>)continuation);
    }

    public static final /* synthetic */ Object access$doCreate(QueryIndexManager $this, StringBuilder statement2, Map with, boolean ignoreIfExists, CommonOptions common, Continuation $completion) {
        return $this.doCreate(statement2, with, ignoreIfExists, common, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$doDrop(QueryIndexManager $this, String statement2, boolean ignoreIfNotExists, CommonOptions common, Continuation $completion) {
        return $this.doDrop(statement2, ignoreIfNotExists, common, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$failIfIndexesOffline(QueryIndexManager $this, Keyspace keyspace, Set indexNames, boolean includePrimary, CommonOptions common, Continuation $completion) {
        return $this.failIfIndexesOffline(keyspace, indexNames, includePrimary, common, (Continuation<? super Unit>)$completion);
    }
}

