/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.manager.query;

import com.couchbase.client.core.api.manager.CoreQueryIndex;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.kotlin.Keyspace;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0012\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BW\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\"\u001a\u00020\bH\u0016R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0015R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/couchbase/client/kotlin/manager/query/QueryIndex;", "", "core", "Lcom/couchbase/client/core/api/manager/CoreQueryIndex;", "(Lcom/couchbase/client/core/api/manager/CoreQueryIndex;)V", "keyspace", "Lcom/couchbase/client/kotlin/Keyspace;", "name", "", "primary", "", "state", "type", "indexKey", "", "condition", "partition", "raw", "", "(Lcom/couchbase/client/kotlin/Keyspace;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;[B)V", "getCondition", "()Ljava/lang/String;", "getIndexKey", "()Ljava/util/List;", "getKeyspace", "()Lcom/couchbase/client/kotlin/Keyspace;", "getName", "getPartition", "getPrimary", "()Z", "getRaw", "()[B", "getState", "getType", "toString", "Companion", "kotlin-client"})
public final class QueryIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Keyspace keyspace;
    @NotNull
    private final String name;
    private final boolean primary;
    @NotNull
    private final String state;
    @NotNull
    private final String type;
    @NotNull
    private final List<String> indexKey;
    @Nullable
    private final String condition;
    @Nullable
    private final String partition;
    @NotNull
    private final byte[] raw;

    public QueryIndex(@NotNull Keyspace keyspace, @NotNull String name, boolean primary, @NotNull String state, @NotNull String type, @NotNull List<String> indexKey, @Nullable String condition, @Nullable String partition, @NotNull byte[] raw) {
        Intrinsics.checkNotNullParameter((Object)keyspace, (String)"keyspace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(indexKey, (String)"indexKey");
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        this.keyspace = keyspace;
        this.name = name;
        this.primary = primary;
        this.state = state;
        this.type = type;
        this.indexKey = indexKey;
        this.condition = condition;
        this.partition = partition;
        this.raw = raw;
    }

    @NotNull
    public final Keyspace getKeyspace() {
        return this.keyspace;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getPrimary() {
        return this.primary;
    }

    @NotNull
    public final String getState() {
        return this.state;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final List<String> getIndexKey() {
        return this.indexKey;
    }

    @Nullable
    public final String getCondition() {
        return this.condition;
    }

    @Nullable
    public final String getPartition() {
        return this.partition;
    }

    @NotNull
    public final byte[] getRaw() {
        return this.raw;
    }

    public QueryIndex(@NotNull CoreQueryIndex core) {
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        String string = core.bucketName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"core.bucketName()");
        String string2 = core.scopeName().orElse("_default");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"core.scopeName().orElse(DEFAULT_SCOPE)");
        String string3 = core.collectionName().orElse("_default");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"core.collectionName().orElse(DEFAULT_COLLECTION)");
        Keyspace keyspace = new Keyspace(string, string2, string3);
        String string4 = core.name();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"core.name()");
        boolean bl = core.primary();
        String string5 = core.state();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"core.state()");
        String string6 = core.type();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"core.type()");
        Object object = Mapper.convertValue((Object)core.indexKey(), (TypeReference)((TypeReference)new TypeReference<List<? extends String>>(){}));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"convertValue(core.indexK\u2026rence<List<String>>() {})");
        List list = (List)object;
        String string7 = core.condition().orElse(null);
        String string8 = core.partition().orElse(null);
        byte[] byArray = Mapper.encodeAsBytes((Object)core.raw());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encodeAsBytes(core.raw())");
        this(keyspace, string4, bl, string5, string6, list, string7, string8, byArray);
    }

    @NotNull
    public String toString() {
        return "QueryIndex(keyspace=" + this.keyspace + ", name='" + this.name + "', primary=" + this.primary + ", state='" + this.state + "', type='" + this.type + "', indexKey=" + this.indexKey + ", condition=" + this.condition + ", partition=" + this.partition + ", raw=" + LangExtensionsKt.toStringUtf8(this.raw) + ')';
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/couchbase/client/kotlin/manager/query/QueryIndex$Companion;", "", "()V", "parse", "Lcom/couchbase/client/kotlin/manager/query/QueryIndex;", "jsonBytes", "", "parse$kotlin_client", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final QueryIndex parse$kotlin_client(@NotNull byte[] jsonBytes) {
            String string;
            List list;
            String string2;
            Object object;
            Keyspace keyspace;
            Intrinsics.checkNotNullParameter((Object)jsonBytes, (String)"jsonBytes");
            JsonNode json = Mapper.decodeIntoTree((byte[])jsonBytes);
            JsonNode bucketId = json.path("bucket_id");
            if (bucketId.isMissingNode()) {
                String string3 = json.path("keyspace_id").textValue();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"json.path(\"keyspace_id\").textValue()");
                keyspace = new Keyspace(string3, null, null, 6, null);
            } else {
                String string4 = bucketId.textValue();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"bucketId.textValue()");
                String string5 = json.path("scope_id").textValue();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"json.path(\"scope_id\").textValue()");
                String string6 = json.path("keyspace_id").textValue();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"json.path(\"keyspace_id\").textValue()");
                keyspace = new Keyspace(string4, string5, string6);
            }
            Keyspace keyspace2 = keyspace;
            String string7 = json.get("name").asText("");
            boolean bl = json.path("is_primary").booleanValue();
            String string8 = json.path("state").asText("");
            String string9 = json.path("condition").textValue();
            if (string9 != null) {
                CharSequence charSequence;
                object = string9;
                if (StringsKt.isBlank((CharSequence)object)) {
                    boolean bl2 = false;
                    charSequence = null;
                } else {
                    charSequence = object;
                }
                string2 = (String)charSequence;
            } else {
                string2 = null;
            }
            String string10 = string2;
            String string11 = json.path("using").asText("gsi");
            JsonNode jsonNode = json.get("index_key");
            ArrayNode arrayNode = jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
            if (arrayNode != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)arrayNode;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.asText());
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            object = list;
            String string12 = json.path("partition").textValue();
            if (string12 != null) {
                CharSequence charSequence;
                CharSequence charSequence2 = string12;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl4 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                string = (String)charSequence;
            } else {
                string = null;
            }
            String string13 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"asText(\"\")");
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"asText(\"\")");
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"asText(\"gsi\")");
            return new QueryIndex(keyspace2, string7, bl, string8, string11, (List<String>)object, string10, string13, jsonBytes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

