/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.search;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.search.SearchChunkHeader;
import com.couchbase.client.core.msg.search.SearchChunkTrailer;
import com.couchbase.client.kotlin.search.BaseFacetResult;
import com.couchbase.client.kotlin.search.Category;
import com.couchbase.client.kotlin.search.CategoryResult;
import com.couchbase.client.kotlin.search.DateFacetResult;
import com.couchbase.client.kotlin.search.DateRange;
import com.couchbase.client.kotlin.search.FacetResult;
import com.couchbase.client.kotlin.search.FrequentTerm;
import com.couchbase.client.kotlin.search.NumericFacetResult;
import com.couchbase.client.kotlin.search.NumericRange;
import com.couchbase.client.kotlin.search.ParsedSearchHeader;
import com.couchbase.client.kotlin.search.SearchFlowItemKt;
import com.couchbase.client.kotlin.search.TermFacetResult;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000+\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0003\u0001\u0004\u0007\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0000\u001a\u0016\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r*\u00020\u000fH\u0000\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\"\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0010"}, d2={"LIST_OF_STRINGS", "com/couchbase/client/kotlin/search/SearchFlowItemKt$LIST_OF_STRINGS$1", "Lcom/couchbase/client/kotlin/search/SearchFlowItemKt$LIST_OF_STRINGS$1;", "MAP_FROM_STRING_TO_STRING", "com/couchbase/client/kotlin/search/SearchFlowItemKt$MAP_FROM_STRING_TO_STRING$1", "Lcom/couchbase/client/kotlin/search/SearchFlowItemKt$MAP_FROM_STRING_TO_STRING$1;", "MULTIMAP_FROM_STRING_TO_STRING", "com/couchbase/client/kotlin/search/SearchFlowItemKt$MULTIMAP_FROM_STRING_TO_STRING$1", "Lcom/couchbase/client/kotlin/search/SearchFlowItemKt$MULTIMAP_FROM_STRING_TO_STRING$1;", "parse", "Lcom/couchbase/client/kotlin/search/ParsedSearchHeader;", "Lcom/couchbase/client/core/msg/search/SearchChunkHeader;", "parseFacets", "", "Lcom/couchbase/client/kotlin/search/FacetResult;", "Lcom/couchbase/client/core/msg/search/SearchChunkTrailer;", "kotlin-client"})
public final class SearchFlowItemKt {
    @NotNull
    private static final LIST_OF_STRINGS.1 LIST_OF_STRINGS = new TypeReference<List<? extends String>>(){};
    @NotNull
    private static final MAP_FROM_STRING_TO_STRING.1 MAP_FROM_STRING_TO_STRING = new TypeReference<Map<String, ? extends String>>(){};
    @NotNull
    private static final MULTIMAP_FROM_STRING_TO_STRING.1 MULTIMAP_FROM_STRING_TO_STRING = new TypeReference<Map<String, ? extends List<? extends String>>>(){};

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ParsedSearchHeader parse(@NotNull SearchChunkHeader $this$parse) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)$this$parse, (String)"<this>");
        JsonNode json = Mapper.decodeIntoTree((byte[])$this$parse.getStatus());
        int n = json.path("failed").asInt();
        int n2 = json.path("successful").asInt();
        JsonNode jsonNode = json.get("errors");
        if (jsonNode != null) {
            void errorsNode;
            JsonNode jsonNode2 = jsonNode;
            int n3 = n2;
            int n4 = n;
            boolean bl = false;
            Map map3 = (Map)Mapper.convertValue((Object)errorsNode, (TypeReference)MAP_FROM_STRING_TO_STRING);
            n = n4;
            n2 = n3;
            map2 = map3;
        } else {
            map2 = null;
        }
        Map map4 = map2;
        Map map5 = map4 == null ? MapsKt.emptyMap() : map4;
        int n5 = n2;
        int n6 = n;
        return new ParsedSearchHeader(n6, n5, map5);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FacetResult<?>> parseFacets(@NotNull SearchChunkTrailer $this$parseFacets) {
        block18: {
            block17: {
                Intrinsics.checkNotNullParameter((Object)$this$parseFacets, (String)"<this>");
                if ($this$parseFacets.facets() == null) break block17;
                byte[] byArray = $this$parseFacets.facets();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"facets()");
                if (!(byArray.length == 0)) break block18;
            }
            return CollectionsKt.emptyList();
        }
        JsonNode jsonNode = Mapper.decodeIntoTree((byte[])$this$parseFacets.facets());
        ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
        if (objectNode == null) {
            return CollectionsKt.emptyList();
        }
        ObjectNode json = objectNode;
        List result2 = new ArrayList();
        Iterator iterator = json.fields();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"json.fields()");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object object;
            Object object2;
            String string;
            ArrayNode ranges;
            JsonNode it;
            boolean $i$f$forEach2;
            Iterable $this$forEach$iv2;
            List categories;
            Object element$iv = iterator2.next();
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(facetName, facetJson)");
            String facetName = (String)entry.getKey();
            JsonNode facetJson = (JsonNode)entry.getValue();
            String field = facetJson.path("field").asText();
            long total = facetJson.path("total").asLong();
            long missing = facetJson.path("missing").asLong();
            long other = facetJson.path("other").asLong();
            if (facetJson.has("terms")) {
                categories = new ArrayList();
                JsonNode jsonNode2 = facetJson.get("terms");
                if (jsonNode2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode");
                }
                ArrayNode terms = (ArrayNode)jsonNode2;
                $this$forEach$iv2 = (Iterable)terms;
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    it = (JsonNode)element$iv2;
                    boolean bl2 = false;
                    String string2 = it.path("term").asText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.path(\"term\").asText()");
                    categories.add(new CategoryResult<Category>(new FrequentTerm(string2), it.path("count").asLong()));
                }
                Intrinsics.checkNotNullExpressionValue((Object)facetName, (String)"facetName");
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
                result2.add(new TermFacetResult(new BaseFacetResult<FrequentTerm>(facetName, field, total, missing, other, categories)));
                continue;
            }
            if (facetJson.has("numeric_ranges")) {
                categories = new ArrayList();
                JsonNode jsonNode3 = facetJson.get("numeric_ranges");
                if (jsonNode3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode");
                }
                ranges = (ArrayNode)jsonNode3;
                $this$forEach$iv2 = (Iterable)ranges;
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    it = (JsonNode)element$iv2;
                    boolean bl3 = false;
                    string = it.path("name").asText();
                    JsonNode jsonNode4 = it.get("min");
                    object2 = jsonNode4 != null ? Double.valueOf(jsonNode4.asDouble()) : null;
                    JsonNode jsonNode5 = it.get("max");
                    object = jsonNode5 != null ? Double.valueOf(jsonNode5.asDouble()) : null;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText()");
                    categories.add(new CategoryResult<Category>(new NumericRange((Double)object2, (Double)object, string), it.path("count").asLong()));
                }
                Intrinsics.checkNotNullExpressionValue((Object)facetName, (String)"facetName");
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
                result2.add(new NumericFacetResult(new BaseFacetResult<NumericRange>(facetName, field, total, missing, other, categories)));
                continue;
            }
            if (!facetJson.has("date_ranges")) continue;
            categories = new ArrayList();
            JsonNode jsonNode6 = facetJson.get("date_ranges");
            if (jsonNode6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode");
            }
            ranges = (ArrayNode)jsonNode6;
            $this$forEach$iv2 = (Iterable)ranges;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Instant instant;
                String string3;
                Object object3;
                Instant instant2;
                Instant instant3;
                List list;
                it = (JsonNode)element$iv2;
                boolean bl4 = false;
                List list2 = categories;
                string = it.path("name").asText();
                Object object4 = it.get("start");
                if (object4 != null && (object4 = (object2 = object4.textValue())) != null) {
                    void timestamp;
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"textValue()");
                    object = object2;
                    list = list2;
                    boolean bl5 = false;
                    instant3 = Instant.parse((CharSequence)timestamp);
                    list2 = list;
                } else {
                    instant3 = instant2 = null;
                }
                if ((object3 = it.get("end")) != null && (object3 = (string3 = object3.textValue())) != null) {
                    void timestamp;
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"textValue()");
                    String bl5 = string3;
                    list = list2;
                    boolean bl6 = false;
                    instant = Instant.parse((CharSequence)timestamp);
                    list2 = list;
                } else {
                    instant = null;
                }
                Instant instant4 = instant;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText()");
                long l = it.path("count").asLong();
                Category category = new DateRange(instant2, instant4, string);
                list2.add(new CategoryResult<Category>(category, l));
            }
            Intrinsics.checkNotNullExpressionValue((Object)facetName, (String)"facetName");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            result2.add(new DateFacetResult(new BaseFacetResult<DateRange>(facetName, field, total, missing, other, categories)));
        }
        return result2;
    }

    public static final /* synthetic */ LIST_OF_STRINGS.1 access$getLIST_OF_STRINGS$p() {
        return LIST_OF_STRINGS;
    }

    public static final /* synthetic */ MULTIMAP_FROM_STRING_TO_STRING.1 access$getMULTIMAP_FROM_STRING_TO_STRING$p() {
        return MULTIMAP_FROM_STRING_TO_STRING;
    }
}

