/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.search;

import com.couchbase.client.kotlin.search.DateFacet;
import com.couchbase.client.kotlin.search.DateFacetResult;
import com.couchbase.client.kotlin.search.FacetResult;
import com.couchbase.client.kotlin.search.FacetResultAccessor;
import com.couchbase.client.kotlin.search.NumericFacet;
import com.couchbase.client.kotlin.search.NumericFacetResult;
import com.couchbase.client.kotlin.search.SearchMetadata;
import com.couchbase.client.kotlin.search.SearchRow;
import com.couchbase.client.kotlin.search.TermFacet;
import com.couchbase.client.kotlin.search.TermFacetResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0003J\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u0014H\u0096\u0003J\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u0016H\u0096\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001c\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0003X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/couchbase/client/kotlin/search/SearchResult;", "Lcom/couchbase/client/kotlin/search/FacetResultAccessor;", "rows", "", "Lcom/couchbase/client/kotlin/search/SearchRow;", "metadata", "Lcom/couchbase/client/kotlin/search/SearchMetadata;", "(Ljava/util/List;Lcom/couchbase/client/kotlin/search/SearchMetadata;)V", "facets", "Lcom/couchbase/client/kotlin/search/FacetResult;", "getFacets", "()Ljava/util/List;", "getMetadata", "()Lcom/couchbase/client/kotlin/search/SearchMetadata;", "getRows", "get", "Lcom/couchbase/client/kotlin/search/DateFacetResult;", "facet", "Lcom/couchbase/client/kotlin/search/DateFacet;", "Lcom/couchbase/client/kotlin/search/NumericFacetResult;", "Lcom/couchbase/client/kotlin/search/NumericFacet;", "Lcom/couchbase/client/kotlin/search/TermFacetResult;", "Lcom/couchbase/client/kotlin/search/TermFacet;", "toString", "", "kotlin-client"})
public final class SearchResult
implements FacetResultAccessor {
    @NotNull
    private final List<SearchRow> rows;
    @NotNull
    private final SearchMetadata metadata;

    public SearchResult(@NotNull List<SearchRow> rows, @NotNull SearchMetadata metadata) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.rows = rows;
        this.metadata = metadata;
    }

    @NotNull
    public final List<SearchRow> getRows() {
        return this.rows;
    }

    @NotNull
    public final SearchMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public List<FacetResult<?>> getFacets() {
        return this.metadata.getFacets();
    }

    @Override
    @Nullable
    public DateFacetResult get(@NotNull DateFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        return this.metadata.get(facet);
    }

    @Override
    @Nullable
    public NumericFacetResult get(@NotNull NumericFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        return this.metadata.get(facet);
    }

    @Override
    @Nullable
    public TermFacetResult get(@NotNull TermFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        return this.metadata.get(facet);
    }

    @NotNull
    public String toString() {
        return "SearchResult(rows=" + this.rows + ", metadata=" + this.metadata + ')';
    }
}

