/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.kv;

import com.couchbase.client.kotlin.kv.ExpiryKt;
import java.time.Instant;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00072\u00020\u0001:\u0004\u0006\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004H \u00a2\u0006\u0002\b\u0005\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry;", "", "()V", "encode", "", "encode$kotlin_client", "Absolute", "Companion", "None", "Relative", "Lcom/couchbase/client/kotlin/kv/Expiry$None;", "Lcom/couchbase/client/kotlin/kv/Expiry$Absolute;", "Lcom/couchbase/client/kotlin/kv/Expiry$Relative;", "kotlin-client"})
public abstract class Expiry {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private Expiry() {
    }

    public abstract long encode$kotlin_client();

    public /* synthetic */ Expiry(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$None;", "Lcom/couchbase/client/kotlin/kv/Expiry;", "()V", "encode", "", "encode$kotlin_client", "toString", "", "kotlin-client"})
    public static final class None
    extends Expiry {
        @NotNull
        public static final None INSTANCE = new None();

        private None() {
            super(null);
        }

        @Override
        public long encode$kotlin_client() {
            return 0L;
        }

        @NotNull
        public String toString() {
            return "None";
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$Absolute;", "Lcom/couchbase/client/kotlin/kv/Expiry;", "instant", "Ljava/time/Instant;", "(Ljava/time/Instant;)V", "getInstant", "()Ljava/time/Instant;", "component1", "copy", "encode", "", "encode$kotlin_client", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-client"})
    public static final class Absolute
    extends Expiry {
        @NotNull
        private final Instant instant;

        public Absolute(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            super(null);
            this.instant = instant;
            if (!(this.instant.compareTo(ExpiryKt.access$getEARLIEST_VALID_EXPIRY_INSTANT$p()) >= 0)) {
                boolean $i$a$-require-Expiry$Absolute$32 = false;
                String $i$a$-require-Expiry$Absolute$32 = ExpiryKt.access$expiryErrorMessage("expiry instant " + this.getInstant() + " is in the distant past. Earliest valid expiry instant is " + ExpiryKt.access$getEARLIEST_VALID_EXPIRY_INSTANT$p());
                throw new IllegalArgumentException($i$a$-require-Expiry$Absolute$32.toString());
            }
            if (!(this.instant.compareTo(ExpiryKt.access$getLATEST_VALID_EXPIRY_INSTANT$p()) <= 0)) {
                boolean bl = false;
                String string = ExpiryKt.access$expiryErrorMessage("expiry instant " + this.getInstant() + " is too far in the future. Latest valid expiry instant is " + ExpiryKt.access$getLATEST_VALID_EXPIRY_INSTANT$p());
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final Instant getInstant() {
            return this.instant;
        }

        @Override
        public long encode$kotlin_client() {
            return this.instant.getEpochSecond();
        }

        @NotNull
        public final Instant component1() {
            return this.instant;
        }

        @NotNull
        public final Absolute copy(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            return new Absolute(instant);
        }

        public static /* synthetic */ Absolute copy$default(Absolute absolute, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                instant = absolute.instant;
            }
            return absolute.copy(instant);
        }

        @NotNull
        public String toString() {
            return "Absolute(instant=" + this.instant + ')';
        }

        public int hashCode() {
            return this.instant.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Absolute)) {
                return false;
            }
            Absolute absolute = (Absolute)other;
            return Intrinsics.areEqual((Object)this.instant, (Object)absolute.instant);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0012\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\b\u001a\u00020\u0003H\u00c6\u0003\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\t\u0010\u0006J \u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u001c\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0018"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$Relative;", "Lcom/couchbase/client/kotlin/kv/Expiry;", "duration", "Lkotlin/time/Duration;", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getDuration-UwyO8pc", "()J", "J", "component1", "component1-UwyO8pc", "copy", "copy-LRDsOJo", "(J)Lcom/couchbase/client/kotlin/kv/Expiry$Relative;", "encode", "", "encode$kotlin_client", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-client"})
    public static final class Relative
    extends Expiry {
        private final long duration;

        private Relative(long duration) {
            super(null);
            this.duration = duration;
            long seconds = Duration.getInWholeSeconds-impl((long)this.getDuration-UwyO8pc());
            if (!(seconds > 0L)) {
                boolean $i$a$-require-Expiry$Relative$32 = false;
                String $i$a$-require-Expiry$Relative$32 = ExpiryKt.access$expiryErrorMessage("expiry duration " + Duration.toString-impl((long)this.getDuration-UwyO8pc()) + " is less than one second");
                throw new IllegalArgumentException($i$a$-require-Expiry$Relative$32.toString());
            }
            if (!(ExpiryKt.access$currentTimeSeconds() + seconds <= ExpiryKt.access$getLATEST_VALID_EXPIRY_INSTANT$p().getEpochSecond())) {
                boolean bl = false;
                String string = ExpiryKt.access$expiryErrorMessage("expiry duration " + Duration.toString-impl((long)this.getDuration-UwyO8pc()) + " ends too far in the future. Latest valid expiry instant is " + ExpiryKt.access$getLATEST_VALID_EXPIRY_INSTANT$p());
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final long getDuration-UwyO8pc() {
            return this.duration;
        }

        @Override
        public long encode$kotlin_client() {
            long seconds = Duration.getInWholeSeconds-impl((long)this.getDuration-UwyO8pc());
            return seconds < (long)ExpiryKt.access$getRELATIVE_EXPIRY_CUTOFF_SECONDS$p() ? seconds : ExpiryKt.access$currentTimeSeconds() + seconds;
        }

        public final long component1-UwyO8pc() {
            return this.duration;
        }

        @NotNull
        public final Relative copy-LRDsOJo(long duration) {
            return new Relative(duration, null);
        }

        public static /* synthetic */ Relative copy-LRDsOJo$default(Relative relative, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = relative.duration;
            }
            return relative.copy-LRDsOJo(l);
        }

        @NotNull
        public String toString() {
            return "Relative(duration=" + Duration.toString-impl((long)this.duration) + ')';
        }

        public int hashCode() {
            return Duration.hashCode-impl((long)this.duration);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Relative)) {
                return false;
            }
            Relative relative = (Relative)other;
            return Duration.equals-impl0((long)this.duration, (long)relative.duration);
        }

        public /* synthetic */ Relative(long duration, DefaultConstructorMarker $constructor_marker) {
            this(duration);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001b\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000eH\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000eH\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000eH\u0007\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0015"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$Companion;", "", "()V", "none", "Lcom/couchbase/client/kotlin/kv/Expiry;", "of", "instant", "Ljava/time/Instant;", "duration", "Lkotlin/time/Duration;", "of-LRDsOJo", "(J)Lcom/couchbase/client/kotlin/kv/Expiry;", "ofDays", "days", "", "ofHours", "hours", "ofMinutes", "minutes", "ofSeconds", "seconds", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Expiry none() {
            return None.INSTANCE;
        }

        @NotNull
        public final Expiry of-LRDsOJo(long duration) {
            return Duration.isInfinite-impl((long)duration) ? this.none() : (Expiry)new Relative(duration, null);
        }

        @Deprecated(message="Deprecated in favor of Expiry.of(x.seconds)", replaceWith=@ReplaceWith(expression="of(seconds.seconds)", imports={"kotlin.time.Duration.Companion.seconds"}))
        @NotNull
        public final Expiry ofSeconds(long seconds) {
            return this.of-LRDsOJo(DurationKt.toDuration((long)seconds, (DurationUnit)DurationUnit.SECONDS));
        }

        @Deprecated(message="Deprecated in favor of Expiry.of(x.minutes)", replaceWith=@ReplaceWith(expression="of(minutes.minutes)", imports={"kotlin.time.Duration.Companion.minutes"}))
        @NotNull
        public final Expiry ofMinutes(long minutes) {
            return this.of-LRDsOJo(DurationKt.toDuration((long)minutes, (DurationUnit)DurationUnit.MINUTES));
        }

        @Deprecated(message="Deprecated in favor of Expiry.of(x.hours)", replaceWith=@ReplaceWith(expression="of(hours.hours)", imports={"kotlin.time.Duration.Companion.hours"}))
        @NotNull
        public final Expiry ofHours(long hours) {
            return this.of-LRDsOJo(DurationKt.toDuration((long)hours, (DurationUnit)DurationUnit.HOURS));
        }

        @Deprecated(message="Deprecated in favor of Expiry.of(x.days)", replaceWith=@ReplaceWith(expression="of(days.days)", imports={"kotlin.time.Duration.Companion.minutes"}))
        @NotNull
        public final Expiry ofDays(long days) {
            return this.of-LRDsOJo(DurationKt.toDuration((long)days, (DurationUnit)DurationUnit.DAYS));
        }

        @NotNull
        public final Expiry of(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            return new Absolute(instant);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

