/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.query;

import com.couchbase.client.core.util.Golang;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0019\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0004H\u0002J\b\u0010#\u001a\u00020\u0004H\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0018\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u001a\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\rR\u0011\u0010\u001c\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\rR\u0011\u0010\u001e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\r\u00a8\u0006$"}, d2={"Lcom/couchbase/client/kotlin/query/QueryMetrics;", "", "map", "", "", "(Ljava/util/Map;)V", "elapsedTime", "Ljava/time/Duration;", "getElapsedTime", "()Ljava/time/Duration;", "errorCount", "", "getErrorCount", "()J", "executionTime", "getExecutionTime", "getMap", "()Ljava/util/Map;", "mutationCount", "getMutationCount", "resultCount", "getResultCount", "resultSize", "getResultSize", "serviceLoad", "getServiceLoad", "sortCount", "getSortCount", "usedMemory", "getUsedMemory", "warningCount", "getWarningCount", "getDuration", "key", "getLong", "toString", "kotlin-client"})
public final class QueryMetrics {
    @NotNull
    private final Map<String, Object> map;

    public QueryMetrics(@NotNull Map<String, ? extends Object> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.map = map2;
    }

    @NotNull
    public final Map<String, Object> getMap() {
        return this.map;
    }

    @NotNull
    public final Duration getElapsedTime() {
        return this.getDuration("elapsedTime");
    }

    @NotNull
    public final Duration getExecutionTime() {
        return this.getDuration("executionTime");
    }

    public final long getSortCount() {
        return this.getLong("sortCount");
    }

    public final long getResultCount() {
        return this.getLong("resultCount");
    }

    public final long getResultSize() {
        return this.getLong("resultSize");
    }

    public final long getUsedMemory() {
        return this.getLong("usedMemory");
    }

    public final long getServiceLoad() {
        return this.getLong("serviceLoad");
    }

    public final long getMutationCount() {
        return this.getLong("mutationCount");
    }

    public final long getErrorCount() {
        return this.getLong("errorCount");
    }

    public final long getWarningCount() {
        return this.getLong("warningCount");
    }

    private final Duration getDuration(String key) {
        String string = (String)this.map.get(key);
        Duration duration = Golang.parseDuration((String)(string == null ? "0" : string));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"parseDuration(map[key] as String? ?: \"0\")");
        return duration;
    }

    private final long getLong(String key) {
        Number number = (Number)this.map.get(key);
        return (number == null ? (Number)0 : (Number)number).longValue();
    }

    @NotNull
    public String toString() {
        return "QueryMetrics(map=" + this.map + ')';
    }
}

