/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.kv;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.subdoc.DocumentTooDeepException;
import com.couchbase.client.core.error.subdoc.PathInvalidException;
import com.couchbase.client.core.error.subdoc.PathTooDeepException;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.codec.TypeRef;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import com.couchbase.client.kotlin.kv.LookupInResult;
import com.couchbase.client.kotlin.kv.LookupInResultKt;
import com.couchbase.client.kotlin.kv.LookupInSpec;
import com.couchbase.client.kotlin.kv.Subdoc;
import com.couchbase.client.kotlin.kv.SubdocCount;
import com.couchbase.client.kotlin.kv.SubdocExists;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b(J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020 H\u0000\u00a2\u0006\u0002\b(J\u0018\u0010)\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0016\u0010+\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0005H\u0080\u0002\u00a2\u0006\u0002\b,J5\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010.2\u0006\u0010'\u001a\u00020\u001c2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.002\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u000eH\u0001\u00a2\u0006\u0002\u00102J&\u00103\u001a\u0002H.\"\u0006\b\u0000\u0010.\u0018\u0001*\u00020\u001c2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u000eH\u0086\b\u00a2\u0006\u0002\u00104R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0015\u0010\u001f\u001a\u00020\u0005*\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0015\u0010\u001f\u001a\u00020\t*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010$\u00a8\u00065"}, d2={"Lcom/couchbase/client/kotlin/kv/LookupInResult;", "", "id", "", "size", "", "cas", "", "deleted", "", "fields", "", "Lcom/couchbase/client/core/msg/kv/SubDocumentField;", "defaultSerializer", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "spec", "Lcom/couchbase/client/kotlin/kv/LookupInSpec;", "(Ljava/lang/String;IJZLjava/util/List;Lcom/couchbase/client/kotlin/codec/JsonSerializer;Lcom/couchbase/client/kotlin/kv/LookupInSpec;)V", "getCas", "()J", "getDeleted", "()Z", "getId", "()Ljava/lang/String;", "getSize", "()I", "content", "", "Lcom/couchbase/client/kotlin/kv/Subdoc;", "getContent", "(Lcom/couchbase/client/kotlin/kv/Subdoc;)[B", "value", "Lcom/couchbase/client/kotlin/kv/SubdocCount;", "getValue", "(Lcom/couchbase/client/kotlin/kv/SubdocCount;)I", "Lcom/couchbase/client/kotlin/kv/SubdocExists;", "(Lcom/couchbase/client/kotlin/kv/SubdocExists;)Z", "checkSpec", "", "subdoc", "content$kotlin_client", "exists", "index", "get", "get$kotlin_client", "internalContentAs", "T", "type", "Lcom/couchbase/client/kotlin/codec/TypeRef;", "serializer", "(Lcom/couchbase/client/kotlin/kv/Subdoc;Lcom/couchbase/client/kotlin/codec/TypeRef;Lcom/couchbase/client/kotlin/codec/JsonSerializer;)Ljava/lang/Object;", "contentAs", "(Lcom/couchbase/client/kotlin/kv/Subdoc;Lcom/couchbase/client/kotlin/codec/JsonSerializer;)Ljava/lang/Object;", "kotlin-client"})
public final class LookupInResult {
    @NotNull
    private final String id;
    private final int size;
    private final long cas;
    private final boolean deleted;
    @NotNull
    private final List<SubDocumentField> fields;
    @NotNull
    private final JsonSerializer defaultSerializer;
    @NotNull
    private final LookupInSpec spec;

    public LookupInResult(@NotNull String id2, int size, long cas, boolean deleted, @NotNull List<? extends SubDocumentField> fields, @NotNull JsonSerializer defaultSerializer, @NotNull LookupInSpec spec2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)defaultSerializer, (String)"defaultSerializer");
        Intrinsics.checkNotNullParameter((Object)spec2, (String)"spec");
        this.id = id2;
        this.size = size;
        this.cas = cas;
        this.deleted = deleted;
        this.fields = fields;
        this.defaultSerializer = defaultSerializer;
        this.spec = spec2;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final int getSize() {
        return this.size;
    }

    public final long getCas() {
        return this.cas;
    }

    public final boolean getDeleted() {
        return this.deleted;
    }

    public final boolean getValue(@NotNull SubdocExists $this$value) {
        Intrinsics.checkNotNullParameter((Object)$this$value, (String)"<this>");
        return this.exists($this$value.getSpec$kotlin_client(), $this$value.getIndex$kotlin_client());
    }

    public final int getValue(@NotNull SubdocCount $this$value) {
        Intrinsics.checkNotNullParameter((Object)$this$value, (String)"<this>");
        String string = LangExtensionsKt.toStringUtf8(this.content$kotlin_client($this$value));
        boolean bl = false;
        return Integer.parseInt(string);
    }

    @NotNull
    public final byte[] getContent(@NotNull Subdoc $this$content) {
        Intrinsics.checkNotNullParameter((Object)$this$content, (String)"<this>");
        return this.content$kotlin_client($this$content);
    }

    public final /* synthetic */ <T> T contentAs(Subdoc $this$contentAs, JsonSerializer serializer) {
        Intrinsics.checkNotNullParameter((Object)$this$contentAs, (String)"<this>");
        boolean $i$f$contentAs = false;
        boolean $i$f$typeRef = false;
        Intrinsics.needClassReification();
        return this.internalContentAs($this$contentAs, new TypeRef<T>(){
            {
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                super(null instanceof Object);
            }
        }, serializer);
    }

    public static /* synthetic */ Object contentAs$default(LookupInResult this_, Subdoc receiver, JsonSerializer serializer, int n, Object object) {
        if ((n & 1) != 0) {
            serializer = null;
        }
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"<this>");
        boolean $i$f$contentAs = false;
        boolean $i$f$typeRef = false;
        Intrinsics.needClassReification();
        return this_.internalContentAs(receiver, new /* invalid duplicate definition of identical inner class */, serializer);
    }

    @PublishedApi
    public final <T> T internalContentAs(@NotNull Subdoc subdoc, @NotNull TypeRef<T> type, @Nullable JsonSerializer serializer) {
        Intrinsics.checkNotNullParameter((Object)subdoc, (String)"subdoc");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        JsonSerializer jsonSerializer = serializer;
        return (jsonSerializer == null ? this.defaultSerializer : jsonSerializer).deserialize(this.content$kotlin_client(subdoc), type);
    }

    public static /* synthetic */ Object internalContentAs$default(LookupInResult lookupInResult, Subdoc subdoc, TypeRef typeRef2, JsonSerializer jsonSerializer, int n, Object object) {
        if ((n & 4) != 0) {
            jsonSerializer = null;
        }
        return lookupInResult.internalContentAs(subdoc, typeRef2, jsonSerializer);
    }

    private final boolean exists(LookupInSpec spec2, int index) {
        this.checkSpec(spec2);
        LookupInResultKt.checkIndex(index, RangesKt.until((int)0, (int)this.size));
        SubDocumentField field = this.fields.get(index);
        field.error().map(LookupInResult::exists$lambda-0);
        return !field.error().isPresent();
    }

    @NotNull
    public final SubDocumentField get$kotlin_client(int index) {
        LookupInResultKt.checkIndex(index, RangesKt.until((int)0, (int)this.size));
        SubDocumentField field = this.fields.get(index);
        field.error().map(get.1.INSTANCE);
        return field;
    }

    @NotNull
    public final byte[] content$kotlin_client(@NotNull Subdoc subdoc) {
        Intrinsics.checkNotNullParameter((Object)subdoc, (String)"subdoc");
        this.checkSpec(subdoc.getSpec$kotlin_client());
        byte[] byArray = this.get$kotlin_client(subdoc.getIndex$kotlin_client()).value();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"get(subdoc.index).value()");
        return byArray;
    }

    @NotNull
    public final byte[] content$kotlin_client(@NotNull SubdocCount subdoc) {
        Intrinsics.checkNotNullParameter((Object)subdoc, (String)"subdoc");
        this.checkSpec(subdoc.getSpec$kotlin_client());
        byte[] byArray = this.get$kotlin_client(subdoc.getIndex$kotlin_client()).value();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"get(subdoc.index).value()");
        return byArray;
    }

    private final void checkSpec(LookupInSpec spec2) {
        boolean bl = Intrinsics.areEqual((Object)spec2, (Object)this.spec);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Subdoc was not created from the same LookupInSpec as this result.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private static final Unit exists$lambda-0(CouchbaseException it) {
        if (it instanceof PathTooDeepException) {
            throw it;
        }
        if (it instanceof DocumentTooDeepException) {
            throw it;
        }
        if (it instanceof PathInvalidException) {
            throw it;
        }
        return Unit.INSTANCE;
    }
}

