/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.VersionAndGitHash;
import com.couchbase.client.core.util.CbObjects;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.codec.DefaultJsonSerializer;
import com.couchbase.client.java.codec.JacksonJsonSerializer;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.JsonTranscoder;
import com.couchbase.client.java.codec.JsonValueSerializerWrapper;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.env.ClusterPropertyLoader;
import com.couchbase.client.java.transactions.config.TransactionsConfig;
import java.util.Optional;
import java.util.function.Consumer;

public class ClusterEnvironment
extends CoreEnvironment {
    private static final VersionAndGitHash clientVersion = VersionAndGitHash.from(Cluster.class);
    private final JsonSerializer jsonSerializer;
    private final Transcoder transcoder;
    private final Optional<CryptoManager> cryptoManager;

    private ClusterEnvironment(Builder builder) {
        super((CoreEnvironment.Builder)builder);
        this.jsonSerializer = builder.jsonSerializer != null ? new JsonValueSerializerWrapper(builder.jsonSerializer) : this.newDefaultSerializer(builder.cryptoManager);
        this.transcoder = (Transcoder)CbObjects.defaultIfNull((Object)builder.transcoder, () -> JsonTranscoder.create(this.jsonSerializer));
        this.cryptoManager = Optional.ofNullable(builder.cryptoManager);
    }

    private JsonSerializer newDefaultSerializer(CryptoManager cryptoManager) {
        return this.nonShadowedJacksonPresent() ? JacksonJsonSerializer.create(cryptoManager) : DefaultJsonSerializer.create(cryptoManager);
    }

    private boolean nonShadowedJacksonPresent() {
        try {
            JacksonJsonSerializer.preflightCheck();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected String defaultAgentTitle() {
        return "java";
    }

    protected VersionAndGitHash clientVersionAndGitHash() {
        return clientVersion;
    }

    public static ClusterEnvironment create() {
        return ClusterEnvironment.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Transcoder transcoder() {
        return this.transcoder;
    }

    public JsonSerializer jsonSerializer() {
        return this.jsonSerializer;
    }

    public Optional<CryptoManager> cryptoManager() {
        return this.cryptoManager;
    }

    public static class Builder
    extends CoreEnvironment.Builder<Builder> {
        private JsonSerializer jsonSerializer;
        private Transcoder transcoder;
        private CryptoManager cryptoManager;
        private TransactionsConfig.Builder transactionsConfigBuilder = TransactionsConfig.builder();

        Builder() {
        }

        public Builder load(ClusterPropertyLoader loader) {
            Validators.notNull((Object)loader, (String)"ClusterPropertyLoader");
            loader.load(this);
            return this;
        }

        public Builder jsonSerializer(JsonSerializer jsonSerializer) {
            this.jsonSerializer = (JsonSerializer)Validators.notNull((Object)jsonSerializer, (String)"JsonSerializer");
            return this;
        }

        public Builder transcoder(Transcoder transcoder) {
            this.transcoder = (Transcoder)Validators.notNull((Object)transcoder, (String)"Transcoder");
            return this;
        }

        public Builder cryptoManager(CryptoManager cryptoManager) {
            this.cryptoManager = cryptoManager;
            return this;
        }

        @Deprecated
        @Stability.Uncommitted
        public Builder transactionsConfig(TransactionsConfig.Builder transactionsConfig) {
            Validators.notNull((Object)transactionsConfig, (String)"transactionsConfig");
            this.transactionsConfigBuilder = transactionsConfig;
            return this;
        }

        @Stability.Uncommitted
        public Builder transactionsConfig(Consumer<TransactionsConfig.Builder> builderConsumer) {
            builderConsumer.accept(this.transactionsConfigBuilder);
            return this;
        }

        public ClusterEnvironment build() {
            this.transactionsConfig = this.transactionsConfigBuilder.build();
            return new ClusterEnvironment(this);
        }
    }
}

