/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.search;

import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.CbCollections;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchIndex {
    private final String name;
    private final String sourceName;
    private String uuid;
    private String type;
    private Map<String, Object> params;
    private String sourceUuid;
    private Map<String, Object> sourceParams;
    private String sourceType;
    private Map<String, Object> planParams;

    public SearchIndex(String name, String sourceName) {
        this.name = name;
        this.sourceName = sourceName;
    }

    @JsonCreator
    public SearchIndex(@JsonProperty(value="uuid") String uuid, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="params") Map<String, Object> params, @JsonProperty(value="sourceUUID") String sourceUuid, @JsonProperty(value="sourceName") String sourceName, @JsonProperty(value="sourceParams") Map<String, Object> sourceParams, @JsonProperty(value="sourceType") String sourceType, @JsonProperty(value="planParams") Map<String, Object> planParams) {
        this.uuid = uuid;
        this.name = name;
        this.sourceName = sourceName;
        this.type = type;
        this.params = params;
        this.sourceUuid = sourceUuid;
        this.sourceParams = sourceParams;
        this.sourceType = sourceType;
        this.planParams = planParams;
    }

    public static SearchIndex fromJson(String input) {
        try {
            return (SearchIndex)Mapper.decodeInto((String)input, SearchIndex.class);
        }
        catch (Exception ex) {
            throw InvalidArgumentException.fromMessage((String)"Could not decode search index JSON", (Throwable)ex);
        }
    }

    public String name() {
        return this.name;
    }

    public String uuid() {
        return this.uuid;
    }

    public SearchIndex uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public SearchIndex unsetUuid() {
        this.uuid = null;
        return this;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public String type() {
        return this.type;
    }

    public Map<String, Object> params() {
        return this.params == null ? Collections.emptyMap() : this.params;
    }

    public SearchIndex params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public String sourceUuid() {
        return this.sourceUuid;
    }

    public SearchIndex sourceUuid(String sourceUuid) {
        this.sourceUuid = sourceUuid;
        return this;
    }

    public Map<String, Object> sourceParams() {
        return this.sourceParams == null ? Collections.emptyMap() : this.sourceParams;
    }

    public SearchIndex sourceParams(Map<String, Object> sourceParams) {
        this.sourceParams = sourceParams;
        return this;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public SearchIndex sourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public Map<String, Object> planParams() {
        return this.planParams == null ? Collections.emptyMap() : this.planParams;
    }

    public SearchIndex planParams(Map<String, Object> planParams) {
        this.planParams = planParams;
        return this;
    }

    public String toJson() {
        HashMap<String, Object> output = new HashMap<String, Object>();
        if (this.uuid != null) {
            output.put("uuid", this.uuid);
        }
        output.put("name", this.name);
        output.put("sourceName", this.sourceName);
        output.put("type", this.type == null ? "fulltext-index" : this.type);
        output.put("sourceType", this.sourceType == null ? "couchbase" : this.sourceType);
        if (!CbCollections.isNullOrEmpty(this.params)) {
            output.put("params", this.params);
        }
        if (!CbCollections.isNullOrEmpty(this.planParams)) {
            output.put("planParams", this.planParams);
        }
        if (!CbCollections.isNullOrEmpty(this.sourceParams)) {
            output.put("sourceParams", this.sourceParams);
        }
        if (this.sourceUuid != null) {
            output.put("sourceUUID", this.sourceUuid);
        }
        return Mapper.encodeAsString(output);
    }

    public String toString() {
        return "SearchIndex{uuid='" + this.uuid + '\'' + ", name='" + this.name + '\'' + ", sourceName='" + this.sourceName + '\'' + ", type='" + this.type + '\'' + ", params=" + this.params + ", sourceUuid='" + this.sourceUuid + '\'' + ", sourceParams=" + this.sourceParams + ", sourceType='" + this.sourceType + '\'' + ", planParams=" + this.planParams + '}';
    }
}

