/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.user;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpRequest;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.GroupNotFoundException;
import com.couchbase.client.core.error.HttpStatusCodeException;
import com.couchbase.client.core.error.UserNotFoundException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.java.manager.user.AuthDomain;
import com.couchbase.client.java.manager.user.DropGroupOptions;
import com.couchbase.client.java.manager.user.DropUserOptions;
import com.couchbase.client.java.manager.user.GetAllGroupsOptions;
import com.couchbase.client.java.manager.user.GetAllUsersOptions;
import com.couchbase.client.java.manager.user.GetGroupOptions;
import com.couchbase.client.java.manager.user.GetRolesOptions;
import com.couchbase.client.java.manager.user.GetUserOptions;
import com.couchbase.client.java.manager.user.Group;
import com.couchbase.client.java.manager.user.Role;
import com.couchbase.client.java.manager.user.RoleAndDescription;
import com.couchbase.client.java.manager.user.UpsertGroupOptions;
import com.couchbase.client.java.manager.user.UpsertUserOptions;
import com.couchbase.client.java.manager.user.User;
import com.couchbase.client.java.manager.user.UserAndMetadata;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AsyncUserManager {
    private final Core core;
    private final CoreHttpClient httpClient;

    public AsyncUserManager(Core core) {
        this.core = core;
        this.httpClient = core.httpClient(RequestTarget.manager());
    }

    private static CoreHttpPath pathForUsers() {
        return CoreHttpPath.path((String)"/settings/rbac/users");
    }

    private static CoreHttpPath pathForRoles() {
        return CoreHttpPath.path((String)"/settings/rbac/roles");
    }

    private static CoreHttpPath pathForUser(AuthDomain domain, String username) {
        return CoreHttpPath.path((String)"/settings/rbac/users/{domain}/{username}", (Map)CbCollections.mapOf((Object)"username", (Object)username, (Object)"domain", (Object)domain.alias()));
    }

    private static CoreHttpPath pathForGroups() {
        return CoreHttpPath.path((String)"/settings/rbac/groups");
    }

    private static CoreHttpPath pathForGroup(String groupName) {
        return CoreHttpPath.path((String)"/settings/rbac/groups/{groupName}", (Map)CbCollections.mapOf((Object)"groupName", (Object)groupName));
    }

    public CompletableFuture<UserAndMetadata> getUser(AuthDomain domain, String username) {
        return this.getUser(domain, username, GetUserOptions.getUserOptions());
    }

    public CompletableFuture<UserAndMetadata> getUser(AuthDomain domain, String username, GetUserOptions options) {
        return ((CompletableFuture)this.httpClient.get(AsyncUserManager.pathForUser(domain, username), (CoreCommonOptions)options.build()).trace("manager_users_get_user").exec(this.core).exceptionally(AsyncUserManager.translateNotFound(() -> UserNotFoundException.forUser((String)domain.alias(), (String)username)))).thenApply(response -> (UserAndMetadata)Mapper.decodeInto((byte[])response.content(), UserAndMetadata.class));
    }

    public CompletableFuture<List<UserAndMetadata>> getAllUsers() {
        return this.getAllUsers(GetAllUsersOptions.getAllUsersOptions());
    }

    public CompletableFuture<List<UserAndMetadata>> getAllUsers(GetAllUsersOptions options) {
        return this.httpClient.get(AsyncUserManager.pathForUsers(), (CoreCommonOptions)options.build()).trace("manager_users_get_all_users").exec(this.core).thenApply(response -> (List)Mapper.decodeInto((byte[])response.content(), (TypeReference)new TypeReference<List<UserAndMetadata>>(){}));
    }

    public CompletableFuture<List<RoleAndDescription>> getRoles() {
        return this.getRoles(GetRolesOptions.getRolesOptions());
    }

    public CompletableFuture<List<RoleAndDescription>> getRoles(GetRolesOptions options) {
        return this.httpClient.get(AsyncUserManager.pathForRoles(), (CoreCommonOptions)options.build()).trace("manager_users_get_roles").exec(this.core).thenApply(response -> (List)Mapper.decodeInto((byte[])response.content(), (TypeReference)new TypeReference<List<RoleAndDescription>>(){}));
    }

    public CompletableFuture<Void> upsertUser(User user) {
        return this.upsertUser(user, UpsertUserOptions.upsertUserOptions());
    }

    public CompletableFuture<Void> upsertUser(User user, UpsertUserOptions options) {
        String username = user.username();
        UrlQueryStringBuilder params = CoreHttpRequest.Builder.newForm().add("name", user.displayName()).add("roles", user.roles().stream().map(Role::format).collect(Collectors.joining(",")));
        if (!user.groups().isEmpty()) {
            params.add("groups", String.join((CharSequence)",", user.groups()));
        }
        user.password().ifPresent(pwd -> params.add("password", pwd));
        return this.httpClient.put(AsyncUserManager.pathForUser(AuthDomain.LOCAL, username), (CoreCommonOptions)options.build()).trace("manager_users_upsert_user").form(params).exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> dropUser(String username) {
        return this.dropUser(username, DropUserOptions.dropUserOptions());
    }

    public CompletableFuture<Void> dropUser(String username, DropUserOptions options) {
        AuthDomain domain = AuthDomain.LOCAL;
        return ((CompletableFuture)this.httpClient.delete(AsyncUserManager.pathForUser(domain, username), (CoreCommonOptions)options.build()).trace("manager_users_drop_user").exec(this.core).exceptionally(AsyncUserManager.translateNotFound(() -> UserNotFoundException.forUser((String)domain.alias(), (String)username)))).thenApply(response -> null);
    }

    public CompletableFuture<Group> getGroup(String groupName) {
        return this.getGroup(groupName, GetGroupOptions.getGroupOptions());
    }

    public CompletableFuture<Group> getGroup(String groupName, GetGroupOptions options) {
        return ((CompletableFuture)this.httpClient.get(AsyncUserManager.pathForGroup(groupName), (CoreCommonOptions)options.build()).trace("manager_users_get_group").exec(this.core).exceptionally(AsyncUserManager.translateNotFound(() -> GroupNotFoundException.forGroup((String)groupName)))).thenApply(response -> (Group)Mapper.decodeInto((byte[])response.content(), Group.class));
    }

    public CompletableFuture<List<Group>> getAllGroups() {
        return this.getAllGroups(GetAllGroupsOptions.getAllGroupsOptions());
    }

    public CompletableFuture<List<Group>> getAllGroups(GetAllGroupsOptions options) {
        return this.httpClient.get(AsyncUserManager.pathForGroups(), (CoreCommonOptions)options.build()).trace("manager_users_get_all_groups").exec(this.core).thenApply(response -> (List)Mapper.decodeInto((byte[])response.content(), (TypeReference)new TypeReference<List<Group>>(){}));
    }

    public CompletableFuture<Void> upsertGroup(Group group) {
        return this.upsertGroup(group, UpsertGroupOptions.upsertGroupOptions());
    }

    public CompletableFuture<Void> upsertGroup(Group group, UpsertGroupOptions options) {
        UrlQueryStringBuilder params = CoreHttpRequest.Builder.newForm().add("description", group.description()).add("ldap_group_ref", group.ldapGroupReference().orElse("")).add("roles", group.roles().stream().map(Role::format).collect(Collectors.joining(",")));
        return this.httpClient.put(AsyncUserManager.pathForGroup(group.name()), (CoreCommonOptions)options.build()).trace("manager_users_upsert_group").form(params).exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> dropGroup(String groupName) {
        return this.dropGroup(groupName, DropGroupOptions.dropGroupOptions());
    }

    public CompletableFuture<Void> dropGroup(String groupName, DropGroupOptions options) {
        return ((CompletableFuture)this.httpClient.delete(AsyncUserManager.pathForGroup(groupName), (CoreCommonOptions)options.build()).trace("manager_users_drop_group").exec(this.core).exceptionally(AsyncUserManager.translateNotFound(() -> GroupNotFoundException.forGroup((String)groupName)))).thenApply(response -> null);
    }

    private static Function<Throwable, CoreHttpResponse> translateNotFound(Supplier<? extends RuntimeException> exceptionSupplier) {
        return t -> {
            throw HttpStatusCodeException.couchbaseResponseStatus((Throwable)t) == ResponseStatus.NOT_FOUND ? (RuntimeException)exceptionSupplier.get() : CbThrowables.propagate((Throwable)t);
        };
    }
}

