/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CreatePrimaryQueryIndexOptions
extends CommonOptions<CreatePrimaryQueryIndexOptions> {
    private final Map<String, Object> with = new HashMap<String, Object>();
    private Optional<String> indexName = Optional.empty();
    private boolean ignoreIfExists;
    private String scopeName;
    private String collectionName;

    private CreatePrimaryQueryIndexOptions() {
    }

    public static CreatePrimaryQueryIndexOptions createPrimaryQueryIndexOptions() {
        return new CreatePrimaryQueryIndexOptions();
    }

    public CreatePrimaryQueryIndexOptions indexName(String indexName) {
        this.indexName = Optional.ofNullable(CbStrings.emptyToNull((String)indexName));
        return this;
    }

    public CreatePrimaryQueryIndexOptions ignoreIfExists(boolean ignoreIfExists) {
        this.ignoreIfExists = ignoreIfExists;
        return this;
    }

    public CreatePrimaryQueryIndexOptions numReplicas(int numReplicas) {
        if (numReplicas < 0) {
            throw InvalidArgumentException.fromMessage((String)"numReplicas must be >= 0");
        }
        return this.with("num_replica", numReplicas);
    }

    public CreatePrimaryQueryIndexOptions deferred(boolean deferred) {
        return this.with("defer_build", deferred);
    }

    public CreatePrimaryQueryIndexOptions with(String optionName, Object optionValue) {
        this.with.put(Validators.notNullOrEmpty((String)optionName, (String)"OptionName"), Validators.notNull((Object)optionValue, (String)"OptionValue"));
        return this;
    }

    @Stability.Uncommitted
    public CreatePrimaryQueryIndexOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty((String)scopeName, (String)"ScopeName");
        return this;
    }

    @Stability.Uncommitted
    public CreatePrimaryQueryIndexOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty((String)collectionName, (String)"CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage((String)"If a collectionName is provided, a scopeName must also be provided");
        }
        if (this.scopeName != null && this.collectionName == null) {
            throw InvalidArgumentException.fromMessage((String)"If a scopeName is provided, a collectionName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
            super(CreatePrimaryQueryIndexOptions.this);
        }

        public boolean ignoreIfExists() {
            return CreatePrimaryQueryIndexOptions.this.ignoreIfExists;
        }

        public Optional<String> indexName() {
            return CreatePrimaryQueryIndexOptions.this.indexName;
        }

        public Map<String, Object> with() {
            return CreatePrimaryQueryIndexOptions.this.with;
        }

        public Optional<String> scopeName() {
            return Optional.ofNullable(CreatePrimaryQueryIndexOptions.this.scopeName);
        }

        public Optional<String> collectionName() {
            return Optional.ofNullable(CreatePrimaryQueryIndexOptions.this.collectionName);
        }
    }
}

