/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.EndpointDiagnostics;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.diagnostics.WaitUntilReadyHelper;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.ConnectionStringPropertyLoader;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.OwnedSupplier;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.error.context.ReducedAnalyticsErrorContext;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.error.context.ReducedSearchErrorContext;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.ConnectionStringUtil;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.analytics.AnalyticsAccessor;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsResult;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.diagnostics.DiagnosticsOptions;
import com.couchbase.client.java.diagnostics.PingOptions;
import com.couchbase.client.java.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.java.manager.bucket.AsyncBucketManager;
import com.couchbase.client.java.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.java.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.java.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.java.manager.user.AsyncUserManager;
import com.couchbase.client.java.query.QueryAccessor;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.search.SearchAccessor;
import com.couchbase.client.java.search.SearchOptions;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.result.SearchResult;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class AsyncCluster {
    private final Supplier<ClusterEnvironment> environment;
    private final Core core;
    private final AsyncSearchIndexManager searchIndexManager;
    private final QueryAccessor queryAccessor;
    private final AsyncUserManager userManager;
    private final AsyncBucketManager bucketManager;
    private final AsyncQueryIndexManager queryIndexManager;
    private final AsyncAnalyticsIndexManager analyticsIndexManager;
    private final AsyncEventingFunctionManager eventingFunctionManager;
    private final Authenticator authenticator;
    private final Map<String, AsyncBucket> bucketCache = new ConcurrentHashMap<String, AsyncBucket>();

    public static AsyncCluster connect(String connectionString, String username, String password) {
        return AsyncCluster.connect(connectionString, ClusterOptions.clusterOptions((Authenticator)PasswordAuthenticator.create((String)username, (String)password)));
    }

    public static AsyncCluster connect(String connectionString, ClusterOptions options) {
        Validators.notNullOrEmpty((String)connectionString, (String)"ConnectionString");
        Validators.notNull((Object)options, (String)"ClusterOptions");
        ClusterOptions.Built opts = options.build();
        Supplier<ClusterEnvironment> environmentSupplier = AsyncCluster.extractClusterEnvironment(connectionString, opts);
        return new AsyncCluster(environmentSupplier, opts.authenticator(), AsyncCluster.seedNodesFromConnectionString(connectionString, environmentSupplier.get()));
    }

    public static AsyncCluster connect(Set<SeedNode> seedNodes, ClusterOptions options) {
        Validators.notNullOrEmpty(seedNodes, (String)"SeedNodes");
        Validators.notNull((Object)options, (String)"ClusterOptions");
        ClusterOptions.Built opts = options.build();
        return new AsyncCluster(AsyncCluster.extractClusterEnvironment(null, opts), opts.authenticator(), seedNodes);
    }

    static Supplier<ClusterEnvironment> extractClusterEnvironment(String connectionString, ClusterOptions.Built opts) {
        OwnedSupplier envSupplier;
        if (opts.environment() == null) {
            ClusterEnvironment.Builder builder = ClusterEnvironment.builder();
            if (connectionString != null) {
                builder.load((PropertyLoader)new ConnectionStringPropertyLoader(connectionString));
            }
            envSupplier = new OwnedSupplier((Object)builder.build());
        } else {
            envSupplier = opts::environment;
        }
        return envSupplier;
    }

    static Set<SeedNode> seedNodesFromConnectionString(String cs, ClusterEnvironment env) {
        return ConnectionStringUtil.seedNodesFromConnectionString((String)cs, (boolean)env.ioConfig().dnsSrvEnabled(), (boolean)env.securityConfig().tlsEnabled(), (EventBus)env.eventBus());
    }

    AsyncCluster(Supplier<ClusterEnvironment> environment, Authenticator authenticator, Set<SeedNode> seedNodes) {
        this.environment = environment;
        this.core = Core.create((CoreEnvironment)environment.get(), (Authenticator)authenticator, seedNodes);
        this.searchIndexManager = new AsyncSearchIndexManager(this.core);
        this.queryAccessor = new QueryAccessor(this.core);
        this.userManager = new AsyncUserManager(this.core);
        this.bucketManager = new AsyncBucketManager(this.core);
        this.queryIndexManager = new AsyncQueryIndexManager(this);
        this.analyticsIndexManager = new AsyncAnalyticsIndexManager(this);
        this.eventingFunctionManager = new AsyncEventingFunctionManager(this.core);
        this.authenticator = authenticator;
        this.core.initGlobalConfig();
    }

    public ClusterEnvironment environment() {
        return this.environment.get();
    }

    @Stability.Volatile
    public Core core() {
        return this.core;
    }

    public AsyncUserManager users() {
        return this.userManager;
    }

    public AsyncBucketManager buckets() {
        return this.bucketManager;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        return this.analyticsIndexManager;
    }

    public AsyncQueryIndexManager queryIndexes() {
        return this.queryIndexManager;
    }

    public AsyncSearchIndexManager searchIndexes() {
        return this.searchIndexManager;
    }

    @Stability.Uncommitted
    public AsyncEventingFunctionManager eventingFunctions() {
        return this.eventingFunctionManager;
    }

    public CompletableFuture<QueryResult> query(String statement) {
        return this.query(statement, ReactiveCluster.DEFAULT_QUERY_OPTIONS);
    }

    public CompletableFuture<QueryResult> query(String statement, QueryOptions options) {
        Validators.notNull((Object)options, (String)"QueryOptions", () -> new ReducedQueryErrorContext(statement));
        QueryOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.get().jsonSerializer() : opts.serializer();
        return this.queryAccessor.queryAsync(this.queryRequest(statement, opts), opts, serializer);
    }

    QueryRequest queryRequest(String statement, QueryOptions.Built options) {
        Validators.notNullOrEmpty((String)statement, (String)"Statement", () -> new ReducedQueryErrorContext(statement));
        Duration timeout = options.timeout().orElse(this.environment.get().timeoutConfig().queryTimeout());
        RetryStrategy retryStrategy = options.retryStrategy().orElse(this.environment.get().retryStrategy());
        JsonObject query = JsonObject.create();
        query.put("statement", statement);
        query.put("timeout", Golang.encodeDurationToMs((Duration)timeout));
        options.injectParams(query);
        byte[] queryBytes = query.toString().getBytes(StandardCharsets.UTF_8);
        String clientContextId = query.getString("client_context_id");
        RequestSpan span = this.environment().requestTracer().requestSpan("query", (RequestSpan)options.parentSpan().orElse(null));
        QueryRequest request = new QueryRequest(timeout, this.core.context(), retryStrategy, this.authenticator, statement, queryBytes, options.readonly(), clientContextId, span, null, null, null);
        request.context().clientContext(options.clientContext());
        return request;
    }

    public CompletableFuture<AnalyticsResult> analyticsQuery(String statement) {
        return this.analyticsQuery(statement, ReactiveCluster.DEFAULT_ANALYTICS_OPTIONS);
    }

    public CompletableFuture<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"AnalyticsOptions", () -> new ReducedAnalyticsErrorContext(statement));
        AnalyticsOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.get().jsonSerializer() : opts.serializer();
        return AnalyticsAccessor.analyticsQueryAsync(this.core, this.analyticsRequest(statement, opts), serializer);
    }

    AnalyticsRequest analyticsRequest(String statement, AnalyticsOptions.Built opts) {
        Validators.notNullOrEmpty((String)statement, (String)"Statement", () -> new ReducedAnalyticsErrorContext(statement));
        Duration timeout = opts.timeout().orElse(this.environment.get().timeoutConfig().analyticsTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.get().retryStrategy());
        JsonObject query = JsonObject.create();
        query.put("statement", statement);
        query.put("timeout", Golang.encodeDurationToMs((Duration)timeout));
        opts.injectParams(query);
        byte[] queryBytes = query.toString().getBytes(StandardCharsets.UTF_8);
        String clientContextId = query.getString("client_context_id");
        RequestSpan span = this.environment().requestTracer().requestSpan("analytics", (RequestSpan)opts.parentSpan().orElse(null));
        AnalyticsRequest request = new AnalyticsRequest(timeout, this.core.context(), retryStrategy, this.authenticator, queryBytes, opts.priority(), opts.readonly(), clientContextId, statement, span, null, null);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<SearchResult> searchQuery(String indexName, SearchQuery query) {
        return this.searchQuery(indexName, query, ReactiveCluster.DEFAULT_SEARCH_OPTIONS);
    }

    public CompletableFuture<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Validators.notNull((Object)query, (String)"SearchQuery", () -> new ReducedSearchErrorContext(indexName, null));
        Validators.notNull((Object)options, (String)"SearchOptions", () -> new ReducedSearchErrorContext(indexName, query.export().toMap()));
        SearchOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.get().jsonSerializer() : opts.serializer();
        return SearchAccessor.searchQueryAsync(this.core, this.searchRequest(indexName, query, opts), serializer);
    }

    SearchRequest searchRequest(String indexName, SearchQuery query, SearchOptions.Built opts) {
        Validators.notNullOrEmpty((String)indexName, (String)"IndexName", () -> new ReducedSearchErrorContext(indexName, query.export().toMap()));
        Duration timeout = opts.timeout().orElse(this.environment.get().timeoutConfig().searchTimeout());
        JsonObject params = query.export();
        opts.injectParams(indexName, params, timeout);
        byte[] bytes = params.toString().getBytes(StandardCharsets.UTF_8);
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.get().retryStrategy());
        RequestSpan span = this.environment().requestTracer().requestSpan("search", (RequestSpan)opts.parentSpan().orElse(null));
        SearchRequest request = new SearchRequest(timeout, this.core.context(), retryStrategy, this.authenticator, indexName, bytes, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public AsyncBucket bucket(String bucketName) {
        Validators.notNullOrEmpty((String)bucketName, (String)"Name");
        return this.bucketCache.computeIfAbsent(bucketName, n -> {
            this.core.openBucket(n);
            return new AsyncBucket((String)n, this.core, this.environment.get());
        });
    }

    public CompletableFuture<Void> disconnect() {
        return this.disconnect(this.environment.get().timeoutConfig().disconnectTimeout());
    }

    public CompletableFuture<Void> disconnect(Duration timeout) {
        return this.disconnectInternal(timeout).toFuture();
    }

    Mono<Void> disconnectInternal(Duration timeout) {
        return this.core.shutdown(timeout).then(Mono.defer(() -> {
            if (this.environment instanceof OwnedSupplier) {
                return this.environment.get().shutdownReactive(timeout);
            }
            return Mono.empty();
        }));
    }

    @Stability.Internal
    QueryAccessor queryAccessor() {
        return this.queryAccessor;
    }

    public CompletableFuture<DiagnosticsResult> diagnostics() {
        return this.diagnostics(ReactiveCluster.DEFAULT_DIAGNOSTICS_OPTIONS);
    }

    public CompletableFuture<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        Validators.notNull((Object)options, (String)"DiagnosticsOptions");
        DiagnosticsOptions.Built opts = options.build();
        return Mono.defer(() -> Mono.just((Object)new DiagnosticsResult(this.core.diagnostics().collect(Collectors.groupingBy(EndpointDiagnostics::type)), this.core.context().environment().userAgent().formattedShort(), opts.reportId().orElse(UUID.randomUUID().toString())))).toFuture();
    }

    public CompletableFuture<PingResult> ping() {
        return this.ping(ReactiveCluster.DEFAULT_PING_OPTIONS);
    }

    public CompletableFuture<PingResult> ping(PingOptions options) {
        Validators.notNull((Object)options, (String)"PingOptions");
        PingOptions.Built opts = options.build();
        return HealthPinger.ping((Core)this.core, opts.timeout(), (RetryStrategy)opts.retryStrategy().orElse(this.environment.get().retryStrategy()), opts.serviceTypes(), opts.reportId(), Optional.empty()).toFuture();
    }

    public CompletableFuture<Void> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, ReactiveCluster.DEFAULT_WAIT_UNTIL_READY_OPTIONS);
    }

    public CompletableFuture<Void> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        Validators.notNull((Object)options, (String)"WaitUntilReadyOptions");
        WaitUntilReadyOptions.Built opts = options.build();
        return WaitUntilReadyHelper.waitUntilReady((Core)this.core, opts.serviceTypes(), (Duration)timeout, (ClusterState)opts.desiredState(), Optional.empty());
    }
}

