/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreReactiveQueryResult;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryMetaData;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveQueryResult {
    private final JsonSerializer serializer;
    private final CoreReactiveQueryResult internal;

    @Stability.Internal
    public ReactiveQueryResult(CoreReactiveQueryResult internal, JsonSerializer serializer) {
        this.serializer = serializer;
        this.internal = internal;
    }

    public Flux<JsonObject> rowsAsObject() {
        return this.rowsAs(JsonObject.class);
    }

    public <T> Flux<T> rowsAs(Class<T> target) {
        return this.internal.rows().map(row -> this.serializer.deserialize(target, row.data()));
    }

    public <T> Flux<T> rowsAs(TypeRef<T> target) {
        return this.internal.rows().map(row -> this.serializer.deserialize(target, row.data()));
    }

    public Mono<QueryMetaData> metaData() {
        return this.internal.metaData().map(QueryMetaData::new);
    }
}

