/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.encryption.databind.jackson;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.java.encryption.annotation.Encrypted;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

@Stability.Internal
public class EncryptedFieldDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    private static final TypeReference<Map<String, Object>> MAP_STRING_OBJECT = new TypeReference<Map<String, Object>>(){};
    private final CryptoManager cryptoManager;
    private final Encrypted annotation;
    private final TypeReference<?> beanPropertyTypeRef;

    public EncryptedFieldDeserializer(CryptoManager cryptoManager, Encrypted annotation) {
        this(cryptoManager, annotation, (BeanProperty)new BeanProperty.Bogus());
    }

    public EncryptedFieldDeserializer(CryptoManager cryptoManager, Encrypted annotation, BeanProperty beanProperty) {
        this.cryptoManager = Objects.requireNonNull(cryptoManager);
        this.annotation = Objects.requireNonNull(annotation);
        this.beanPropertyTypeRef = EncryptedFieldDeserializer.getTypeRef(beanProperty);
    }

    private static TypeReference<?> getTypeRef(BeanProperty beanProperty) {
        final JavaType propertyType = beanProperty.getType();
        return new TypeReference<Object>(){

            public Type getType() {
                return propertyType;
            }
        };
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        return new EncryptedFieldDeserializer(this.cryptoManager, this.annotation, property);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Map encrypted = (Map)p.readValueAs(MAP_STRING_OBJECT);
        byte[] plaintext = this.cryptoManager.decrypt(encrypted);
        JsonParser plaintextParser = p.getCodec().getFactory().createParser(plaintext);
        plaintextParser.setCodec(p.getCodec());
        return plaintextParser.readValueAs(this.beanPropertyTypeRef);
    }
}

