/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.manager.bucket.CoreBucketSettings;
import com.couchbase.client.core.manager.bucket.CoreCompressionMode;
import com.couchbase.client.core.manager.bucket.CoreConflictResolutionType;
import com.couchbase.client.core.manager.bucket.CoreEvictionPolicyType;
import com.couchbase.client.core.manager.bucket.CoreStorageBackend;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.manager.bucket.BucketType;
import com.couchbase.client.java.manager.bucket.CompressionMode;
import com.couchbase.client.java.manager.bucket.ConflictResolutionType;
import com.couchbase.client.java.manager.bucket.EjectionPolicy;
import com.couchbase.client.java.manager.bucket.EvictionPolicyType;
import com.couchbase.client.java.manager.bucket.StorageBackend;
import java.time.Duration;
import org.jspecify.annotations.Nullable;

public class BucketSettings {
    private static final boolean DEFAULT_FLUSH_ENABLED = false;
    private static final long DEFAULT_RAM_QUOTA_MB = 100L;
    private static final int DEFAULT_NUM_REPLICAS = 1;
    private static final boolean DEFAULT_REPLICA_INDEXES = false;
    private static final BucketType DEFAULT_BUCKET_TYPE = BucketType.COUCHBASE;
    private static final Duration DEFAULT_MAX_EXPIRY = Duration.ZERO;
    private static final DurabilityLevel DEFAULT_MINIMUM_DURABILITY_LEVEL = DurabilityLevel.NONE;
    private static final ConflictResolutionType DEFAULT_CONFLICT_RESOLUTION = ConflictResolutionType.SEQUENCE_NUMBER;
    private final String name;
    private Boolean flushEnabled;
    private Long ramQuotaMB;
    private Integer numReplicas;
    private Boolean replicaIndexes;
    private Duration maxExpiry;
    private CompressionMode compressionMode;
    private BucketType bucketType;
    private ConflictResolutionType conflictResolutionType;
    private EvictionPolicyType evictionPolicy;
    private DurabilityLevel minimumDurabilityLevel;
    private StorageBackend storageBackend;
    private Boolean historyRetentionCollectionDefault;
    private Long historyRetentionBytes;
    private Duration historyRetentionDuration;
    private Integer numVBuckets;
    private boolean healthy = true;

    @Stability.Internal
    public BucketSettings(CoreBucketSettings internal) {
        this.name = internal.name();
        this.flushEnabled = internal.flushEnabled();
        this.ramQuotaMB = internal.ramQuotaMB();
        this.replicaIndexes = internal.replicaIndexes();
        this.numReplicas = internal.numReplicas();
        this.maxExpiry = internal.maxExpiry();
        if (internal.compressionMode() != null) {
            switch (internal.compressionMode()) {
                case OFF: {
                    this.compressionMode = CompressionMode.OFF;
                    break;
                }
                case PASSIVE: {
                    this.compressionMode = CompressionMode.PASSIVE;
                    break;
                }
                case ACTIVE: {
                    this.compressionMode = CompressionMode.ACTIVE;
                    break;
                }
                default: {
                    throw new CouchbaseException("Unknown compression mode");
                }
            }
        }
        if (internal.bucketType() != null) {
            switch (internal.bucketType()) {
                case COUCHBASE: {
                    this.bucketType = BucketType.COUCHBASE;
                    break;
                }
                case EPHEMERAL: {
                    this.bucketType = BucketType.EPHEMERAL;
                    break;
                }
                case MEMCACHED: {
                    this.bucketType = BucketType.MEMCACHED;
                }
            }
        }
        if (internal.conflictResolutionType() != null) {
            switch (internal.conflictResolutionType()) {
                case CUSTOM: {
                    this.conflictResolutionType = ConflictResolutionType.CUSTOM;
                    break;
                }
                case SEQUENCE_NUMBER: {
                    this.conflictResolutionType = ConflictResolutionType.SEQUENCE_NUMBER;
                    break;
                }
                case TIMESTAMP: {
                    this.conflictResolutionType = ConflictResolutionType.TIMESTAMP;
                }
            }
        }
        if (internal.evictionPolicy() != null) {
            switch (internal.evictionPolicy()) {
                case FULL: {
                    this.evictionPolicy = EvictionPolicyType.FULL;
                    break;
                }
                case VALUE_ONLY: {
                    this.evictionPolicy = EvictionPolicyType.VALUE_ONLY;
                    break;
                }
                case NOT_RECENTLY_USED: {
                    this.evictionPolicy = EvictionPolicyType.NOT_RECENTLY_USED;
                    break;
                }
                case NO_EVICTION: {
                    this.evictionPolicy = EvictionPolicyType.NO_EVICTION;
                }
            }
        }
        this.minimumDurabilityLevel = internal.minimumDurabilityLevel();
        if (internal.storageBackend() != null) {
            if (internal.storageBackend() == CoreStorageBackend.COUCHSTORE) {
                this.storageBackend = StorageBackend.COUCHSTORE;
            } else if (internal.storageBackend() == CoreStorageBackend.MAGMA) {
                this.storageBackend = StorageBackend.MAGMA;
            }
        }
        this.numVBuckets = internal.numVBuckets();
        this.historyRetentionCollectionDefault = internal.historyRetentionCollectionDefault();
        this.historyRetentionBytes = internal.historyRetentionBytes();
        this.historyRetentionDuration = internal.historyRetentionDuration();
    }

    BucketSettings(String name) {
        this.name = name;
    }

    public static BucketSettings create(String name) {
        return new BucketSettings(name);
    }

    public String name() {
        return this.name;
    }

    public boolean flushEnabled() {
        return this.flushEnabled;
    }

    public long ramQuotaMB() {
        return this.ramQuotaMB;
    }

    public int numReplicas() {
        return this.numReplicas;
    }

    public boolean replicaIndexes() {
        return this.replicaIndexes;
    }

    public DurabilityLevel minimumDurabilityLevel() {
        return this.minimumDurabilityLevel;
    }

    public Duration maxExpiry() {
        return this.maxExpiry;
    }

    public CompressionMode compressionMode() {
        if (this.compressionMode == null) {
            return CompressionMode.OFF;
        }
        return this.compressionMode;
    }

    public BucketType bucketType() {
        return this.bucketType;
    }

    public ConflictResolutionType conflictResolutionType() {
        return this.conflictResolutionType;
    }

    public StorageBackend storageBackend() {
        return this.storageBackend;
    }

    public Duration historyRetentionDuration() {
        return this.historyRetentionDuration;
    }

    public Long historyRetentionBytes() {
        return this.historyRetentionBytes;
    }

    public Boolean historyRetentionCollectionDefault() {
        return this.historyRetentionCollectionDefault;
    }

    public EvictionPolicyType evictionPolicy() {
        return this.evictionPolicy;
    }

    @Stability.Internal
    public boolean healthy() {
        return this.healthy;
    }

    public BucketSettings flushEnabled(boolean flushEnabled) {
        this.flushEnabled = flushEnabled;
        return this;
    }

    public BucketSettings ramQuotaMB(long ramQuotaMB) {
        this.ramQuotaMB = ramQuotaMB;
        return this;
    }

    public BucketSettings numReplicas(int numReplicas) {
        this.numReplicas = numReplicas;
        return this;
    }

    public BucketSettings replicaIndexes(boolean replicaIndexes) {
        this.replicaIndexes = replicaIndexes;
        return this;
    }

    public BucketSettings maxExpiry(Duration maxExpiry) {
        this.maxExpiry = (Duration)Validators.notNull((Object)maxExpiry, (String)"MaxExpiry");
        return this;
    }

    public BucketSettings compressionMode(CompressionMode compressionMode) {
        this.compressionMode = (CompressionMode)((Object)Validators.notNull((Object)((Object)compressionMode), (String)"CompressionMode"));
        return this;
    }

    public BucketSettings bucketType(BucketType bucketType) {
        this.bucketType = (BucketType)((Object)Validators.notNull((Object)((Object)bucketType), (String)"BucketType"));
        return this;
    }

    public BucketSettings conflictResolutionType(ConflictResolutionType conflictResolutionType) {
        this.conflictResolutionType = (ConflictResolutionType)((Object)Validators.notNull((Object)((Object)conflictResolutionType), (String)"ConflictResolutionType"));
        return this;
    }

    public BucketSettings evictionPolicy(EvictionPolicyType evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public BucketSettings minimumDurabilityLevel(DurabilityLevel durabilityLevel) {
        this.minimumDurabilityLevel = (DurabilityLevel)Validators.notNull((Object)durabilityLevel, (String)"DurabilityLevel");
        return this;
    }

    public BucketSettings storageBackend(StorageBackend storageBackend) {
        this.storageBackend = (StorageBackend)Validators.notNull((Object)storageBackend, (String)"storageBackend");
        return this;
    }

    public BucketSettings numVBuckets(@Nullable Integer numVBuckets) {
        this.numVBuckets = numVBuckets;
        return this;
    }

    public @Nullable Integer numVBuckets() {
        return this.numVBuckets;
    }

    public BucketSettings historyRetentionCollectionDefault(Boolean historyRetentionCollectionDefault) {
        this.historyRetentionCollectionDefault = (Boolean)Validators.notNull((Object)historyRetentionCollectionDefault, (String)"historyRetentionCollectionDefault");
        return this;
    }

    public BucketSettings historyRetentionBytes(Long historyRetentionBytes) {
        this.historyRetentionBytes = (Long)Validators.notNull((Object)historyRetentionBytes, (String)"historyRetentionBytes");
        return this;
    }

    public BucketSettings historyRetentionDuration(Duration historyRetentionDuration) {
        this.historyRetentionDuration = (Duration)Validators.notNull((Object)historyRetentionDuration, (String)"historyRetentionDuration");
        return this;
    }

    @Deprecated
    public int maxTTL() {
        return (int)this.maxExpiry().getSeconds();
    }

    @Deprecated
    public BucketSettings maxTTL(int maxTTL) {
        return this.maxExpiry(Duration.ofSeconds(maxTTL));
    }

    @Deprecated
    public EjectionPolicy ejectionPolicy() {
        return EjectionPolicy.of(this.evictionPolicy);
    }

    @Deprecated
    public BucketSettings ejectionPolicy(EjectionPolicy ejectionPolicy) {
        this.evictionPolicy = ejectionPolicy == null ? null : ejectionPolicy.toEvictionPolicy();
        return this;
    }

    @Stability.Internal
    public CoreBucketSettings toCore() {
        return new CoreBucketSettings(){

            public String name() {
                return BucketSettings.this.name;
            }

            public Boolean flushEnabled() {
                return BucketSettings.this.flushEnabled;
            }

            public Long ramQuotaMB() {
                return BucketSettings.this.ramQuotaMB;
            }

            public Integer numReplicas() {
                return BucketSettings.this.numReplicas;
            }

            public Boolean replicaIndexes() {
                return BucketSettings.this.replicaIndexes;
            }

            public com.couchbase.client.core.config.BucketType bucketType() {
                if (BucketSettings.this.bucketType != null) {
                    switch (BucketSettings.this.bucketType) {
                        case COUCHBASE: {
                            return com.couchbase.client.core.config.BucketType.COUCHBASE;
                        }
                        case MEMCACHED: {
                            return com.couchbase.client.core.config.BucketType.MEMCACHED;
                        }
                        case EPHEMERAL: {
                            return com.couchbase.client.core.config.BucketType.EPHEMERAL;
                        }
                    }
                    throw new CouchbaseException("Unknown bucket type " + (Object)((Object)BucketSettings.this.bucketType));
                }
                return null;
            }

            public CoreConflictResolutionType conflictResolutionType() {
                if (BucketSettings.this.conflictResolutionType == null) {
                    return null;
                }
                switch (BucketSettings.this.conflictResolutionType) {
                    case TIMESTAMP: {
                        return CoreConflictResolutionType.TIMESTAMP;
                    }
                    case SEQUENCE_NUMBER: {
                        return CoreConflictResolutionType.SEQUENCE_NUMBER;
                    }
                    case CUSTOM: {
                        return CoreConflictResolutionType.CUSTOM;
                    }
                }
                throw new CouchbaseException("Unknown conflict resolution type");
            }

            public CoreEvictionPolicyType evictionPolicy() {
                if (BucketSettings.this.evictionPolicy == null) {
                    return null;
                }
                switch (BucketSettings.this.evictionPolicy) {
                    case FULL: {
                        return CoreEvictionPolicyType.FULL;
                    }
                    case VALUE_ONLY: {
                        return CoreEvictionPolicyType.VALUE_ONLY;
                    }
                    case NOT_RECENTLY_USED: {
                        return CoreEvictionPolicyType.NOT_RECENTLY_USED;
                    }
                    case NO_EVICTION: {
                        return CoreEvictionPolicyType.NO_EVICTION;
                    }
                }
                throw new CouchbaseException("Unknown eviction policy " + (Object)((Object)BucketSettings.this.evictionPolicy));
            }

            public Duration maxExpiry() {
                return BucketSettings.this.maxExpiry;
            }

            public CoreCompressionMode compressionMode() {
                if (BucketSettings.this.compressionMode == null) {
                    return null;
                }
                switch (BucketSettings.this.compressionMode) {
                    case OFF: {
                        return CoreCompressionMode.OFF;
                    }
                    case PASSIVE: {
                        return CoreCompressionMode.PASSIVE;
                    }
                    case ACTIVE: {
                        return CoreCompressionMode.ACTIVE;
                    }
                }
                throw new CouchbaseException("Unknown compression mode " + (Object)((Object)BucketSettings.this.compressionMode));
            }

            public DurabilityLevel minimumDurabilityLevel() {
                return BucketSettings.this.minimumDurabilityLevel;
            }

            public CoreStorageBackend storageBackend() {
                return BucketSettings.this.storageBackend == null ? null : CoreStorageBackend.of((String)BucketSettings.this.storageBackend.alias());
            }

            public @Nullable Integer numVBuckets() {
                return BucketSettings.this.numVBuckets;
            }

            public Boolean historyRetentionCollectionDefault() {
                return BucketSettings.this.historyRetentionCollectionDefault;
            }

            public Long historyRetentionBytes() {
                return BucketSettings.this.historyRetentionBytes;
            }

            public Duration historyRetentionDuration() {
                return BucketSettings.this.historyRetentionDuration;
            }
        };
    }

    public String toString() {
        return "BucketSettings{name='" + RedactableArgument.redactMeta((Object)this.name) + '\'' + ", flushEnabled=" + this.flushEnabled + ", ramQuotaMB=" + this.ramQuotaMB + ", numReplicas=" + this.numReplicas + ", replicaIndexes=" + this.replicaIndexes + ", maxExpiry=" + (this.maxExpiry != null ? Long.valueOf(this.maxExpiry.getSeconds()) : null) + ", compressionMode=" + (Object)((Object)this.compressionMode) + ", bucketType=" + (Object)((Object)this.bucketType) + ", conflictResolutionType=" + (Object)((Object)this.conflictResolutionType) + ", evictionPolicy=" + (Object)((Object)this.evictionPolicy) + ", minimumDurabilityLevel=" + this.minimumDurabilityLevel + ", storageBackend=" + this.storageBackend + ", numVBuckets=" + this.numVBuckets + ", historyRetentionCollectionDefault=" + this.historyRetentionCollectionDefault + ", historyRetentionBytes=" + this.historyRetentionBytes + ", historyRetentionDuration=" + this.historyRetentionDuration + '}';
    }

    static BucketSettings merge(BucketSettings base, BucketSettings fromUser) {
        BucketSettings out = new BucketSettings(fromUser.name != null ? fromUser.name : base.name);
        out.flushEnabled = BucketSettings.defaultIfNull(fromUser.flushEnabled, base.flushEnabled);
        out.ramQuotaMB = BucketSettings.defaultIfNull(fromUser.ramQuotaMB, base.ramQuotaMB);
        out.numReplicas = BucketSettings.defaultIfNull(fromUser.numReplicas, base.numReplicas);
        out.replicaIndexes = BucketSettings.defaultIfNull(fromUser.replicaIndexes, base.replicaIndexes);
        out.maxExpiry = BucketSettings.defaultIfNull(fromUser.maxExpiry, base.maxExpiry);
        out.compressionMode = BucketSettings.defaultIfNull(fromUser.compressionMode, base.compressionMode);
        out.bucketType = BucketSettings.defaultIfNull(fromUser.bucketType, base.bucketType);
        out.conflictResolutionType = BucketSettings.defaultIfNull(fromUser.conflictResolutionType, base.conflictResolutionType);
        out.evictionPolicy = BucketSettings.defaultIfNull(fromUser.evictionPolicy, base.evictionPolicy);
        out.minimumDurabilityLevel = BucketSettings.defaultIfNull(fromUser.minimumDurabilityLevel, base.minimumDurabilityLevel);
        out.storageBackend = BucketSettings.defaultIfNull(fromUser.storageBackend, base.storageBackend);
        out.historyRetentionCollectionDefault = BucketSettings.defaultIfNull(fromUser.historyRetentionCollectionDefault, base.historyRetentionCollectionDefault);
        out.historyRetentionBytes = BucketSettings.defaultIfNull(fromUser.historyRetentionBytes, base.historyRetentionBytes);
        out.historyRetentionDuration = BucketSettings.defaultIfNull(fromUser.historyRetentionDuration, base.historyRetentionDuration);
        out.numVBuckets = BucketSettings.defaultIfNull(fromUser.numVBuckets, base.numVBuckets);
        return out;
    }

    private static <T> T defaultIfNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    static BucketSettings createDefaults(String name) {
        BucketSettings out = new BucketSettings(name);
        out.flushEnabled = false;
        out.ramQuotaMB = 100L;
        out.numReplicas = 1;
        out.replicaIndexes = false;
        out.bucketType = DEFAULT_BUCKET_TYPE;
        out.maxExpiry = DEFAULT_MAX_EXPIRY;
        out.minimumDurabilityLevel = DEFAULT_MINIMUM_DURABILITY_LEVEL;
        out.conflictResolutionType = DEFAULT_CONFLICT_RESOLUTION;
        return out;
    }
}

