/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.error.BucketExistsException;
import com.couchbase.client.core.error.BucketNotFoundException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.java.manager.ManagerSupport;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.BucketType;
import com.couchbase.client.java.manager.bucket.CompressionMode;
import com.couchbase.client.java.manager.bucket.CreateBucketOptions;
import com.couchbase.client.java.manager.bucket.DropBucketOptions;
import com.couchbase.client.java.manager.bucket.FlushBucketOptions;
import com.couchbase.client.java.manager.bucket.GetAllBucketOptions;
import com.couchbase.client.java.manager.bucket.GetBucketOptions;
import com.couchbase.client.java.manager.bucket.UpdateBucketOptions;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

@Stability.Volatile
public class AsyncBucketManager
extends ManagerSupport {
    public AsyncBucketManager(Core core) {
        super(core);
    }

    private static String pathForBuckets() {
        return "/pools/default/buckets/";
    }

    private static String pathForBucket(String bucketName) {
        return AsyncBucketManager.pathForBuckets() + UrlQueryStringBuilder.urlEncode((String)bucketName);
    }

    private static String pathForBucketFlush(String bucketName) {
        return "/pools/default/buckets/" + UrlQueryStringBuilder.urlEncode((String)bucketName) + "/controller/doFlush";
    }

    public CompletableFuture<Void> createBucket(BucketSettings settings) {
        return this.createBucket(settings, CreateBucketOptions.createBucketOptions());
    }

    public CompletableFuture<Void> createBucket(BucketSettings settings, CreateBucketOptions options) {
        CreateBucketOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_buckets_create_bucket", built.parentSpan().orElse(null), settings.name());
        return this.sendRequest(HttpMethod.POST, AsyncBucketManager.pathForBuckets(), this.convertSettingsToParams(settings, false), built, span).thenApply(response -> {
            if (response.status() == ResponseStatus.INVALID_ARGS && response.content() != null) {
                String content = new String(response.content(), StandardCharsets.UTF_8);
                if (content.contains("Bucket with given name already exists")) {
                    throw BucketExistsException.forBucket((String)settings.name());
                }
                throw new CouchbaseException(content);
            }
            AsyncBucketManager.checkStatus(response, "create bucket [" + RedactableArgument.redactMeta((Object)settings) + "]", settings.name());
            return null;
        });
    }

    public CompletableFuture<Void> updateBucket(BucketSettings settings) {
        return this.updateBucket(settings, UpdateBucketOptions.updateBucketOptions());
    }

    public CompletableFuture<Void> updateBucket(BucketSettings settings, UpdateBucketOptions options) {
        UpdateBucketOptions.Built builtOpts = options.build();
        RequestSpan span = this.buildSpan("manager_buckets_update_bucket", builtOpts.parentSpan().orElse(null), settings.name());
        span.attribute("db.system", "couchbase");
        GetAllBucketOptions getAllBucketOptions = GetAllBucketOptions.getAllBucketOptions();
        builtOpts.timeout().ifPresent(getAllBucketOptions::timeout);
        builtOpts.retryStrategy().ifPresent(getAllBucketOptions::retryStrategy);
        getAllBucketOptions.parentSpan(span);
        return Mono.fromFuture(() -> this.getAllBuckets(getAllBucketOptions)).map(buckets -> buckets.containsKey(settings.name())).flatMap(bucketExists -> {
            if (!bucketExists.booleanValue()) {
                return Mono.error((Throwable)BucketNotFoundException.forBucket((String)settings.name()));
            }
            return Mono.fromFuture((CompletableFuture)this.sendRequest(HttpMethod.POST, AsyncBucketManager.pathForBucket(settings.name()), this.convertSettingsToParams(settings, true), builtOpts, span).thenApply(response -> {
                AsyncBucketManager.checkStatus(response, "update bucket [" + RedactableArgument.redactMeta((Object)settings) + "]", settings.name());
                return null;
            }));
        }).then().toFuture();
    }

    private UrlQueryStringBuilder convertSettingsToParams(BucketSettings settings, boolean update) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames();
        params.add("ramQuotaMB", settings.ramQuotaMB());
        if (settings.bucketType() != BucketType.MEMCACHED) {
            params.add("replicaNumber", settings.numReplicas());
        }
        params.add("flushEnabled", settings.flushEnabled() ? 1 : 0);
        long maxTTL = settings.maxExpiry().getSeconds();
        if (maxTTL != 0L) {
            params.add("maxTTL", maxTTL);
        }
        if (settings.evictionPolicy() != null) {
            params.add("evictionPolicy", settings.evictionPolicy().alias());
        }
        if (settings.compressionMode() != CompressionMode.PASSIVE) {
            params.add("compressionMode", settings.compressionMode().alias());
        }
        if (settings.minimumDurabilityLevel() != DurabilityLevel.NONE) {
            params.add("durabilityMinLevel", settings.minimumDurabilityLevel().encodeForManagementApi());
        }
        if (!update) {
            params.add("name", settings.name());
            params.add("bucketType", settings.bucketType().alias());
            params.add("conflictResolutionType", settings.conflictResolutionType().alias());
            if (settings.bucketType() != BucketType.EPHEMERAL) {
                params.add("replicaIndex", settings.replicaIndexes() ? 1 : 0);
            }
        }
        return params;
    }

    public CompletableFuture<Void> dropBucket(String bucketName) {
        return this.dropBucket(bucketName, DropBucketOptions.dropBucketOptions());
    }

    public CompletableFuture<Void> dropBucket(String bucketName, DropBucketOptions options) {
        DropBucketOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_buckets_drop_bucket", built.parentSpan().orElse(null), bucketName);
        return this.sendRequest(HttpMethod.DELETE, AsyncBucketManager.pathForBucket(bucketName), built, span).thenApply(response -> {
            if (response.status() == ResponseStatus.NOT_FOUND) {
                throw BucketNotFoundException.forBucket((String)bucketName);
            }
            AsyncBucketManager.checkStatus(response, "drop bucket [" + RedactableArgument.redactMeta((Object)bucketName) + "]", bucketName);
            return null;
        });
    }

    public CompletableFuture<BucketSettings> getBucket(String bucketName) {
        return this.getBucket(bucketName, GetBucketOptions.getBucketOptions());
    }

    public CompletableFuture<BucketSettings> getBucket(String bucketName, GetBucketOptions options) {
        GetBucketOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_buckets_get_bucket", built.parentSpan().orElse(null), bucketName);
        return this.sendRequest(HttpMethod.GET, AsyncBucketManager.pathForBucket(bucketName), built, span).thenApply(response -> {
            if (response.status() == ResponseStatus.NOT_FOUND) {
                throw BucketNotFoundException.forBucket((String)bucketName);
            }
            AsyncBucketManager.checkStatus(response, "get bucket [" + RedactableArgument.redactMeta((Object)bucketName) + "]", bucketName);
            JsonNode tree = Mapper.decodeIntoTree((byte[])response.content());
            return BucketSettings.create(tree);
        });
    }

    public CompletableFuture<Map<String, BucketSettings>> getAllBuckets() {
        return this.getAllBuckets(GetAllBucketOptions.getAllBucketOptions());
    }

    public CompletableFuture<Map<String, BucketSettings>> getAllBuckets(GetAllBucketOptions options) {
        GetAllBucketOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_buckets_get_all_buckets", built.parentSpan().orElse(null), null);
        return this.sendRequest(HttpMethod.GET, AsyncBucketManager.pathForBuckets(), built, span).thenApply(response -> {
            AsyncBucketManager.checkStatus(response, "get all buckets", null);
            JsonNode tree = Mapper.decodeIntoTree((byte[])response.content());
            HashMap<String, BucketSettings> out = new HashMap<String, BucketSettings>();
            for (JsonNode bucket : tree) {
                BucketSettings b = BucketSettings.create(bucket);
                out.put(b.name(), b);
            }
            return out;
        });
    }

    public CompletableFuture<Void> flushBucket(String bucketName) {
        return this.flushBucket(bucketName, FlushBucketOptions.flushBucketOptions());
    }

    public CompletableFuture<Void> flushBucket(String bucketName, FlushBucketOptions options) {
        FlushBucketOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_buckets_flush_bucket", built.parentSpan().orElse(null), bucketName);
        return this.sendRequest(HttpMethod.POST, AsyncBucketManager.pathForBucketFlush(bucketName), options.build(), span).thenApply(response -> {
            if (response.status() == ResponseStatus.NOT_FOUND) {
                throw BucketNotFoundException.forBucket((String)bucketName);
            }
            AsyncBucketManager.checkStatus(response, "flush bucket [" + RedactableArgument.redactMeta((Object)bucketName) + "]", bucketName);
            return null;
        });
    }

    private RequestSpan buildSpan(String spanName, RequestSpan parent, String bucketName) {
        RequestSpan span = this.environment().requestTracer().requestSpan(spanName, parent);
        if (bucketName != null) {
            span.attribute("db.name", bucketName);
        }
        return span;
    }
}

