/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.java.CommonOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CreatePrimaryQueryIndexOptions
extends CommonOptions<CreatePrimaryQueryIndexOptions> {
    private Optional<String> indexName = Optional.empty();
    private boolean ignoreIfExists;
    private final Map<String, Object> with = new HashMap<String, Object>();

    private CreatePrimaryQueryIndexOptions() {
    }

    public static CreatePrimaryQueryIndexOptions createPrimaryQueryIndexOptions() {
        return new CreatePrimaryQueryIndexOptions();
    }

    public CreatePrimaryQueryIndexOptions indexName(String indexName) {
        this.indexName = Optional.ofNullable(CbStrings.emptyToNull((String)indexName));
        return this;
    }

    public CreatePrimaryQueryIndexOptions ignoreIfExists(boolean ignore) {
        this.ignoreIfExists = ignore;
        return this;
    }

    public CreatePrimaryQueryIndexOptions numReplicas(int numReplicas) {
        return this.with("num_replica", numReplicas);
    }

    public CreatePrimaryQueryIndexOptions deferred(boolean deferred) {
        return this.with("defer_build", deferred);
    }

    public CreatePrimaryQueryIndexOptions with(String optionName, Object optionValue) {
        this.with.put(optionName, optionValue);
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
        }

        public boolean ignoreIfExists() {
            return CreatePrimaryQueryIndexOptions.this.ignoreIfExists;
        }

        public Optional<String> indexName() {
            return CreatePrimaryQueryIndexOptions.this.indexName;
        }

        public Map<String, Object> with() {
            return CreatePrimaryQueryIndexOptions.this.with;
        }
    }
}

