/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.analytics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.manager.analytics.AnalyticsDataType;
import com.couchbase.client.java.manager.analytics.AnalyticsDataset;
import com.couchbase.client.java.manager.analytics.AnalyticsDataverse;
import com.couchbase.client.java.manager.analytics.AnalyticsIndex;
import com.couchbase.client.java.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.java.manager.analytics.ConnectLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateDatasetAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateDataverseAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateIndexAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DisconnectLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropDatasetAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropDataverseAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropIndexAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllDatasetsAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllDataversesAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllIndexesAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllLinksAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetPendingMutationsAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.java.manager.analytics.ReplaceLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.link.AnalyticsLink;
import java.util.List;
import java.util.Map;

public class AnalyticsIndexManager {
    private final AsyncAnalyticsIndexManager async;
    private final ReactiveAnalyticsIndexManager reactive;

    public AnalyticsIndexManager(Cluster cluster) {
        this.async = new AsyncAnalyticsIndexManager(cluster.async());
        this.reactive = new ReactiveAnalyticsIndexManager(cluster.async());
    }

    public AsyncAnalyticsIndexManager async() {
        return this.async;
    }

    public ReactiveAnalyticsIndexManager reactive() {
        return this.reactive;
    }

    public void createDataverse(String dataverseName) {
        AsyncUtils.block(this.async.createDataverse(dataverseName));
    }

    public void createDataverse(String dataverseName, CreateDataverseAnalyticsOptions options) {
        AsyncUtils.block(this.async.createDataverse(dataverseName, options));
    }

    public void dropDataverse(String dataverseName) {
        AsyncUtils.block(this.async.dropDataverse(dataverseName));
    }

    public void dropDataverse(String dataverseName, DropDataverseAnalyticsOptions options) {
        AsyncUtils.block(this.async.dropDataverse(dataverseName, options));
    }

    @Stability.Uncommitted
    public List<AnalyticsDataverse> getAllDataverses(GetAllDataversesAnalyticsOptions options) {
        return AsyncUtils.block(this.async.getAllDataverses(options));
    }

    @Stability.Uncommitted
    public List<AnalyticsDataverse> getAllDataverses() {
        return AsyncUtils.block(this.async.getAllDataverses());
    }

    public void createDataset(String datasetName, String bucketName) {
        AsyncUtils.block(this.async.createDataset(datasetName, bucketName));
    }

    public void createDataset(String datasetName, String bucketName, CreateDatasetAnalyticsOptions options) {
        AsyncUtils.block(this.async.createDataset(datasetName, bucketName, options));
    }

    public void dropDataset(String datasetName) {
        AsyncUtils.block(this.async.dropDataset(datasetName));
    }

    public void dropDataset(String datasetName, DropDatasetAnalyticsOptions options) {
        AsyncUtils.block(this.async.dropDataset(datasetName, options));
    }

    public List<AnalyticsDataset> getAllDatasets() {
        return AsyncUtils.block(this.async.getAllDatasets());
    }

    public List<AnalyticsDataset> getAllDatasets(GetAllDatasetsAnalyticsOptions options) {
        return AsyncUtils.block(this.async.getAllDatasets(options));
    }

    public void createIndex(String indexName, String datasetName, Map<String, AnalyticsDataType> fields) {
        AsyncUtils.block(this.async.createIndex(indexName, datasetName, fields));
    }

    public void createIndex(String indexName, String datasetName, Map<String, AnalyticsDataType> fields, CreateIndexAnalyticsOptions options) {
        AsyncUtils.block(this.async.createIndex(indexName, datasetName, fields, options));
    }

    public void dropIndex(String indexName, String datasetName) {
        AsyncUtils.block(this.async.dropIndex(indexName, datasetName));
    }

    public void dropIndex(String indexName, String datasetName, DropIndexAnalyticsOptions options) {
        AsyncUtils.block(this.async.dropIndex(indexName, datasetName, options));
    }

    public List<AnalyticsIndex> getAllIndexes() {
        return AsyncUtils.block(this.async.getAllIndexes());
    }

    public List<AnalyticsIndex> getAllIndexes(GetAllIndexesAnalyticsOptions options) {
        return AsyncUtils.block(this.async.getAllIndexes(options));
    }

    public void connectLink() {
        AsyncUtils.block(this.async.connectLink());
    }

    public void connectLink(ConnectLinkAnalyticsOptions options) {
        AsyncUtils.block(this.async.connectLink(options));
    }

    public void disconnectLink() {
        AsyncUtils.block(this.async.disconnectLink());
    }

    public void disconnectLink(DisconnectLinkAnalyticsOptions options) {
        AsyncUtils.block(this.async.disconnectLink(options));
    }

    public Map<String, Map<String, Long>> getPendingMutations() {
        return AsyncUtils.block(this.async.getPendingMutations());
    }

    public Map<String, Map<String, Long>> getPendingMutations(GetPendingMutationsAnalyticsOptions options) {
        return AsyncUtils.block(this.async.getPendingMutations(options));
    }

    public void createLink(AnalyticsLink link) {
        AsyncUtils.block(this.async.createLink(link));
    }

    public void createLink(AnalyticsLink link, CreateLinkAnalyticsOptions options) {
        AsyncUtils.block(this.async.createLink(link, options));
    }

    public void replaceLink(AnalyticsLink link) {
        AsyncUtils.block(this.async.replaceLink(link));
    }

    public void replaceLink(AnalyticsLink link, ReplaceLinkAnalyticsOptions options) {
        AsyncUtils.block(this.async.replaceLink(link, options));
    }

    public void dropLink(String linkName, String dataverse) {
        AsyncUtils.block(this.async.dropLink(linkName, dataverse));
    }

    public void dropLink(String linkName, String dataverse, DropLinkAnalyticsOptions options) {
        AsyncUtils.block(this.async.dropLink(linkName, dataverse, options));
    }

    public List<AnalyticsLink> getAllLinks() {
        return AsyncUtils.block(this.async.getAllLinks());
    }

    public List<AnalyticsLink> getAllLinks(GetAllLinksAnalyticsOptions options) {
        return AsyncUtils.block(this.async.getAllLinks(options));
    }
}

