/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.view;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponseStatus;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DesignDocumentNotFoundException;
import com.couchbase.client.core.error.HttpStatusCodeException;
import com.couchbase.client.core.error.context.ReducedViewErrorContext;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.msg.view.GenericViewRequest;
import com.couchbase.client.core.msg.view.GenericViewResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.manager.ManagerSupport;
import com.couchbase.client.java.manager.view.DesignDocument;
import com.couchbase.client.java.manager.view.DropDesignDocumentOptions;
import com.couchbase.client.java.manager.view.GetAllDesignDocumentsOptions;
import com.couchbase.client.java.manager.view.GetDesignDocumentOptions;
import com.couchbase.client.java.manager.view.PublishDesignDocumentOptions;
import com.couchbase.client.java.manager.view.UpsertDesignDocumentOptions;
import com.couchbase.client.java.manager.view.View;
import com.couchbase.client.java.view.DesignDocumentNamespace;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class AsyncViewIndexManager {
    private final Core core;
    private final String bucket;

    public AsyncViewIndexManager(Core core, String bucket) {
        this.core = Objects.requireNonNull(core);
        this.bucket = Objects.requireNonNull(bucket);
    }

    private String pathForDesignDocument(String name, DesignDocumentNamespace namespace) {
        name = namespace.adjustName(DesignDocumentNamespace.requireUnqualified(name));
        return "/" + UrlQueryStringBuilder.urlEncode((String)this.bucket) + "/_design/" + UrlQueryStringBuilder.urlEncode((String)name);
    }

    private String pathForAllDesignDocuments() {
        return "/pools/default/buckets/" + UrlQueryStringBuilder.urlEncode((String)this.bucket) + "/ddocs";
    }

    public CompletableFuture<List<DesignDocument>> getAllDesignDocuments(DesignDocumentNamespace namespace) {
        return this.getAllDesignDocuments(namespace, GetAllDesignDocumentsOptions.getAllDesignDocumentsOptions());
    }

    public CompletableFuture<List<DesignDocument>> getAllDesignDocuments(DesignDocumentNamespace namespace, GetAllDesignDocumentsOptions options) {
        Validators.notNull((Object)((Object)namespace), (String)"DesignDocumentNamespace", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull((Object)options, (String)"GetAllDesignDocumentsOptions", () -> new ReducedViewErrorContext(null, null, this.bucket));
        GetAllDesignDocumentsOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_views_get_all_design_documents", built.parentSpan().orElse(null));
        span.setAttribute("db.name", this.bucket);
        return new ConfigManager().sendRequest(HttpMethod.GET, this.pathForAllDesignDocuments(), built, span).thenApply(response -> {
            if (response.status() != ResponseStatus.SUCCESS) {
                throw new CouchbaseException("Failed to get all design documents; response status=" + response.status() + "; response body=" + new String(response.content(), StandardCharsets.UTF_8));
            }
            return AsyncViewIndexManager.parseAllDesignDocuments(Mapper.decodeIntoTree((byte[])response.content()), namespace);
        });
    }

    private static List<DesignDocument> parseAllDesignDocuments(JsonNode node, DesignDocumentNamespace namespace) {
        ArrayList<DesignDocument> result = new ArrayList<DesignDocument>();
        node.get("rows").forEach(row -> {
            String metaId = row.path("doc").path("meta").path("id").asText();
            String ddocName = CbStrings.removeStart((String)metaId, (String)"_design/");
            if (namespace.contains(ddocName)) {
                JsonNode ddocDef = row.path("doc").path("json");
                result.add(AsyncViewIndexManager.parseDesignDocument(ddocName, ddocDef));
            }
        });
        return result;
    }

    public CompletableFuture<DesignDocument> getDesignDocument(String name, DesignDocumentNamespace namespace) {
        return this.getDesignDocument(name, namespace, GetDesignDocumentOptions.getDesignDocumentOptions());
    }

    public CompletableFuture<DesignDocument> getDesignDocument(String name, DesignDocumentNamespace namespace, GetDesignDocumentOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull((Object)((Object)namespace), (String)"DesignDocumentNamespace", () -> new ReducedViewErrorContext(name, null, this.bucket));
        Validators.notNull((Object)options, (String)"GetDesignDocumentOptions", () -> new ReducedViewErrorContext(name, null, this.bucket));
        GetDesignDocumentOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_views_get_design_document", built.parentSpan().orElse(null));
        return ((CompletableFuture)this.sendRequest(HttpMethod.GET, this.pathForDesignDocument(name, namespace), built, span).exceptionally(t -> {
            throw AsyncViewIndexManager.notFound(t) ? DesignDocumentNotFoundException.forName((String)name, (String)namespace.toString()) : new CouchbaseException("Failed to get design document [" + RedactableArgument.redactMeta((Object)name) + "] from namespace " + (Object)((Object)namespace), t);
        })).thenApply(response -> AsyncViewIndexManager.parseDesignDocument(name, Mapper.decodeIntoTree((byte[])response.content())));
    }

    private static DesignDocument parseDesignDocument(String name, JsonNode node) {
        ObjectNode viewsNode = (ObjectNode)node.path("views");
        Map views = (Map)Mapper.convertValue((Object)viewsNode, (TypeReference)new TypeReference<Map<String, View>>(){});
        return new DesignDocument(CbStrings.removeStart((String)name, (String)"dev_"), views);
    }

    public CompletableFuture<Void> upsertDesignDocument(DesignDocument doc, DesignDocumentNamespace namespace) {
        return this.upsertDesignDocument(doc, namespace, UpsertDesignDocumentOptions.upsertDesignDocumentOptions());
    }

    public CompletableFuture<Void> upsertDesignDocument(DesignDocument doc, DesignDocumentNamespace namespace, UpsertDesignDocumentOptions options) {
        Validators.notNull((Object)doc, (String)"DesignDocument", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull((Object)((Object)namespace), (String)"DesignDocumentNamespace", () -> new ReducedViewErrorContext(doc.name(), null, this.bucket));
        Validators.notNull((Object)options, (String)"UpsertDesignDocumentOptions", () -> new ReducedViewErrorContext(doc.name(), null, this.bucket));
        UpsertDesignDocumentOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_views_upsert_design_document", built.parentSpan().orElse(null));
        ObjectNode body = AsyncViewIndexManager.toJson(doc);
        return this.sendJsonRequest(HttpMethod.PUT, this.pathForDesignDocument(doc.name(), namespace), built, body, span).thenApply(response -> null);
    }

    public CompletableFuture<Void> publishDesignDocument(String name) {
        return this.publishDesignDocument(name, PublishDesignDocumentOptions.publishDesignDocumentOptions());
    }

    public CompletableFuture<Void> publishDesignDocument(String name, PublishDesignDocumentOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull((Object)options, (String)"PublishDesignDocumentOptions", () -> new ReducedViewErrorContext(name, null, this.bucket));
        PublishDesignDocumentOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_views_publish_design_document", built.parentSpan().orElse(null));
        return ((CompletableFuture)this.getDesignDocument(name, DesignDocumentNamespace.DEVELOPMENT, (GetDesignDocumentOptions)GetDesignDocumentOptions.getDesignDocumentOptions().parentSpan(span)).thenCompose(doc -> this.upsertDesignDocument((DesignDocument)doc, DesignDocumentNamespace.PRODUCTION, (UpsertDesignDocumentOptions)UpsertDesignDocumentOptions.upsertDesignDocumentOptions().parentSpan(span)))).whenComplete((r, t) -> {
            if (span != null) {
                span.end();
            }
        });
    }

    public CompletableFuture<Void> dropDesignDocument(String name, DesignDocumentNamespace namespace) {
        return this.dropDesignDocument(name, namespace, DropDesignDocumentOptions.dropDesignDocumentOptions());
    }

    public CompletableFuture<Void> dropDesignDocument(String name, DesignDocumentNamespace namespace, DropDesignDocumentOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull((Object)((Object)namespace), (String)"DesignDocumentNamespace", () -> new ReducedViewErrorContext(name, null, this.bucket));
        Validators.notNull((Object)options, (String)"DropDesignDocumentOptions", () -> new ReducedViewErrorContext(name, null, this.bucket));
        DropDesignDocumentOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_views_drop_design_document", built.parentSpan().orElse(null));
        return ((CompletableFuture)this.sendRequest(HttpMethod.DELETE, this.pathForDesignDocument(name, namespace), built, span).exceptionally(t -> {
            if (AsyncViewIndexManager.notFound(t)) {
                throw DesignDocumentNotFoundException.forName((String)name, (String)namespace.toString());
            }
            throw new CouchbaseException("Failed to drop design document [" + RedactableArgument.redactMeta((Object)name) + "] from namespace " + (Object)((Object)namespace), t);
        })).thenApply(response -> null);
    }

    private static boolean notFound(Throwable t) {
        return AsyncViewIndexManager.getHttpStatusCode(t) == HttpResponseStatus.NOT_FOUND.code();
    }

    private static int getHttpStatusCode(Throwable t) {
        return CbThrowables.findCause((Throwable)t, HttpStatusCodeException.class).map(HttpStatusCodeException::code).orElse(0);
    }

    private static ObjectNode toJson(DesignDocument doc) {
        ObjectNode root = Mapper.createObjectNode();
        ObjectNode views = root.putObject("views");
        doc.views().forEach((k, v) -> {
            ObjectNode viewNode = Mapper.createObjectNode();
            viewNode.put("map", v.map());
            v.reduce().ifPresent(r -> viewNode.put("reduce", r));
            views.set(k, (JsonNode)viewNode);
        });
        return root;
    }

    private CompletableFuture<GenericViewResponse> sendRequest(GenericViewRequest request) {
        this.core.send((Request)request);
        return request.response();
    }

    private CompletableFuture<GenericViewResponse> sendRequest(HttpMethod method, String path, CommonOptions.BuiltCommonOptions options, RequestSpan span) {
        return this.sendRequest(new GenericViewRequest(this.timeout(options), this.core.context(), this.retryStrategy(options), () -> new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path), method == HttpMethod.GET, this.bucket, span)).whenComplete((r, t) -> {
            if (span != null) {
                span.end();
            }
        });
    }

    private CompletableFuture<GenericViewResponse> sendJsonRequest(HttpMethod method, String path, CommonOptions.BuiltCommonOptions options, Object body, RequestSpan span) {
        return this.sendRequest(new GenericViewRequest(this.timeout(options), this.core.context(), this.retryStrategy(options), () -> {
            ByteBuf content = Unpooled.copiedBuffer((byte[])Mapper.encodeAsBytes((Object)body));
            DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path, content);
            req.headers().add("Content-Type", (Object)HttpHeaderValues.APPLICATION_JSON);
            req.headers().add("Content-Length", (Object)content.readableBytes());
            return req;
        }, method == HttpMethod.GET, this.bucket, span)).whenComplete((r, t) -> {
            if (span != null) {
                span.end();
            }
        });
    }

    private Duration timeout(CommonOptions.BuiltCommonOptions options) {
        return options.timeout().orElse(this.core.context().environment().timeoutConfig().managementTimeout());
    }

    private RetryStrategy retryStrategy(CommonOptions.BuiltCommonOptions options) {
        return options.retryStrategy().orElse(this.core.context().environment().retryStrategy());
    }

    private RequestSpan buildSpan(String spanName, RequestSpan parent) {
        RequestSpan span = this.core.context().environment().requestTracer().requestSpan(spanName, parent);
        span.setAttribute("db.system", "couchbase");
        return span;
    }

    private class ConfigManager
    extends ManagerSupport {
        public ConfigManager() {
            super(AsyncViewIndexManager.this.core);
        }

        @Override
        public CompletableFuture<GenericManagerResponse> sendRequest(HttpMethod method, String path, CommonOptions.BuiltCommonOptions options, RequestSpan span) {
            return super.sendRequest(method, path, options, span);
        }
    }
}

