/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.ReactiveBucket;
import com.couchbase.client.java.Scope;
import com.couchbase.client.java.diagnostics.PingOptions;
import com.couchbase.client.java.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.manager.collection.CollectionManager;
import com.couchbase.client.java.manager.view.ViewIndexManager;
import com.couchbase.client.java.view.ViewOptions;
import com.couchbase.client.java.view.ViewResult;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Bucket {
    private final AsyncBucket asyncBucket;
    private final ReactiveBucket reactiveBucket;
    private final CollectionManager collectionManager;
    private final ViewIndexManager viewManager;
    private final Map<String, Scope> scopeCache = new ConcurrentHashMap<String, Scope>();

    Bucket(AsyncBucket asyncBucket) {
        this.asyncBucket = asyncBucket;
        this.reactiveBucket = new ReactiveBucket(asyncBucket);
        this.collectionManager = new CollectionManager(asyncBucket.collections());
        this.viewManager = new ViewIndexManager(asyncBucket.viewIndexes());
    }

    public AsyncBucket async() {
        return this.asyncBucket;
    }

    public ReactiveBucket reactive() {
        return this.reactiveBucket;
    }

    public String name() {
        return this.asyncBucket.name();
    }

    public ClusterEnvironment environment() {
        return this.asyncBucket.environment();
    }

    public CollectionManager collections() {
        return this.collectionManager;
    }

    public ViewIndexManager viewIndexes() {
        return this.viewManager;
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncBucket.core();
    }

    @Stability.Volatile
    public Scope scope(String name) {
        return this.scopeCache.computeIfAbsent(name, n -> new Scope(this.asyncBucket.scope((String)n)));
    }

    @Stability.Volatile
    public Scope defaultScope() {
        return this.scopeCache.computeIfAbsent("_default", n -> new Scope(this.asyncBucket.defaultScope()));
    }

    public Collection defaultCollection() {
        return this.defaultScope().defaultCollection();
    }

    @Stability.Volatile
    public Collection collection(String collectionName) {
        return this.defaultScope().collection(collectionName);
    }

    public ViewResult viewQuery(String designDoc, String viewName) {
        return this.viewQuery(designDoc, viewName, ReactiveBucket.DEFAULT_VIEW_OPTIONS);
    }

    public ViewResult viewQuery(String designDoc, String viewName, ViewOptions options) {
        return AsyncUtils.block(this.asyncBucket.viewQuery(designDoc, viewName, options));
    }

    public PingResult ping() {
        return AsyncUtils.block(this.asyncBucket.ping());
    }

    public PingResult ping(PingOptions options) {
        return AsyncUtils.block(this.asyncBucket.ping(options));
    }

    public void waitUntilReady(Duration timeout) {
        AsyncUtils.block(this.asyncBucket.waitUntilReady(timeout));
    }

    public void waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        AsyncUtils.block(this.asyncBucket.waitUntilReady(timeout, options));
    }
}

