/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.SearchQuery;

public class TermRangeQuery
extends SearchQuery {
    private String min;
    private String max;
    private Boolean inclusiveMin = null;
    private Boolean inclusiveMax = null;
    private String field;

    public TermRangeQuery min(String min, boolean inclusive) {
        this.min = min;
        this.inclusiveMin = inclusive;
        return this;
    }

    public TermRangeQuery min(String min) {
        this.min = min;
        this.inclusiveMin = null;
        return this;
    }

    public TermRangeQuery max(String max, boolean inclusive) {
        this.max = max;
        this.inclusiveMax = inclusive;
        return this;
    }

    public TermRangeQuery max(String max) {
        this.max = max;
        this.inclusiveMax = null;
        return this;
    }

    public TermRangeQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public TermRangeQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        if (this.min == null && this.max == null) {
            throw new NullPointerException("TermRangeQuery needs at least one of min or max");
        }
        if (this.min != null) {
            input.put("min", this.min);
            if (this.inclusiveMin != null) {
                input.put("inclusive_min", this.inclusiveMin);
            }
        }
        if (this.max != null) {
            input.put("max", this.max);
            if (this.inclusiveMax != null) {
                input.put("inclusive_max", this.inclusiveMax);
            }
        }
        if (this.field != null) {
            input.put("field", this.field);
        }
    }
}

