/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.collection;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.CollectionsManifest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.error.CollectionExistsException;
import com.couchbase.client.core.error.CollectionNotFoundException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.ScopeExistsException;
import com.couchbase.client.core.error.ScopeNotFoundException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.manager.ManagerSupport;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.manager.collection.CreateCollectionOptions;
import com.couchbase.client.java.manager.collection.CreateScopeOptions;
import com.couchbase.client.java.manager.collection.DropCollectionOptions;
import com.couchbase.client.java.manager.collection.DropScopeOptions;
import com.couchbase.client.java.manager.collection.GetAllScopesOptions;
import com.couchbase.client.java.manager.collection.GetScopeOptions;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Stability.Volatile
public class AsyncCollectionManager
extends ManagerSupport {
    private final String bucketName;

    public AsyncCollectionManager(Core core, String bucketName) {
        super(core);
        this.bucketName = bucketName;
    }

    private static String pathForScope(String bucketName, String scopeName) {
        return AsyncCollectionManager.pathForManifest(bucketName) + "/" + UrlQueryStringBuilder.urlEncode((String)scopeName);
    }

    private static String pathForCollection(String bucketName, String scopeName, String collectionName) {
        return AsyncCollectionManager.pathForScope(bucketName, scopeName) + "/" + UrlQueryStringBuilder.urlEncode((String)collectionName);
    }

    private static String pathForManifest(String bucketName) {
        return "/pools/default/buckets/" + UrlQueryStringBuilder.urlEncode((String)bucketName) + "/collections";
    }

    public CompletableFuture<Void> createCollection(CollectionSpec collectionSpec) {
        return this.createCollection(collectionSpec, CreateCollectionOptions.createCollectionOptions());
    }

    public CompletableFuture<Void> createCollection(CollectionSpec collectionSpec, CreateCollectionOptions options) {
        UrlQueryStringBuilder body = UrlQueryStringBuilder.create().add("name", collectionSpec.name());
        if (!collectionSpec.maxExpiry().isZero()) {
            body.add("maxTTL", collectionSpec.maxExpiry().getSeconds());
        }
        String path = AsyncCollectionManager.pathForScope(this.bucketName, collectionSpec.scopeName());
        return this.sendRequest(HttpMethod.POST, path, body, options.build()).thenApply(response -> {
            this.checkForErrors((GenericManagerResponse)response, collectionSpec.scopeName(), collectionSpec.name());
            return null;
        });
    }

    public CompletableFuture<Void> createScope(String scopeName) {
        return this.createScope(scopeName, CreateScopeOptions.createScopeOptions());
    }

    public CompletableFuture<Void> createScope(String scopeName, CreateScopeOptions options) {
        UrlQueryStringBuilder body = UrlQueryStringBuilder.create().add("name", scopeName);
        String path = AsyncCollectionManager.pathForManifest(this.bucketName);
        return this.sendRequest(HttpMethod.POST, path, body, options.build()).thenApply(response -> {
            this.checkForErrors((GenericManagerResponse)response, scopeName, null);
            return null;
        });
    }

    public CompletableFuture<Void> dropCollection(CollectionSpec collectionSpec) {
        return this.dropCollection(collectionSpec, DropCollectionOptions.dropCollectionOptions());
    }

    public CompletableFuture<Void> dropCollection(CollectionSpec collectionSpec, DropCollectionOptions options) {
        String path = AsyncCollectionManager.pathForCollection(this.bucketName, collectionSpec.scopeName(), collectionSpec.name());
        return this.sendRequest(HttpMethod.DELETE, path, options.build()).thenApply(response -> {
            this.checkForErrors((GenericManagerResponse)response, collectionSpec.scopeName(), collectionSpec.name());
            return null;
        });
    }

    public CompletableFuture<Void> dropScope(String scopeName) {
        return this.dropScope(scopeName, DropScopeOptions.dropScopeOptions());
    }

    public CompletableFuture<Void> dropScope(String scopeName, DropScopeOptions options) {
        return this.sendRequest(HttpMethod.DELETE, AsyncCollectionManager.pathForScope(this.bucketName, scopeName), options.build()).thenApply(response -> {
            this.checkForErrors((GenericManagerResponse)response, scopeName, null);
            return null;
        });
    }

    public CompletableFuture<ScopeSpec> getScope(String scopeName) {
        return this.getScope(scopeName, GetScopeOptions.getScopeOptions());
    }

    public CompletableFuture<ScopeSpec> getScope(String scopeName, GetScopeOptions options) {
        GetScopeOptions.Built opts = options.build();
        GetAllScopesOptions toPassOptions = GetAllScopesOptions.getAllScopesOptions();
        opts.timeout().ifPresent(toPassOptions::timeout);
        opts.retryStrategy().ifPresent(toPassOptions::retryStrategy);
        return this.getAllScopes(toPassOptions).thenApply(scopes -> {
            Optional<ScopeSpec> scope = scopes.stream().filter(s -> s.name().equals(scopeName)).findFirst();
            if (scope.isPresent()) {
                return scope.get();
            }
            throw ScopeNotFoundException.forScope((String)scopeName);
        });
    }

    public CompletableFuture<List<ScopeSpec>> getAllScopes() {
        return this.getAllScopes(GetAllScopesOptions.getAllScopesOptions());
    }

    public CompletableFuture<List<ScopeSpec>> getAllScopes(GetAllScopesOptions options) {
        return this.loadManifest(options.build()).thenApply(manifest -> manifest.scopes().stream().map(s -> ScopeSpec.create(s.name(), s.collections().stream().map(c -> CollectionSpec.create(c.name(), s.name(), Duration.ofSeconds(c.maxExpiry()))).collect(Collectors.toSet()))).collect(Collectors.toList()));
    }

    private void checkForErrors(GenericManagerResponse response, String scopeName, String collectionName) {
        if (response.status().success()) {
            return;
        }
        String error = new String(response.content(), StandardCharsets.UTF_8);
        if (response.status() == ResponseStatus.NOT_FOUND) {
            if (error.contains("Not found.") || error.contains("Requested resource not found.")) {
                throw FeatureNotAvailableException.collections();
            }
            if (error.contains("Scope with this name is not found") || error.contains("scope_not_found")) {
                throw ScopeNotFoundException.forScope((String)scopeName);
            }
            if (error.contains("Collection with this name is not found")) {
                throw CollectionNotFoundException.forCollection((String)collectionName);
            }
        }
        if (response.status() == ResponseStatus.INVALID_ARGS) {
            if (error.contains("Scope with this name already exists") || error.matches(".*Scope with name .+ already exists.*")) {
                throw ScopeExistsException.forScope((String)scopeName);
            }
            if (error.contains("scope_not_found")) {
                throw ScopeNotFoundException.forScope((String)scopeName);
            }
            if (error.contains("Collection with this name already exists") || error.matches(".*Collection with name .+ already exists.*")) {
                throw CollectionExistsException.forCollection((String)collectionName);
            }
            if (error.contains("Not allowed on this version of cluster")) {
                throw FeatureNotAvailableException.collections();
            }
            if (error.contains("Collection with this name is not found") || error.contains("collection_not_found")) {
                throw CollectionNotFoundException.forCollection((String)collectionName);
            }
        }
        if (error.contains("Method Not Allowed")) {
            throw FeatureNotAvailableException.collections();
        }
        throw new CouchbaseException("Unknown error in CollectionManager: " + error + ", response: " + response);
    }

    private CompletableFuture<CollectionsManifest> loadManifest(CommonOptions.BuiltCommonOptions opts) {
        return this.sendRequest(HttpMethod.GET, AsyncCollectionManager.pathForManifest(this.bucketName), opts).thenApply(response -> {
            this.checkForErrors((GenericManagerResponse)response, null, null);
            return (CollectionsManifest)Mapper.decodeInto((byte[])response.content(), CollectionsManifest.class);
        });
    }
}

