/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.java.manager.bucket.AsyncBucketManager;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.CreateBucketOptions;
import com.couchbase.client.java.manager.bucket.DropBucketOptions;
import com.couchbase.client.java.manager.bucket.FlushBucketOptions;
import com.couchbase.client.java.manager.bucket.GetAllBucketOptions;
import com.couchbase.client.java.manager.bucket.GetBucketOptions;
import com.couchbase.client.java.manager.bucket.UpdateBucketOptions;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class ReactiveBucketManager {
    private final AsyncBucketManager async;

    public ReactiveBucketManager(AsyncBucketManager async) {
        this.async = Objects.requireNonNull(async);
    }

    public AsyncBucketManager async() {
        return this.async;
    }

    public Mono<Void> createBucket(BucketSettings settings) {
        return Reactor.toMono(() -> this.async.createBucket(settings));
    }

    public Mono<Void> createBucket(BucketSettings settings, CreateBucketOptions options) {
        return Reactor.toMono(() -> this.async.createBucket(settings, options));
    }

    public Mono<Void> updateBucket(BucketSettings settings) {
        return Reactor.toMono(() -> this.async.updateBucket(settings));
    }

    public Mono<Void> updateBucket(BucketSettings settings, UpdateBucketOptions options) {
        return Reactor.toMono(() -> this.async.updateBucket(settings, options));
    }

    public Mono<Void> dropBucket(String bucketName) {
        return Reactor.toMono(() -> this.async.dropBucket(bucketName));
    }

    public Mono<Void> dropBucket(String bucketName, DropBucketOptions options) {
        return Reactor.toMono(() -> this.async.dropBucket(bucketName, options));
    }

    public Mono<BucketSettings> getBucket(String bucketName) {
        return Reactor.toMono(() -> this.async.getBucket(bucketName));
    }

    public Mono<BucketSettings> getBucket(String bucketName, GetBucketOptions options) {
        return Reactor.toMono(() -> this.async.getBucket(bucketName, options));
    }

    public Mono<Map<String, BucketSettings>> getAllBuckets() {
        return Reactor.toMono(() -> this.async.getAllBuckets());
    }

    public Mono<Map<String, BucketSettings>> getAllBuckets(GetAllBucketOptions options) {
        return Reactor.toMono(() -> this.async.getAllBuckets(options));
    }

    public Mono<Void> flushBucket(String bucketName) {
        return Reactor.toMono(() -> this.async.flushBucket(bucketName));
    }

    public Mono<Void> flushBucket(String bucketName, FlushBucketOptions options) {
        return Reactor.toMono(() -> this.async.flushBucket(bucketName, options));
    }
}

