/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.core.msg.kv.GetAndLockRequest;
import com.couchbase.client.core.msg.kv.GetAndTouchRequest;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubDocumentOpResponseStatus;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.msg.kv.SubdocGetResponse;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.projections.ProjectionsApplier;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@Stability.Internal
public enum GetAccessor {


    public static CompletableFuture<GetResult> get(Core core, GetRequest request, Transcoder transcoder) {
        core.send((Request)request);
        return ((CompletableFuture)request.response().thenApply(response -> {
            if (response.status().success()) {
                return new GetResult(response.content(), response.flags(), response.cas(), Optional.empty(), transcoder);
            }
            throw DefaultErrorUtil.keyValueStatusToException((KeyValueRequest)request, (Response)response);
        })).whenComplete((t, e) -> request.context().logicallyComplete());
    }

    public static CompletableFuture<GetResult> getAndLock(Core core, GetAndLockRequest request, Transcoder transcoder) {
        core.send((Request)request);
        return ((CompletableFuture)request.response().thenApply(response -> {
            if (response.status().success()) {
                return new GetResult(response.content(), response.flags(), response.cas(), Optional.empty(), transcoder);
            }
            throw DefaultErrorUtil.keyValueStatusToException((KeyValueRequest)request, (Response)response);
        })).whenComplete((t, e) -> request.context().logicallyComplete());
    }

    public static CompletableFuture<GetResult> getAndTouch(Core core, GetAndTouchRequest request, Transcoder transcoder) {
        core.send((Request)request);
        return ((CompletableFuture)request.response().thenApply(response -> {
            if (response.status().success()) {
                return new GetResult(response.content(), response.flags(), response.cas(), Optional.empty(), transcoder);
            }
            throw DefaultErrorUtil.keyValueStatusToException((KeyValueRequest)request, (Response)response);
        })).whenComplete((t, e) -> request.context().logicallyComplete());
    }

    public static CompletableFuture<GetResult> subdocGet(Core core, SubdocGetRequest request, Transcoder transcoder) {
        core.send((Request)request);
        return ((CompletableFuture)request.response().thenApply(response -> {
            if (response.status().success() || response.status() == ResponseStatus.SUBDOC_FAILURE) {
                return GetAccessor.parseSubdocGet(response, transcoder);
            }
            throw DefaultErrorUtil.keyValueStatusToException((KeyValueRequest)request, (Response)response);
        })).whenComplete((t, e) -> request.context().logicallyComplete());
    }

    private static GetResult parseSubdocGet(SubdocGetResponse response, Transcoder transcoder) {
        int convertedFlags;
        if (response.error().isPresent()) {
            throw (CouchbaseException)response.error().get();
        }
        long cas = response.cas();
        byte[] exptime = null;
        byte[] content = null;
        byte[] flags = null;
        for (SubDocumentField value : response.values()) {
            if (value == null) continue;
            if ("$document.exptime".equals(value.path())) {
                exptime = value.value();
                continue;
            }
            if ("$document.flags".equals(value.path())) {
                flags = value.value();
                continue;
            }
            if (!value.path().isEmpty()) continue;
            content = value.value();
        }
        int n = convertedFlags = flags == null ? CodecFlags.JSON_COMPAT_FLAGS : Integer.parseInt(new String(flags, StandardCharsets.UTF_8));
        if (content == null) {
            try {
                content = GetAccessor.projectRecursive(response);
            }
            catch (Exception e) {
                throw new CouchbaseException("Unexpected Exception while decoding Sub-Document get", (Throwable)e);
            }
        }
        Optional<Instant> expiration = exptime == null ? Optional.empty() : Optional.of(Instant.ofEpochSecond(Long.parseLong(new String(exptime, StandardCharsets.UTF_8))));
        return new GetResult(content, convertedFlags, cas, expiration, transcoder);
    }

    static byte[] projectRecursive(SubdocGetResponse response) {
        JsonObject out = JsonObject.create();
        for (SubDocumentField value : response.values()) {
            if (value == null || value.status() != SubDocumentOpResponseStatus.SUCCESS || value.path().isEmpty() || "$document.exptime".equals(value.path()) || "$document.flags".equals(value.path())) continue;
            ProjectionsApplier.parse(out, value.path(), value.value());
        }
        return out.toBytes();
    }
}

