/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.CbStrings;

@Stability.Volatile
public enum DesignDocumentNamespace {
    DEVELOPMENT{

        @Override
        public String adjustName(String name) {
            return name.startsWith(DesignDocumentNamespace.DEV_PREFIX) ? name : DesignDocumentNamespace.DEV_PREFIX + name;
        }

        @Override
        public boolean contains(String rawDesignDocName) {
            return rawDesignDocName.startsWith(DesignDocumentNamespace.DEV_PREFIX);
        }
    }
    ,
    PRODUCTION{

        @Override
        public String adjustName(String name) {
            return CbStrings.removeStart((String)name, (String)DesignDocumentNamespace.DEV_PREFIX);
        }

        @Override
        public boolean contains(String rawDesignDocName) {
            return !DEVELOPMENT.contains(rawDesignDocName);
        }
    };

    static final String DEV_PREFIX = "dev_";

    public static String requireUnqualified(String name) {
        if (name.startsWith(DEV_PREFIX)) {
            throw InvalidArgumentException.fromMessage((String)("Design document name '" + RedactableArgument.redactMeta((Object)name) + "' must not start with '" + DEV_PREFIX + "'; instead specify the " + DEVELOPMENT.name() + " namespace when referring to the document."));
        }
        return name;
    }

    public abstract String adjustName(String var1);

    public abstract boolean contains(String var1);
}

