/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.search.SearchChunkRow;
import com.couchbase.client.core.util.CbObjects;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JacksonTransformers;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.result.SearchRowLocations;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SearchRow {
    private final String index;
    private final String id;
    private final double score;
    private final JsonObject explanation;
    private final Optional<SearchRowLocations> locations;
    private final Map<String, List<String>> fragments;
    private final byte[] fields;
    private final JsonSerializer serializer;

    public SearchRow(String index, String id, double score, JsonObject explanation, Optional<SearchRowLocations> locations, Map<String, List<String>> fragments, byte[] fields, JsonSerializer serializer) {
        this.index = index;
        this.id = id;
        this.score = score;
        this.explanation = explanation;
        this.locations = locations;
        this.fragments = fragments;
        this.fields = fields;
        this.serializer = serializer;
    }

    public String index() {
        return this.index;
    }

    public String id() {
        return this.id;
    }

    public double score() {
        return this.score;
    }

    public JsonObject explanation() {
        return this.explanation;
    }

    public Optional<SearchRowLocations> locations() {
        return this.locations;
    }

    public Map<String, List<String>> fragments() {
        return this.fragments;
    }

    public <T> T fieldsAs(Class<T> target) {
        return this.serializer.deserialize(target, this.fields);
    }

    public <T> T fieldsAs(TypeRef<T> target) {
        return this.serializer.deserialize(target, this.fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRow that = (SearchRow)o;
        if (Double.compare(that.score, this.score) != 0) {
            return false;
        }
        if (!this.index.equals(that.index)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + this.id.hashCode();
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static SearchRow fromResponse(SearchChunkRow row, JsonSerializer serializer) {
        try {
            Map<String, List<String>> fragments;
            JsonObject hit = (JsonObject)JacksonTransformers.MAPPER.readValue(row.data(), JsonObject.class);
            String index = hit.getString("index");
            String id = hit.getString("id");
            double score = hit.getDouble("score");
            JsonObject explanationJson = (JsonObject)CbObjects.defaultIfNull((Object)hit.getObject("explanation"), JsonObject::create);
            Optional<SearchRowLocations> locations = Optional.ofNullable(hit.getObject("locations")).map(SearchRowLocations::from);
            JsonObject fragmentsJson = hit.getObject("fragments");
            if (fragmentsJson != null) {
                fragments = new HashMap(fragmentsJson.size());
                for (String field : fragmentsJson.getNames()) {
                    List fragment;
                    JsonArray fragmentJson = fragmentsJson.getArray(field);
                    if (fragmentJson != null) {
                        fragment = new ArrayList(fragmentJson.size());
                        for (int i = 0; i < fragmentJson.size(); ++i) {
                            fragment.add(fragmentJson.getString(i));
                        }
                    } else {
                        fragment = Collections.emptyList();
                    }
                    fragments.put(field, fragment);
                }
            } else {
                fragments = Collections.emptyMap();
            }
            byte[] fields = null;
            if (hit.containsKey("fields")) {
                fields = JacksonTransformers.MAPPER.writeValueAsBytes(hit.getObject("fields").toMap());
            }
            return new SearchRow(index, id, score, explanationJson, locations, fragments, fields, serializer);
        }
        catch (IOException e) {
            throw new DecodingFailureException("Failed to decode row '" + new String(row.data(), StandardCharsets.UTF_8) + "'", (Throwable)e);
        }
    }

    public String toString() {
        return "SearchRow{index='" + RedactableArgument.redactMeta((Object)this.index) + '\'' + ", id='" + this.id + '\'' + ", score=" + this.score + ", explanation=" + this.explanation + ", locations=" + RedactableArgument.redactUser(this.locations) + ", fragments=" + RedactableArgument.redactUser(this.fragments) + ", fields=" + RedactableArgument.redactUser(this.fieldsAs(new TypeRef<HashMap<String, Object>>(){})) + '}';
    }
}

