/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.diagnostics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.Validators;
import java.util.Set;

public class WaitUntilReadyOptions {
    private Set<ServiceType> serviceTypes;
    private ClusterState desiredState = ClusterState.ONLINE;

    public static WaitUntilReadyOptions waitUntilReadyOptions() {
        return new WaitUntilReadyOptions();
    }

    private WaitUntilReadyOptions() {
    }

    public WaitUntilReadyOptions serviceTypes(Set<ServiceType> serviceTypes) {
        Validators.notNullOrEmpty(serviceTypes, (String)"Service Types");
        this.serviceTypes = serviceTypes;
        return this;
    }

    public WaitUntilReadyOptions desiredState(ClusterState desiredState) {
        Validators.notNull((Object)desiredState, (String)"Desired State");
        if (desiredState == ClusterState.OFFLINE) {
            throw InvalidArgumentException.fromMessage((String)"Offline cannot be passed in as a state to wait for");
        }
        this.desiredState = desiredState;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    @Stability.Internal
    public class Built {
        Built() {
        }

        public Set<ServiceType> serviceTypes() {
            return WaitUntilReadyOptions.this.serviceTypes;
        }

        public ClusterState desiredState() {
            return WaitUntilReadyOptions.this.desiredState;
        }
    }
}

