/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.view;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.CbStrings;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@Stability.Volatile
public class View {
    private final String map;
    private final Optional<String> reduce;

    public View(String map) {
        this(map, null);
    }

    @JsonCreator
    public View(@JsonProperty(value="map") String map, @JsonProperty(value="reduce") String reduce) {
        this.map = Objects.requireNonNull(map);
        this.reduce = Optional.ofNullable(CbStrings.emptyToNull((String)reduce));
    }

    public String map() {
        return this.map;
    }

    public Optional<String> reduce() {
        return this.reduce;
    }

    public String toString() {
        return "View{map='" + RedactableArgument.redactMeta((Object)this.map) + '\'' + this.reduce.map(s -> ", reduce='" + RedactableArgument.redactMeta((Object)s) + '\'').orElse("") + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View view = (View)o;
        return this.map.equals(view.map) && Objects.equals(this.reduce, view.reduce);
    }

    public int hashCode() {
        return Objects.hash(this.map, this.reduce);
    }
}

