/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.utils.yasjl;

import com.couchbase.client.core.utils.yasjl.Callbacks.JsonPointerCB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JsonPointer {
    private static final int MAX_NESTING_LEVEL = 31;
    private static final String ROOT_TOKEN = "";
    private final List<String> refTokens;
    private JsonPointerCB jsonPointerCB;

    JsonPointer() {
        this(Collections.singletonList(ROOT_TOKEN));
    }

    JsonPointer(List<String> tokens) {
        this.refTokens = new ArrayList<String>(tokens);
    }

    JsonPointer(String path) {
        this(path, null);
    }

    public JsonPointer(String path, JsonPointerCB callback) {
        this.refTokens = new ArrayList<String>();
        this.jsonPointerCB = callback;
        this.parseComponents(path);
    }

    private void parseComponents(String path) {
        String[] tokens = path.split("/");
        if (tokens.length > 31) {
            throw new IllegalArgumentException("Provided path contains too many levels of nesting!");
        }
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].replace("~1", "/").replace("~0", "~");
        }
        this.refTokens.addAll(Arrays.asList(tokens));
    }

    void addToken(String token) {
        this.refTokens.add(token);
    }

    void removeLastToken() {
        if (this.refTokens.size() > 1) {
            this.refTokens.remove(this.refTokens.size() - 1);
        }
    }

    protected List<String> tokens() {
        return this.refTokens;
    }

    JsonPointerCB jsonPointerCB() {
        return this.jsonPointerCB;
    }

    void jsonPointerCB(JsonPointerCB callback) {
        this.jsonPointerCB = callback;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String refToken : this.refTokens) {
            sb.append("/");
            sb.append(refToken);
        }
        return "JsonPointer{path=" + (this.refTokens.isEmpty() ? ROOT_TOKEN : sb.substring(1)) + "}";
    }
}

