/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.analytics.parser;

import com.couchbase.client.core.endpoint.analytics.parser.YasjlAnalyticsResponseParser;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.analytics.GenericAnalyticsResponse;
import com.couchbase.client.core.utils.UnicastAutoReleaseSubject;
import com.couchbase.client.core.utils.yasjl.ByteBufJsonParser;
import com.couchbase.client.core.utils.yasjl.Callbacks.JsonPointerCB1;
import com.couchbase.client.core.utils.yasjl.JsonPointer;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import java.io.EOFException;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;

public class YasjlAnalyticsDeferredResponseParser {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(YasjlAnalyticsResponseParser.class);
    private final Scheduler scheduler;
    private final long ttl;
    private final ByteBufJsonParser parser;
    private UnicastAutoReleaseSubject<ByteBuf> queryRowObservable;
    private CouchbaseRequest currentRequest;
    private boolean initialized;
    private GenericAnalyticsResponse response;
    private boolean sentResponse;
    private ByteBuf responseContent;
    private final CoreEnvironment env;

    public YasjlAnalyticsDeferredResponseParser(Scheduler scheduler, long ttl, CoreEnvironment env) {
        this.scheduler = scheduler;
        this.ttl = ttl;
        this.response = null;
        this.env = env;
        JsonPointer[] jsonPointers = new JsonPointer[]{new JsonPointer("/-", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlAnalyticsDeferredResponseParser.this.queryRowObservable != null) {
                    YasjlAnalyticsDeferredResponseParser.this.queryRowObservable.onNext(buf);
                    if (YasjlAnalyticsDeferredResponseParser.this.response == null) {
                        YasjlAnalyticsDeferredResponseParser.this.createResponse();
                        LOGGER.trace("Started receiving results for deferred queries");
                    }
                }
            }
        })};
        this.parser = new ByteBufJsonParser(jsonPointers);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(ByteBuf responseContent, ResponseStatus responseStatus, CouchbaseRequest request) {
        this.sentResponse = false;
        this.response = null;
        this.responseContent = responseContent;
        this.currentRequest = request;
        this.queryRowObservable = UnicastAutoReleaseSubject.create(this.ttl, TimeUnit.MILLISECONDS, this.scheduler);
        this.parser.initialize(responseContent);
        this.initialized = true;
    }

    private void createResponse() {
        this.response = new GenericAnalyticsResponse(null, (Observable<ByteBuf>)this.queryRowObservable.onBackpressureBuffer(), null, null, null, null, this.currentRequest, null, null, null);
    }

    public GenericAnalyticsResponse parse() throws Exception {
        try {
            this.parser.parse();
            this.responseContent.discardReadBytes();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (!this.sentResponse && this.response != null) {
            this.sentResponse = true;
            return this.response;
        }
        return null;
    }

    public void finishParsingAndReset() {
        if (this.queryRowObservable != null) {
            this.queryRowObservable.onCompleted();
        }
        this.queryRowObservable = null;
        this.initialized = false;
    }
}

