/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result.impl;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.search.result.AsyncSearchQueryResult;
import com.couchbase.client.java.search.result.SearchMetrics;
import com.couchbase.client.java.search.result.SearchQueryResult;
import com.couchbase.client.java.search.result.SearchQueryRow;
import com.couchbase.client.java.search.result.SearchStatus;
import com.couchbase.client.java.search.result.facets.FacetResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.exceptions.CompositeException;
import rx.functions.Func1;
import rx.functions.Func5;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class DefaultSearchQueryResult
implements SearchQueryResult {
    private final RuntimeException error;
    private final SearchStatus status;
    private final List<SearchQueryRow> hits;
    private final List<String> errors;
    private final Map<String, FacetResult> facets;
    private final SearchMetrics metrics;
    public static final Func1<AsyncSearchQueryResult, Observable<SearchQueryResult>> FROM_ASYNC = new Func1<AsyncSearchQueryResult, Observable<SearchQueryResult>>(){

        public Observable<SearchQueryResult> call(AsyncSearchQueryResult asqr) {
            return Observable.zip((Observable)Observable.just((Object)asqr.status()), (Observable)asqr.hits().onErrorResumeNext(Observable.empty()).toList(), (Observable)asqr.hits().ignoreElements().cast(Throwable.class).onErrorResumeNext((Func1)new Func1<Throwable, Observable<Throwable>>(){

                public Observable<Throwable> call(Throwable throwable) {
                    return Observable.just((Object)throwable);
                }
            }).singleOrDefault(null), (Observable)asqr.facets().toMap((Func1)new Func1<FacetResult, String>(){

                public String call(FacetResult facetResult) {
                    return facetResult.name();
                }
            }), asqr.metrics(), (Func5)new Func5<SearchStatus, List<SearchQueryRow>, Throwable, Map<String, FacetResult>, SearchMetrics, SearchQueryResult>(){

                public SearchQueryResult call(SearchStatus searchStatus, List<SearchQueryRow> searchQueryRows, Throwable error, Map<String, FacetResult> facets, SearchMetrics searchMetrics) {
                    return new DefaultSearchQueryResult(searchStatus, searchQueryRows, error, facets, searchMetrics);
                }
            });
        }
    };

    public DefaultSearchQueryResult(SearchStatus status, List<SearchQueryRow> hits, Throwable error, Map<String, FacetResult> facets, SearchMetrics metrics) {
        this.status = status;
        this.hits = hits;
        this.facets = facets;
        this.metrics = metrics;
        this.error = error == null ? null : (error instanceof RuntimeException ? (RuntimeException)error : new RuntimeException(error));
        if (error instanceof CompositeException) {
            CompositeException composite = (CompositeException)error;
            this.errors = new ArrayList<String>(composite.getExceptions().size());
            for (Throwable e : composite.getExceptions()) {
                this.errors.add(e.getMessage());
            }
        } else {
            this.errors = error != null ? Collections.singletonList(error.getMessage()) : Collections.emptyList();
        }
    }

    @Override
    public SearchStatus status() {
        return this.status;
    }

    @Override
    public List<SearchQueryRow> hits() {
        return this.hits;
    }

    @Override
    public List<SearchQueryRow> hitsOrFail() {
        if (this.error != null) {
            throw this.error;
        }
        return this.hits;
    }

    @Override
    public Iterator<SearchQueryRow> iterator() {
        return this.hitsOrFail().iterator();
    }

    @Override
    public List<String> errors() {
        return this.errors;
    }

    @Override
    public Map<String, FacetResult> facets() {
        return this.facets;
    }

    @Override
    public SearchMetrics metrics() {
        return this.metrics;
    }

    public String toString() {
        return "DefaultSearchQueryResult{error=" + this.error + ", status=" + this.status + ", hits=" + this.hits + ", errors=" + this.errors + ", facets=" + this.facets + ", metrics=" + this.metrics + '}';
    }
}

