/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.env;

import com.couchbase.client.core.env.DefaultCoreEnvironment;
import com.couchbase.client.core.env.KeyValueServiceConfig;
import com.couchbase.client.core.env.QueryServiceConfig;
import com.couchbase.client.core.env.SearchServiceConfig;
import com.couchbase.client.core.env.ViewServiceConfig;
import com.couchbase.client.core.env.WaitStrategyFactory;
import com.couchbase.client.core.env.resources.ShutdownHook;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.event.consumers.LoggingConsumer;
import com.couchbase.client.core.hooks.CouchbaseCoreSendHook;
import com.couchbase.client.core.logging.CouchbaseLogLevel;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.metrics.LatencyMetricsCollectorConfig;
import com.couchbase.client.core.metrics.MetricsCollectorConfig;
import com.couchbase.client.core.node.MemcachedHashingStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import java.security.KeyStore;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;

public class DefaultCouchbaseEnvironment
extends DefaultCoreEnvironment
implements CouchbaseEnvironment {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CouchbaseEnvironment.class);
    private static final long MANAGEMENT_TIMEOUT = TimeUnit.SECONDS.toMillis(75L);
    private static final long QUERY_TIMEOUT = TimeUnit.SECONDS.toMillis(75L);
    private static final long VIEW_TIMEOUT = TimeUnit.SECONDS.toMillis(75L);
    private static final long SEARCH_TIMEOUT = TimeUnit.SECONDS.toMillis(75L);
    private static final long ANALYTICS_TIMEOUT = TimeUnit.SECONDS.toMillis(75L);
    private static final long KV_TIMEOUT = 2500L;
    private static final long CONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final boolean DNS_SRV_ENABLED = false;
    private final long managementTimeout;
    private final long queryTimeout;
    private final long viewTimeout;
    private final long searchTimeout;
    private final long analyticsTimeout;
    private final long kvTimeout;
    private final long connectTimeout;
    private final boolean dnsSrvEnabled;
    protected static String CLIENT_VERSION;
    protected static String CLIENT_GIT_VERSION;
    public static String SDK_PACKAGE_NAME_AND_VERSION;
    public static String SDK_USER_AGENT;
    private static final String VERSION_PROPERTIES = "com.couchbase.client.java.properties";

    private DefaultCouchbaseEnvironment(Builder builder) {
        super((DefaultCoreEnvironment.Builder)builder);
        this.managementTimeout = DefaultCouchbaseEnvironment.longPropertyOr((String)"managementTimeout", (long)builder.managementTimeout);
        this.queryTimeout = DefaultCouchbaseEnvironment.longPropertyOr((String)"queryTimeout", (long)builder.queryTimeout);
        this.viewTimeout = DefaultCouchbaseEnvironment.longPropertyOr((String)"viewTimeout", (long)builder.viewTimeout);
        this.kvTimeout = DefaultCouchbaseEnvironment.longPropertyOr((String)"kvTimeout", (long)builder.kvTimeout);
        this.searchTimeout = DefaultCouchbaseEnvironment.longPropertyOr((String)"searchTimeout", (long)builder.searchTimeout);
        this.analyticsTimeout = DefaultCouchbaseEnvironment.longPropertyOr((String)"analyticsTimeout", (long)builder.analyticsTimeout);
        this.connectTimeout = DefaultCouchbaseEnvironment.longPropertyOr((String)"connectTimeout", (long)builder.connectTimeout);
        this.dnsSrvEnabled = this.booleanPropertyOr("dnsSrvEnabled", builder.dnsSrvEnabled);
        if (this.queryTimeout > this.maxRequestLifetime()) {
            LOGGER.warn("The configured query timeout is greater than the maximum request lifetime. This can lead to falsely cancelled requests.");
        }
        if (this.kvTimeout > this.maxRequestLifetime()) {
            LOGGER.warn("The configured key/value timeout is greater than the maximum request lifetime.This can lead to falsely cancelled requests.");
        }
        if (this.viewTimeout > this.maxRequestLifetime()) {
            LOGGER.warn("The configured view timeout is greater than the maximum request lifetime.This can lead to falsely cancelled requests.");
        }
        if (this.analyticsTimeout > this.maxRequestLifetime()) {
            LOGGER.warn("The configured analytics timeout is greater than the maximum request lifetime.This can lead to falsely cancelled requests.");
        }
        if (this.searchTimeout > this.maxRequestLifetime()) {
            LOGGER.warn("The configured search timeout is greater than the maximum request lifetime.This can lead to falsely cancelled requests.");
        }
        if (this.managementTimeout > this.maxRequestLifetime()) {
            LOGGER.warn("The configured management timeout is greater than the maximum request lifetime.This can lead to falsely cancelled requests.");
        }
    }

    public static DefaultCouchbaseEnvironment create() {
        return DefaultCouchbaseEnvironment.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public long managementTimeout() {
        return this.managementTimeout;
    }

    @Override
    public long queryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public long viewTimeout() {
        return this.viewTimeout;
    }

    @Override
    public long searchTimeout() {
        return this.searchTimeout;
    }

    @Override
    public long analyticsTimeout() {
        return this.analyticsTimeout;
    }

    @Override
    public long kvTimeout() {
        return this.kvTimeout;
    }

    @Override
    public long connectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public boolean dnsSrvEnabled() {
        return this.dnsSrvEnabled;
    }

    @Override
    public String clientVersion() {
        return CLIENT_VERSION;
    }

    @Override
    public String clientBuild() {
        return CLIENT_GIT_VERSION;
    }

    protected StringBuilder dumpParameters(StringBuilder sb) {
        super.dumpParameters(sb);
        sb.append(", queryTimeout=").append(this.queryTimeout);
        sb.append(", viewTimeout=").append(this.viewTimeout);
        sb.append(", searchTimeout=").append(this.searchTimeout);
        sb.append(", analyticsTimeout=").append(this.analyticsTimeout);
        sb.append(", kvTimeout=").append(this.kvTimeout);
        sb.append(", connectTimeout=").append(this.connectTimeout);
        sb.append(", dnsSrvEnabled=").append(this.dnsSrvEnabled);
        return sb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CouchbaseEnvironment: {");
        this.dumpParameters(sb).append('}');
        return sb.toString();
    }

    static /* synthetic */ long access$800() {
        return MANAGEMENT_TIMEOUT;
    }

    static /* synthetic */ long access$900() {
        return QUERY_TIMEOUT;
    }

    static /* synthetic */ long access$1000() {
        return VIEW_TIMEOUT;
    }

    static /* synthetic */ long access$1100() {
        return SEARCH_TIMEOUT;
    }

    static /* synthetic */ long access$1200() {
        return ANALYTICS_TIMEOUT;
    }

    static /* synthetic */ long access$1300() {
        return CONNECT_TIMEOUT;
    }

    static {
        SDK_USER_AGENT = SDK_PACKAGE_NAME_AND_VERSION = "couchbase-java-client";
        try {
            Class<CouchbaseCluster> facadeClass = CouchbaseCluster.class;
            if (facadeClass == null) {
                throw new IllegalStateException("Could not locate ClusterFacade");
            }
            String version = null;
            String gitVersion = null;
            try {
                Properties versionProp = new Properties();
                versionProp.load(DefaultCouchbaseEnvironment.class.getClassLoader().getResourceAsStream(VERSION_PROPERTIES));
                version = versionProp.getProperty("specificationVersion");
                gitVersion = versionProp.getProperty("implementationVersion");
            }
            catch (Exception e) {
                LOGGER.info("Could not retrieve java-client version properties, defaulting.", (Throwable)e);
            }
            CLIENT_VERSION = version == null ? "unknown" : version;
            CLIENT_GIT_VERSION = gitVersion == null ? "unknown" : gitVersion;
            SDK_PACKAGE_NAME_AND_VERSION = String.format("couchbase-java-client/%s (git: %s, core: %s)", CLIENT_VERSION, CLIENT_GIT_VERSION, CORE_GIT_VERSION);
            SDK_USER_AGENT = String.format("%s (%s/%s %s; %s %s)", SDK_PACKAGE_NAME_AND_VERSION, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.vm.name"), System.getProperty("java.runtime.version"));
        }
        catch (Exception ex) {
            LOGGER.info("Could not set up user agent and packages, defaulting.", (Throwable)ex);
        }
    }

    public static class Builder
    extends DefaultCoreEnvironment.Builder {
        private long managementTimeout = DefaultCouchbaseEnvironment.access$800();
        private long queryTimeout = DefaultCouchbaseEnvironment.access$900();
        private long viewTimeout = DefaultCouchbaseEnvironment.access$1000();
        private long kvTimeout = 2500L;
        private long searchTimeout = DefaultCouchbaseEnvironment.access$1100();
        private long analyticsTimeout = DefaultCouchbaseEnvironment.access$1200();
        private long connectTimeout = DefaultCouchbaseEnvironment.access$1300();
        private boolean dnsSrvEnabled = false;

        public Builder() {
            this.packageNameAndVersion(SDK_PACKAGE_NAME_AND_VERSION);
            this.userAgent(SDK_USER_AGENT);
        }

        public Builder managementTimeout(long managementTimeout) {
            this.managementTimeout = managementTimeout;
            return this;
        }

        public Builder queryTimeout(long queryTimeout) {
            this.queryTimeout = queryTimeout;
            return this;
        }

        public Builder viewTimeout(long viewTimeout) {
            this.viewTimeout = viewTimeout;
            return this;
        }

        public Builder kvTimeout(long kvTimeout) {
            this.kvTimeout = kvTimeout;
            return this;
        }

        public Builder searchTimeout(long searchTimeout) {
            this.searchTimeout = searchTimeout;
            return this;
        }

        public Builder analyticsTimeout(long analyticsTimeout) {
            this.analyticsTimeout = analyticsTimeout;
            return this;
        }

        public Builder connectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder disconnectTimeout(long disconnectTimeout) {
            super.disconnectTimeout(disconnectTimeout);
            return this;
        }

        public Builder sslEnabled(boolean sslEnabled) {
            super.sslEnabled(sslEnabled);
            return this;
        }

        public Builder sslKeystoreFile(String sslKeystoreFile) {
            super.sslKeystoreFile(sslKeystoreFile);
            return this;
        }

        public Builder sslKeystorePassword(String sslKeystorePassword) {
            super.sslKeystorePassword(sslKeystorePassword);
            return this;
        }

        public Builder bootstrapHttpEnabled(boolean bootstrapHttpEnabled) {
            super.bootstrapHttpEnabled(bootstrapHttpEnabled);
            return this;
        }

        public Builder bootstrapCarrierEnabled(boolean bootstrapCarrierEnabled) {
            super.bootstrapCarrierEnabled(bootstrapCarrierEnabled);
            return this;
        }

        public Builder bootstrapHttpDirectPort(int bootstrapHttpDirectPort) {
            super.bootstrapHttpDirectPort(bootstrapHttpDirectPort);
            return this;
        }

        public Builder bootstrapHttpSslPort(int bootstrapHttpSslPort) {
            super.bootstrapHttpSslPort(bootstrapHttpSslPort);
            return this;
        }

        public Builder bootstrapCarrierDirectPort(int bootstrapCarrierDirectPort) {
            super.bootstrapCarrierDirectPort(bootstrapCarrierDirectPort);
            return this;
        }

        public Builder bootstrapCarrierSslPort(int bootstrapCarrierSslPort) {
            super.bootstrapCarrierSslPort(bootstrapCarrierSslPort);
            return this;
        }

        public Builder ioPoolSize(int ioPoolSize) {
            super.ioPoolSize(ioPoolSize);
            return this;
        }

        public Builder computationPoolSize(int computationPoolSize) {
            super.computationPoolSize(computationPoolSize);
            return this;
        }

        public Builder requestBufferSize(int requestBufferSize) {
            super.requestBufferSize(requestBufferSize);
            return this;
        }

        public Builder responseBufferSize(int responseBufferSize) {
            super.responseBufferSize(responseBufferSize);
            return this;
        }

        public Builder kvEndpoints(int kvEndpoints) {
            super.kvEndpoints(kvEndpoints);
            return this;
        }

        public Builder viewEndpoints(int viewServiceEndpoints) {
            super.viewEndpoints(viewServiceEndpoints);
            return this;
        }

        public Builder queryEndpoints(int queryServiceEndpoints) {
            super.queryEndpoints(queryServiceEndpoints);
            return this;
        }

        public Builder ioPool(EventLoopGroup group) {
            super.ioPool(group);
            return this;
        }

        public Builder ioPool(EventLoopGroup group, ShutdownHook shutdownHook) {
            super.ioPool(group, shutdownHook);
            return this;
        }

        public Builder scheduler(Scheduler scheduler) {
            super.scheduler(scheduler);
            return this;
        }

        public Builder scheduler(Scheduler scheduler, ShutdownHook shutdownHook) {
            super.scheduler(scheduler, shutdownHook);
            return this;
        }

        public Builder observeIntervalDelay(Delay observeIntervalDelay) {
            super.observeIntervalDelay(observeIntervalDelay);
            return this;
        }

        public Builder reconnectDelay(Delay reconnectDelay) {
            super.reconnectDelay(reconnectDelay);
            return this;
        }

        public Builder retryDelay(Delay retryDelay) {
            super.retryDelay(retryDelay);
            return this;
        }

        public Builder retryStrategy(RetryStrategy retryStrategy) {
            super.retryStrategy(retryStrategy);
            return this;
        }

        public Builder maxRequestLifetime(long maxRequestLifetime) {
            super.maxRequestLifetime(maxRequestLifetime);
            return this;
        }

        public Builder keepAliveInterval(long keepAliveIntervalMilliseconds) {
            super.keepAliveInterval(keepAliveIntervalMilliseconds);
            return this;
        }

        public Builder autoreleaseAfter(long autoreleaseAfter) {
            super.autoreleaseAfter(autoreleaseAfter);
            return this;
        }

        public Builder eventBus(EventBus eventBus) {
            super.eventBus(eventBus);
            return this;
        }

        public Builder bufferPoolingEnabled(boolean bufferPoolingEnabled) {
            super.bufferPoolingEnabled(bufferPoolingEnabled);
            return this;
        }

        public Builder packageNameAndVersion(String packageNameAndVersion) {
            super.packageNameAndVersion(packageNameAndVersion);
            return this;
        }

        public Builder userAgent(String userAgent) {
            super.userAgent(userAgent);
            return this;
        }

        public Builder dnsSrvEnabled(boolean dnsSrvEnabled) {
            this.dnsSrvEnabled = dnsSrvEnabled;
            return this;
        }

        public Builder mutationTokensEnabled(boolean mutationTokensEnabled) {
            super.mutationTokensEnabled(mutationTokensEnabled);
            return this;
        }

        public Builder tcpNodelayEnabled(boolean tcpNodelayEnabled) {
            super.tcpNodelayEnabled(tcpNodelayEnabled);
            return this;
        }

        public Builder runtimeMetricsCollectorConfig(MetricsCollectorConfig metricsCollectorConfig) {
            super.runtimeMetricsCollectorConfig(metricsCollectorConfig);
            return this;
        }

        public Builder networkLatencyMetricsCollectorConfig(LatencyMetricsCollectorConfig metricsCollectorConfig) {
            super.networkLatencyMetricsCollectorConfig(metricsCollectorConfig);
            return this;
        }

        public Builder defaultMetricsLoggingConsumer(boolean enabled, CouchbaseLogLevel level, LoggingConsumer.OutputFormat format) {
            super.defaultMetricsLoggingConsumer(enabled, level, format);
            return this;
        }

        public Builder defaultMetricsLoggingConsumer(boolean enabled, CouchbaseLogLevel level) {
            super.defaultMetricsLoggingConsumer(enabled, level);
            return this;
        }

        public Builder socketConnectTimeout(int socketConnectTimeout) {
            super.socketConnectTimeout(socketConnectTimeout);
            return this;
        }

        public Builder callbacksOnIoPool(boolean callbacksOnIoPool) {
            super.callbacksOnIoPool(callbacksOnIoPool);
            return this;
        }

        public Builder searchEndpoints(int searchEndpoints) {
            super.searchEndpoints(searchEndpoints);
            return this;
        }

        public Builder sslKeystore(KeyStore sslKeystore) {
            super.sslKeystore(sslKeystore);
            return this;
        }

        public Builder requestBufferWaitStrategy(WaitStrategyFactory waitStrategy) {
            super.requestBufferWaitStrategy(waitStrategy);
            return this;
        }

        public Builder memcachedHashingStrategy(MemcachedHashingStrategy memcachedHashingStrategy) {
            super.memcachedHashingStrategy(memcachedHashingStrategy);
            return this;
        }

        public Builder kvIoPool(EventLoopGroup group, ShutdownHook shutdownHook) {
            super.kvIoPool(group, shutdownHook);
            return this;
        }

        public Builder viewIoPool(EventLoopGroup group, ShutdownHook shutdownHook) {
            super.viewIoPool(group, shutdownHook);
            return this;
        }

        public Builder queryIoPool(EventLoopGroup group, ShutdownHook shutdownHook) {
            super.queryIoPool(group, shutdownHook);
            return this;
        }

        public Builder searchIoPool(EventLoopGroup group, ShutdownHook shutdownHook) {
            super.searchIoPool(group, shutdownHook);
            return this;
        }

        public Builder keyValueServiceConfig(KeyValueServiceConfig keyValueServiceConfig) {
            super.keyValueServiceConfig(keyValueServiceConfig);
            return this;
        }

        public Builder viewServiceConfig(ViewServiceConfig viewServiceConfig) {
            super.viewServiceConfig(viewServiceConfig);
            return this;
        }

        public Builder queryServiceConfig(QueryServiceConfig queryServiceConfig) {
            super.queryServiceConfig(queryServiceConfig);
            return this;
        }

        public Builder searchServiceConfig(SearchServiceConfig searchServiceConfig) {
            super.searchServiceConfig(searchServiceConfig);
            return this;
        }

        public Builder configPollInterval(long configPollInterval) {
            super.configPollInterval(configPollInterval);
            return this;
        }

        public Builder certAuthEnabled(boolean certAuthEnabled) {
            super.certAuthEnabled(certAuthEnabled);
            return this;
        }

        public Builder continuousKeepAliveEnabled(boolean continuousKeepAliveEnabled) {
            super.continuousKeepAliveEnabled(continuousKeepAliveEnabled);
            return this;
        }

        public Builder keepAliveErrorThreshold(long keepAliveErrorThreshold) {
            super.keepAliveErrorThreshold(keepAliveErrorThreshold);
            return this;
        }

        public Builder keepAliveTimeout(long keepAliveTimeout) {
            super.keepAliveTimeout(keepAliveTimeout);
            return this;
        }

        public Builder couchbaseCoreSendHook(CouchbaseCoreSendHook hook) {
            super.couchbaseCoreSendHook(hook);
            return this;
        }

        public Builder sslTruststoreFile(String sslTruststoreFile) {
            super.sslTruststoreFile(sslTruststoreFile);
            return this;
        }

        public Builder sslTruststorePassword(String sslTruststorePassword) {
            super.sslTruststorePassword(sslTruststorePassword);
            return this;
        }

        public Builder sslTruststore(KeyStore sslTruststore) {
            super.sslTruststore(sslTruststore);
            return this;
        }

        public Builder configPollFloorInterval(long configPollFloorInterval) {
            super.configPollFloorInterval(configPollFloorInterval);
            return this;
        }

        public DefaultCouchbaseEnvironment build() {
            return new DefaultCouchbaseEnvironment(this);
        }
    }
}

