/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.PreparedPayload;
import com.couchbase.client.java.query.SerializableStatement;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.util.DigestUtils;

public class PrepareStatement
implements SerializableStatement {
    public static final String PREPARE_PREFIX = "PREPARE ";
    private static final long serialVersionUID = -3951622990579947393L;
    private final SerializableStatement toPrepare;
    private final String preparedName;

    private PrepareStatement(Statement toPrepare, String preparedName) {
        this.toPrepare = toPrepare instanceof SerializableStatement ? (SerializableStatement)toPrepare : new N1qlQuery.RawStatement(toPrepare.toString());
        this.preparedName = preparedName;
    }

    public Statement originalStatement() {
        return this.toPrepare;
    }

    public String preparedName() {
        return this.preparedName;
    }

    public String toString() {
        if (this.preparedName != null) {
            return "PREPARE `" + this.preparedName + "` FROM " + this.toPrepare.toString();
        }
        return PREPARE_PREFIX + this.toPrepare.toString();
    }

    public static PrepareStatement prepare(Statement statement) {
        if (statement instanceof PrepareStatement) {
            return (PrepareStatement)statement;
        }
        if (statement instanceof PreparedPayload) {
            PreparedPayload preparedPayload = (PreparedPayload)statement;
            return new PrepareStatement(preparedPayload.originalStatement(), preparedPayload.preparedName());
        }
        String preparedName = DigestUtils.digestSha1Hex(statement.toString());
        return new PrepareStatement(statement, preparedName);
    }

    public static PrepareStatement prepare(Statement statement, String preparedName) {
        Statement original = statement instanceof PrepareStatement ? ((PrepareStatement)statement).originalStatement() : (statement instanceof PreparedPayload ? ((PreparedPayload)statement).originalStatement() : statement);
        return new PrepareStatement(original, preparedName);
    }

    public static PrepareStatement prepare(String statement) {
        if (statement == null) {
            throw new NullPointerException("Statement to prepare cannot be null");
        }
        if (statement.startsWith(PREPARE_PREFIX)) {
            statement = statement.replaceFirst(PREPARE_PREFIX, "");
        }
        return PrepareStatement.prepare(new N1qlQuery.RawStatement(statement));
    }
}

