/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.cluster.CloseBucketRequest;
import com.couchbase.client.core.message.cluster.CloseBucketResponse;
import com.couchbase.client.core.message.kv.AppendRequest;
import com.couchbase.client.core.message.kv.AppendResponse;
import com.couchbase.client.core.message.kv.CounterRequest;
import com.couchbase.client.core.message.kv.CounterResponse;
import com.couchbase.client.core.message.kv.GetRequest;
import com.couchbase.client.core.message.kv.GetResponse;
import com.couchbase.client.core.message.kv.InsertRequest;
import com.couchbase.client.core.message.kv.InsertResponse;
import com.couchbase.client.core.message.kv.PrependRequest;
import com.couchbase.client.core.message.kv.PrependResponse;
import com.couchbase.client.core.message.kv.RemoveRequest;
import com.couchbase.client.core.message.kv.RemoveResponse;
import com.couchbase.client.core.message.kv.ReplaceRequest;
import com.couchbase.client.core.message.kv.ReplaceResponse;
import com.couchbase.client.core.message.kv.TouchRequest;
import com.couchbase.client.core.message.kv.TouchResponse;
import com.couchbase.client.core.message.kv.UnlockRequest;
import com.couchbase.client.core.message.kv.UnlockResponse;
import com.couchbase.client.core.message.kv.UpsertRequest;
import com.couchbase.client.core.message.kv.UpsertResponse;
import com.couchbase.client.core.message.observe.Observe;
import com.couchbase.client.core.message.query.GenericQueryRequest;
import com.couchbase.client.core.message.query.GenericQueryResponse;
import com.couchbase.client.core.message.view.ViewQueryRequest;
import com.couchbase.client.core.message.view.ViewQueryResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.core.utils.Buffers;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicaMode;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.bucket.AsyncBucketManager;
import com.couchbase.client.java.bucket.DefaultAsyncBucketManager;
import com.couchbase.client.java.bucket.ReplicaReader;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.JsonLongDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.CouchbaseOutOfMemoryException;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import com.couchbase.client.java.error.DurabilityException;
import com.couchbase.client.java.error.RequestTooBigException;
import com.couchbase.client.java.error.TemporaryFailureException;
import com.couchbase.client.java.error.TemporaryLockFailureException;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.query.AsyncQueryResult;
import com.couchbase.client.java.query.AsyncQueryRow;
import com.couchbase.client.java.query.DefaultAsyncQueryResult;
import com.couchbase.client.java.query.DefaultAsyncQueryRow;
import com.couchbase.client.java.query.PrepareStatement;
import com.couchbase.client.java.query.Query;
import com.couchbase.client.java.query.QueryPlan;
import com.couchbase.client.java.query.SimpleQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.transcoder.BinaryTranscoder;
import com.couchbase.client.java.transcoder.JsonArrayTranscoder;
import com.couchbase.client.java.transcoder.JsonBooleanTranscoder;
import com.couchbase.client.java.transcoder.JsonDoubleTranscoder;
import com.couchbase.client.java.transcoder.JsonLongTranscoder;
import com.couchbase.client.java.transcoder.JsonStringTranscoder;
import com.couchbase.client.java.transcoder.JsonTranscoder;
import com.couchbase.client.java.transcoder.LegacyTranscoder;
import com.couchbase.client.java.transcoder.RawJsonTranscoder;
import com.couchbase.client.java.transcoder.SerializableTranscoder;
import com.couchbase.client.java.transcoder.StringTranscoder;
import com.couchbase.client.java.transcoder.Transcoder;
import com.couchbase.client.java.view.AsyncSpatialViewResult;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.SpatialViewQuery;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewQueryResponseMapper;
import com.couchbase.client.java.view.ViewRetryHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;
import rx.exceptions.CompositeException;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

public class CouchbaseAsyncBucket
implements AsyncBucket {
    public static final JsonTranscoder JSON_OBJECT_TRANSCODER = new JsonTranscoder();
    public static final JsonArrayTranscoder JSON_ARRAY_TRANSCODER = new JsonArrayTranscoder();
    public static final JsonBooleanTranscoder JSON_BOOLEAN_TRANSCODER = new JsonBooleanTranscoder();
    public static final JsonDoubleTranscoder JSON_DOUBLE_TRANSCODER = new JsonDoubleTranscoder();
    public static final JsonLongTranscoder JSON_LONG_TRANSCODER = new JsonLongTranscoder();
    public static final JsonStringTranscoder JSON_STRING_TRANSCODER = new JsonStringTranscoder();
    public static final RawJsonTranscoder RAW_JSON_TRANSCODER = new RawJsonTranscoder();
    public static final LegacyTranscoder LEGACY_TRANSCODER = new LegacyTranscoder();
    public static final BinaryTranscoder BINARY_TRANSCODER = new BinaryTranscoder();
    public static final StringTranscoder STRING_TRANSCODER = new StringTranscoder();
    public static final SerializableTranscoder SERIALIZABLE_TRANSCODER = new SerializableTranscoder();
    private final String bucket;
    private final String password;
    private final ClusterFacade core;
    private final Map<Class<? extends Document>, Transcoder<? extends Document, ?>> transcoders;
    private final AsyncBucketManager bucketManager;
    private final CouchbaseEnvironment environment;

    public CouchbaseAsyncBucket(ClusterFacade core, CouchbaseEnvironment environment, String name, String password, List<Transcoder<? extends Document, ?>> customTranscoders) {
        this.bucket = name;
        this.password = password;
        this.core = core;
        this.environment = environment;
        this.transcoders = new ConcurrentHashMap();
        this.transcoders.put(JSON_OBJECT_TRANSCODER.documentType(), JSON_OBJECT_TRANSCODER);
        this.transcoders.put(JSON_ARRAY_TRANSCODER.documentType(), JSON_ARRAY_TRANSCODER);
        this.transcoders.put(JSON_BOOLEAN_TRANSCODER.documentType(), JSON_BOOLEAN_TRANSCODER);
        this.transcoders.put(JSON_DOUBLE_TRANSCODER.documentType(), JSON_DOUBLE_TRANSCODER);
        this.transcoders.put(JSON_LONG_TRANSCODER.documentType(), JSON_LONG_TRANSCODER);
        this.transcoders.put(JSON_STRING_TRANSCODER.documentType(), JSON_STRING_TRANSCODER);
        this.transcoders.put(RAW_JSON_TRANSCODER.documentType(), RAW_JSON_TRANSCODER);
        this.transcoders.put(LEGACY_TRANSCODER.documentType(), LEGACY_TRANSCODER);
        this.transcoders.put(BINARY_TRANSCODER.documentType(), BINARY_TRANSCODER);
        this.transcoders.put(STRING_TRANSCODER.documentType(), STRING_TRANSCODER);
        this.transcoders.put(SERIALIZABLE_TRANSCODER.documentType(), SERIALIZABLE_TRANSCODER);
        for (Transcoder<Document, ?> custom : customTranscoders) {
            this.transcoders.put(custom.documentType(), custom);
        }
        this.bucketManager = DefaultAsyncBucketManager.create(this.bucket, password, core);
    }

    @Override
    public String name() {
        return this.bucket;
    }

    @Override
    public Observable<ClusterFacade> core() {
        return Observable.just((Object)this.core);
    }

    @Override
    public Observable<JsonDocument> get(String id) {
        return this.get(id, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> get(D document) {
        return this.get(document.id(), document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> get(final String id, final Class<D> target) {
        return this.core.send((CouchbaseRequest)new GetRequest(id, this.bucket)).filter((Func1)new Func1<GetResponse, Boolean>(){

            public Boolean call(GetResponse response) {
                if (response.status().isSuccess()) {
                    return true;
                }
                ByteBuf content = response.content();
                if (content != null && content.refCnt() > 0) {
                    content.release();
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        return false;
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        }).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        });
    }

    @Override
    public Observable<JsonDocument> getAndLock(String id, int lockTime) {
        return this.getAndLock(id, lockTime, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndLock(D document, int lockTime) {
        return this.getAndLock(document.id(), lockTime, document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndLock(final String id, int lockTime, final Class<D> target) {
        return this.core.send((CouchbaseRequest)new GetRequest(id, this.bucket, true, false, lockTime)).filter((Func1)new Func1<GetResponse, Boolean>(){

            public Boolean call(GetResponse response) {
                if (response.status().isSuccess()) {
                    return true;
                }
                ByteBuf content = response.content();
                if (content != null && content.refCnt() > 0) {
                    content.release();
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        return false;
                    }
                    case TEMPORARY_FAILURE: {
                        throw new TemporaryLockFailureException();
                    }
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        }).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        });
    }

    @Override
    public Observable<JsonDocument> getAndTouch(String id, int expiry) {
        return this.getAndTouch(id, expiry, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndTouch(D document) {
        return this.getAndTouch(document.id(), document.expiry(), document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndTouch(final String id, int expiry, final Class<D> target) {
        return this.core.send((CouchbaseRequest)new GetRequest(id, this.bucket, false, true, expiry)).filter((Func1)new Func1<GetResponse, Boolean>(){

            public Boolean call(GetResponse response) {
                if (response.status().isSuccess()) {
                    return true;
                }
                ByteBuf content = response.content();
                if (content != null && content.refCnt() > 0) {
                    content.release();
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        return false;
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        }).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        });
    }

    @Override
    public Observable<JsonDocument> getFromReplica(String id, ReplicaMode type) {
        return this.getFromReplica(id, type, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getFromReplica(D document, ReplicaMode type) {
        return this.getFromReplica(document.id(), type, document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getFromReplica(final String id, ReplicaMode type, final Class<D> target) {
        return ReplicaReader.read(this.core, id, type, this.bucket).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(final D document) {
        final Transcoder<Document, ?> transcoder = this.transcoders.get(document.getClass());
        Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
        return this.core.send((CouchbaseRequest)new InsertRequest(document.id(), (ByteBuf)encoded.value1(), document.expiry(), ((Integer)encoded.value2()).intValue(), this.bucket)).map(new Func1<InsertResponse, D>(){

            public D call(InsertResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas());
                }
                switch (response.status()) {
                    case TOO_BIG: {
                        throw new RequestTooBigException();
                    }
                    case EXISTS: {
                        throw new DocumentAlreadyExistsException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        Observable<D> insertResult = this.insert(document);
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return insertResult;
        }
        return insertResult.flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), (RetryStrategy)CouchbaseAsyncBucket.this.environment.retryStrategy()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(final D document) {
        final Transcoder<Document, ?> transcoder = this.transcoders.get(document.getClass());
        Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
        return this.core.send((CouchbaseRequest)new UpsertRequest(document.id(), (ByteBuf)encoded.value1(), document.expiry(), ((Integer)encoded.value2()).intValue(), this.bucket)).map(new Func1<UpsertResponse, D>(){

            public D call(UpsertResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas());
                }
                switch (response.status()) {
                    case TOO_BIG: {
                        throw new RequestTooBigException();
                    }
                    case EXISTS: {
                        throw new CASMismatchException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        Observable<D> upsertResult = this.upsert(document);
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return upsertResult;
        }
        return upsertResult.flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), (RetryStrategy)CouchbaseAsyncBucket.this.environment.retryStrategy()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(final D document) {
        final Transcoder<Document, ?> transcoder = this.transcoders.get(document.getClass());
        Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
        return this.core.send((CouchbaseRequest)new ReplaceRequest(document.id(), (ByteBuf)encoded.value1(), document.cas(), document.expiry(), ((Integer)encoded.value2()).intValue(), this.bucket)).map(new Func1<ReplaceResponse, D>(){

            public D call(ReplaceResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas());
                }
                switch (response.status()) {
                    case TOO_BIG: {
                        throw new RequestTooBigException();
                    }
                    case NOT_EXISTS: {
                        throw new DocumentDoesNotExistException();
                    }
                    case EXISTS: {
                        throw new CASMismatchException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        Observable<D> replaceResult = this.replace(document);
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return replaceResult;
        }
        return replaceResult.flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), (RetryStrategy)CouchbaseAsyncBucket.this.environment.retryStrategy()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(final D document) {
        final Transcoder<? extends Document, ?> transcoder = this.transcoders.get(document.getClass());
        return this.core.send((CouchbaseRequest)new RemoveRequest(document.id(), document.cas(), this.bucket)).map(new Func1<RemoveResponse, D>(){

            public D call(RemoveResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), 0, null, response.cas());
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        throw new DocumentDoesNotExistException();
                    }
                    case EXISTS: {
                        throw new CASMismatchException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public Observable<JsonDocument> remove(String id) {
        return this.remove(id, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, Class<D> target) {
        Transcoder<Document, ?> transcoder = this.transcoders.get(target);
        return this.remove(transcoder.newDocument(id, 0, null, 0L));
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.observeRemove(this.remove(document), persistTo, replicateTo);
    }

    @Override
    public Observable<JsonDocument> remove(String id, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.remove(id, persistTo, replicateTo, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, PersistTo persistTo, ReplicateTo replicateTo, Class<D> target) {
        return this.observeRemove(this.remove(id, target), persistTo, replicateTo);
    }

    private <D extends Document<?>> Observable<D> observeRemove(Observable<D> removeResult, final PersistTo persistTo, final ReplicateTo replicateTo) {
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return removeResult;
        }
        return removeResult.flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)true, (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), (RetryStrategy)CouchbaseAsyncBucket.this.environment.retryStrategy()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
            }
        });
    }

    @Override
    public Observable<AsyncViewResult> query(final ViewQuery query) {
        Observable source = Observable.defer((Func0)new Func0<Observable<ViewQueryResponse>>(){

            public Observable<ViewQueryResponse> call() {
                ViewQueryRequest request = new ViewQueryRequest(query.getDesign(), query.getView(), query.isDevelopment(), query.toString(), query.getKeys(), CouchbaseAsyncBucket.this.bucket, CouchbaseAsyncBucket.this.password);
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)request);
            }
        });
        return ViewRetryHandler.retryOnCondition((Observable<ViewQueryResponse>)source).flatMap((Func1)new Func1<ViewQueryResponse, Observable<AsyncViewResult>>(){

            public Observable<AsyncViewResult> call(ViewQueryResponse response) {
                return ViewQueryResponseMapper.mapToViewResult(CouchbaseAsyncBucket.this, query, response);
            }
        });
    }

    @Override
    public Observable<AsyncSpatialViewResult> query(final SpatialViewQuery query) {
        Observable source = Observable.defer((Func0)new Func0<Observable<ViewQueryResponse>>(){

            public Observable<ViewQueryResponse> call() {
                ViewQueryRequest request = new ViewQueryRequest(query.getDesign(), query.getView(), query.isDevelopment(), true, query.toString(), null, CouchbaseAsyncBucket.this.bucket, CouchbaseAsyncBucket.this.password);
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)request);
            }
        });
        return ViewRetryHandler.retryOnCondition((Observable<ViewQueryResponse>)source).flatMap((Func1)new Func1<ViewQueryResponse, Observable<AsyncSpatialViewResult>>(){

            public Observable<AsyncSpatialViewResult> call(ViewQueryResponse response) {
                return ViewQueryResponseMapper.mapToSpatialViewResult(CouchbaseAsyncBucket.this, query, response);
            }
        });
    }

    @Override
    public Observable<AsyncQueryResult> query(Statement statement) {
        return this.query(Query.simple(statement));
    }

    @Override
    public Observable<AsyncQueryResult> query(Query query) {
        return this.queryRaw(query.n1ql().toString());
    }

    Observable<AsyncQueryResult> queryRaw(String query) {
        GenericQueryRequest request = GenericQueryRequest.jsonQuery((String)query, (String)this.bucket, (String)this.password);
        return this.core.send((CouchbaseRequest)request).flatMap((Func1)new Func1<GenericQueryResponse, Observable<AsyncQueryResult>>(){

            public Observable<AsyncQueryResult> call(GenericQueryResponse response) {
                Observable rows = response.rows().map((Func1)new Func1<ByteBuf, AsyncQueryRow>(){

                    public AsyncQueryRow call(ByteBuf byteBuf) {
                        try {
                            JsonObject value = JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            DefaultAsyncQueryRow defaultAsyncQueryRow = new DefaultAsyncQueryRow(value);
                            return defaultAsyncQueryRow;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode N1QL Query Info.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                });
                Observable signature = response.signature().map((Func1)new Func1<ByteBuf, Object>(){

                    public Object call(ByteBuf byteBuf) {
                        try {
                            Object object = JSON_OBJECT_TRANSCODER.byteBufJsonValueToObject(byteBuf);
                            return object;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode N1QL Query Signature", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                });
                Observable info = response.info().map((Func1)new Func1<ByteBuf, JsonObject>(){

                    public JsonObject call(ByteBuf byteBuf) {
                        try {
                            JsonObject jsonObject = JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            return jsonObject;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode N1QL Query Info.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                });
                Observable finalSuccess = response.queryStatus().map((Func1)new Func1<String, Boolean>(){

                    public Boolean call(String s) {
                        return "success".equalsIgnoreCase(s) || "completed".equalsIgnoreCase(s);
                    }
                });
                Observable errors = response.errors().map((Func1)new Func1<ByteBuf, JsonObject>(){

                    public JsonObject call(ByteBuf byteBuf) {
                        try {
                            JsonObject jsonObject = JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            return jsonObject;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode View Info.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                });
                boolean parseSuccess = response.status().isSuccess();
                String contextId = response.clientRequestId() == null ? "" : response.clientRequestId();
                String requestId = response.requestId();
                DefaultAsyncQueryResult r = new DefaultAsyncQueryResult((Observable<AsyncQueryRow>)rows, (Observable<Object>)signature, (Observable<JsonObject>)info, (Observable<JsonObject>)errors, (Observable<Boolean>)finalSuccess, parseSuccess, requestId, contextId);
                return Observable.just((Object)r);
            }
        });
    }

    @Override
    public Observable<QueryPlan> prepare(String statement) {
        return this.prepare(PrepareStatement.prepare(statement));
    }

    @Override
    public Observable<QueryPlan> prepare(Statement statement) {
        Statement prepared = statement instanceof PrepareStatement ? statement : PrepareStatement.prepare(statement);
        SimpleQuery query = Query.simple(prepared);
        GenericQueryRequest prepareRequest = GenericQueryRequest.jsonQuery((String)query.n1ql().toString(), (String)this.bucket, (String)this.password);
        return this.core.send((CouchbaseRequest)prepareRequest).flatMap((Func1)new Func1<GenericQueryResponse, Observable<QueryPlan>>(){

            public Observable<QueryPlan> call(GenericQueryResponse r) {
                if (r.status().isSuccess()) {
                    r.info().subscribe(Buffers.BYTE_BUF_RELEASER);
                    r.signature().subscribe(Buffers.BYTE_BUF_RELEASER);
                    r.errors().subscribe(Buffers.BYTE_BUF_RELEASER);
                    return r.rows().map((Func1)new Func1<ByteBuf, QueryPlan>(){

                        public QueryPlan call(ByteBuf byteBuf) {
                            try {
                                JsonObject value = JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                                QueryPlan queryPlan = new QueryPlan(value);
                                return queryPlan;
                            }
                            catch (Exception e) {
                                throw new TranscodingException("Could not decode N1QL Query Plan.", e);
                            }
                            finally {
                                byteBuf.release();
                            }
                        }
                    });
                }
                r.info().subscribe(Buffers.BYTE_BUF_RELEASER);
                r.signature().subscribe(Buffers.BYTE_BUF_RELEASER);
                r.rows().subscribe(Buffers.BYTE_BUF_RELEASER);
                return r.errors().map((Func1)new Func1<ByteBuf, Exception>(){

                    public Exception call(ByteBuf byteBuf) {
                        try {
                            JsonObject value = JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            CouchbaseException couchbaseException = new CouchbaseException("Query Error - " + value.toString());
                            return couchbaseException;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode N1QL Query Plan.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                }).reduce(new ArrayList(), (Func2)new Func2<ArrayList<Throwable>, Exception, ArrayList<Throwable>>(){

                    public ArrayList<Throwable> call(ArrayList<Throwable> throwables, Exception error) {
                        throwables.add(error);
                        return throwables;
                    }
                }).flatMap((Func1)new Func1<ArrayList<Throwable>, Observable<QueryPlan>>(){

                    public Observable<QueryPlan> call(ArrayList<Throwable> errors) {
                        if (errors.size() == 1) {
                            return Observable.error((Throwable)new CouchbaseException("Error while preparing plan", errors.get(0)));
                        }
                        return Observable.error((Throwable)new CompositeException("Multiple errors while preparing plan", errors));
                    }
                });
            }
        });
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta) {
        return this.counter(id, delta, 0L);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial) {
        return this.counter(id, delta, initial, 0);
    }

    @Override
    public Observable<JsonLongDocument> counter(final String id, long delta, long initial, final int expiry) {
        return this.core.send((CouchbaseRequest)new CounterRequest(id, initial, delta, expiry, this.bucket)).map((Func1)new Func1<CounterResponse, JsonLongDocument>(){

            public JsonLongDocument call(CounterResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return JsonLongDocument.create(id, expiry, response.value(), response.cas());
                }
                switch (response.status()) {
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public Observable<Boolean> unlock(String id, long cas) {
        return this.core.send((CouchbaseRequest)new UnlockRequest(id, cas, this.bucket)).map((Func1)new Func1<UnlockResponse, Boolean>(){

            public Boolean call(UnlockResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return true;
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        throw new DocumentDoesNotExistException();
                    }
                    case TEMPORARY_FAILURE: {
                        throw new TemporaryLockFailureException();
                    }
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> unlock(D document) {
        return this.unlock(document.id(), document.cas());
    }

    @Override
    public Observable<Boolean> touch(String id, int expiry) {
        return this.core.send((CouchbaseRequest)new TouchRequest(id, expiry, this.bucket)).map((Func1)new Func1<TouchResponse, Boolean>(){

            public Boolean call(TouchResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return true;
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        throw new DocumentDoesNotExistException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> touch(D document) {
        return this.touch(document.id(), document.expiry());
    }

    @Override
    public <D extends Document<?>> Observable<D> append(final D document) {
        final Transcoder<Document, ?> transcoder = this.transcoders.get(document.getClass());
        Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
        return this.core.send((CouchbaseRequest)new AppendRequest(document.id(), document.cas(), (ByteBuf)encoded.value1(), this.bucket)).map(new Func1<AppendResponse, D>(){

            public D call(AppendResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), 0, null, response.cas());
                }
                switch (response.status()) {
                    case TOO_BIG: {
                        throw new RequestTooBigException();
                    }
                    case NOT_STORED: {
                        throw new DocumentDoesNotExistException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(final D document) {
        final Transcoder<Document, ?> transcoder = this.transcoders.get(document.getClass());
        Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
        return this.core.send((CouchbaseRequest)new PrependRequest(document.id(), document.cas(), (ByteBuf)encoded.value1(), this.bucket)).map(new Func1<PrependResponse, D>(){

            public D call(PrependResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), 0, null, response.cas());
                }
                switch (response.status()) {
                    case TOO_BIG: {
                        throw new RequestTooBigException();
                    }
                    case NOT_STORED: {
                        throw new DocumentDoesNotExistException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public Observable<AsyncBucketManager> bucketManager() {
        return Observable.just((Object)this.bucketManager);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, PersistTo persistTo) {
        return this.insert(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, ReplicateTo replicateTo) {
        return this.insert(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, PersistTo persistTo) {
        return this.upsert(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, ReplicateTo replicateTo) {
        return this.upsert(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, PersistTo persistTo) {
        return this.replace(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, ReplicateTo replicateTo) {
        return this.replace(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, PersistTo persistTo) {
        return this.remove(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, ReplicateTo replicateTo) {
        return this.remove(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public Observable<JsonDocument> remove(String id, PersistTo persistTo) {
        return this.remove(id, persistTo, ReplicateTo.NONE);
    }

    @Override
    public Observable<JsonDocument> remove(String id, ReplicateTo replicateTo) {
        return this.remove(id, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, PersistTo persistTo, Class<D> target) {
        return this.remove(id, persistTo, ReplicateTo.NONE, target);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, ReplicateTo replicateTo, Class<D> target) {
        return this.remove(id, PersistTo.NONE, replicateTo, target);
    }

    @Override
    public Observable<Boolean> close() {
        return this.core.send((CouchbaseRequest)new CloseBucketRequest(this.bucket)).map((Func1)new Func1<CloseBucketResponse, Boolean>(){

            public Boolean call(CloseBucketResponse response) {
                return response.status().isSuccess();
            }
        });
    }

    public String toString() {
        return "AsyncBucket[" + this.name() + "]";
    }
}

