/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.ParametrizedQuery;
import com.couchbase.client.java.query.PreparedQuery;
import com.couchbase.client.java.query.QueryParams;
import com.couchbase.client.java.query.QueryPlan;
import com.couchbase.client.java.query.SerializableStatement;
import com.couchbase.client.java.query.SimpleQuery;
import com.couchbase.client.java.query.Statement;
import java.io.Serializable;

public abstract class Query
implements Serializable {
    private static final long serialVersionUID = 3758119606237959729L;

    public abstract Statement statement();

    public abstract QueryParams params();

    public abstract JsonObject n1ql();

    public static SimpleQuery simple(Statement statement) {
        return new SimpleQuery(statement, null);
    }

    public static SimpleQuery simple(String statement) {
        return Query.simple(new RawStatement(statement));
    }

    public static SimpleQuery simple(Statement statement, QueryParams params) {
        return new SimpleQuery(statement, params);
    }

    public static SimpleQuery simple(String statement, QueryParams params) {
        return Query.simple(new RawStatement(statement), params);
    }

    public static ParametrizedQuery parametrized(Statement statement, JsonArray positionalParams) {
        return new ParametrizedQuery(statement, positionalParams, null);
    }

    public static ParametrizedQuery parametrized(Statement statement, JsonObject namedParams) {
        return new ParametrizedQuery(statement, namedParams, null);
    }

    public static ParametrizedQuery parametrized(Statement statement, JsonArray positionalParams, QueryParams params) {
        return new ParametrizedQuery(statement, positionalParams, params);
    }

    public static ParametrizedQuery parametrized(Statement statement, JsonObject namedParams, QueryParams params) {
        return new ParametrizedQuery(statement, namedParams, params);
    }

    public static ParametrizedQuery parametrized(String statement, JsonArray positionalParams) {
        return new ParametrizedQuery((Statement)new RawStatement(statement), positionalParams, null);
    }

    public static ParametrizedQuery parametrized(String statement, JsonObject namedParams) {
        return new ParametrizedQuery((Statement)new RawStatement(statement), namedParams, null);
    }

    public static ParametrizedQuery parametrized(String statement, JsonArray positionalParams, QueryParams params) {
        return new ParametrizedQuery((Statement)new RawStatement(statement), positionalParams, params);
    }

    public static ParametrizedQuery parametrized(String statement, JsonObject namedParams, QueryParams params) {
        return new ParametrizedQuery((Statement)new RawStatement(statement), namedParams, params);
    }

    public static PreparedQuery prepared(QueryPlan plan) {
        return new PreparedQuery(plan, null);
    }

    public static PreparedQuery prepared(QueryPlan plan, JsonArray positionalParams) {
        return new PreparedQuery(plan, positionalParams, null);
    }

    public static PreparedQuery prepared(QueryPlan plan, JsonObject namedParams) {
        return new PreparedQuery(plan, namedParams, null);
    }

    public static PreparedQuery prepared(QueryPlan plan, QueryParams params) {
        return new PreparedQuery(plan, params);
    }

    public static PreparedQuery prepared(QueryPlan plan, JsonArray positionalParams, QueryParams params) {
        return new PreparedQuery(plan, positionalParams, params);
    }

    public static PreparedQuery prepared(QueryPlan plan, JsonObject namedParams, QueryParams params) {
        return new PreparedQuery(plan, namedParams, params);
    }

    static class RawStatement
    implements SerializableStatement {
        private static final long serialVersionUID = 107907431113912054L;
        private final String rawStatement;

        public RawStatement(String rawStatement) {
            this.rawStatement = rawStatement;
        }

        public String toString() {
            return this.rawStatement;
        }
    }
}

