/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.view.ViewQueryResponse;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.document.json.JsonObject;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

public class ViewRetryHandler {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ViewRetryHandler.class);
    private static final ShouldRetryViewRequestException SHOULD_RETRY = new ShouldRetryViewRequestException();

    public static Observable<ViewQueryResponse> retryOnCondition(Observable<ViewQueryResponse> input) {
        return input.flatMap((Func1)new Func1<ViewQueryResponse, Observable<ViewQueryResponse>>(){

            public Observable<ViewQueryResponse> call(ViewQueryResponse response) {
                return ViewRetryHandler.passThroughOrThrow(response);
            }
        }).retryWhen(new Func1<Observable<? extends Throwable>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Throwable> observable) {
                return observable.flatMap(new Func1<Throwable, Observable<?>>(){

                    public Observable<?> call(Throwable throwable) {
                        if (throwable instanceof ShouldRetryViewRequestException) {
                            return Observable.interval((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
                        }
                        return Observable.error((Throwable)throwable);
                    }
                });
            }
        });
    }

    private static Observable<ViewQueryResponse> passThroughOrThrow(final ViewQueryResponse response) {
        final int responseCode = response.responseCode();
        if (responseCode == 200) {
            return Observable.just((Object)response);
        }
        return response.info().map((Func1)new Func1<ByteBuf, ViewQueryResponse>(){

            public ViewQueryResponse call(ByteBuf byteBuf) {
                ByteBuf infoCopy = byteBuf.copy();
                JsonObject content = null;
                try {
                    content = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.byteBufToJsonObject(infoCopy);
                }
                catch (Exception e) {
                    throw new CouchbaseException("Could not parse View error message", (Throwable)e);
                }
                finally {
                    infoCopy.release();
                }
                if (ViewRetryHandler.shouldRetry(responseCode, content)) {
                    throw SHOULD_RETRY;
                }
                return response;
            }
        }).singleOrDefault((Object)response);
    }

    private static boolean shouldRetry(int status, JsonObject content) {
        switch (status) {
            case 200: {
                return false;
            }
            case 404: {
                return ViewRetryHandler.analyse404Response(content);
            }
            case 500: {
                return ViewRetryHandler.analyse500Response(content);
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 401: 
            case 408: 
            case 409: 
            case 412: 
            case 416: 
            case 417: 
            case 501: 
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        LOGGER.info("Received a View HTTP response code ({}) I did not expect, not retrying.", (Object)status);
        return false;
    }

    private static boolean analyse404Response(JsonObject content) {
        String stringified = content.toString();
        if (stringified.contains("not_found") && (stringified.contains("missing") || stringified.contains("deleted"))) {
            LOGGER.debug("Design document not found, error is {}", (Object)stringified);
            return false;
        }
        return true;
    }

    private static boolean analyse500Response(JsonObject content) {
        String stringified = content.toString();
        if (stringified.contains("error") && stringified.contains("{not_found, missing_named_view}")) {
            LOGGER.debug("Design document not found, error is {}", (Object)stringified);
            return false;
        }
        return true;
    }

    static {
        SHOULD_RETRY.setStackTrace(new StackTraceElement[0]);
    }

    private static class ShouldRetryViewRequestException
    extends CouchbaseException {
        private ShouldRetryViewRequestException() {
        }
    }
}

