/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.view.ViewQueryResponse;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.error.ViewDoesNotExistException;
import com.couchbase.client.java.transcoder.JsonTranscoder;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.AsyncViewRow;
import com.couchbase.client.java.view.DefaultAsyncViewResult;
import com.couchbase.client.java.view.DefaultAsyncViewRow;
import com.couchbase.client.java.view.ViewQuery;
import rx.Observable;
import rx.functions.Func1;

@InterfaceStability.Committed
@InterfaceAudience.Private
public class ViewQueryResponseMapper {
    private static final JsonTranscoder TRANSCODER = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER;

    public static Observable<AsyncViewResult> mapToViewResult(AsyncBucket bucket, ViewQuery query, ViewQueryResponse response) {
        return response.info().map((Func1)new ByteBufToJsonObject()).map((Func1)new BuildViewResult(bucket, query, response));
    }

    static class BuildViewResult
    implements Func1<JsonObject, AsyncViewResult> {
        private final AsyncBucket bucket;
        private final ViewQuery query;
        private final ViewQueryResponse response;

        BuildViewResult(AsyncBucket bucket, ViewQuery query, ViewQueryResponse response) {
            this.bucket = bucket;
            this.query = query;
            this.response = response;
        }

        public AsyncViewResult call(JsonObject jsonInfo) {
            JsonObject error = null;
            JsonObject debug = null;
            int totalRows = 0;
            boolean success = this.response.status().isSuccess();
            if (success) {
                debug = jsonInfo.getObject("debug_info");
                Integer trows = jsonInfo.getInt("total_rows");
                if (trows != null) {
                    totalRows = trows;
                }
            } else {
                if (this.response.status() == ResponseStatus.NOT_EXISTS) {
                    throw new ViewDoesNotExistException("View " + this.query.getDesign() + "/" + this.query.getView() + " does not exist.");
                }
                error = jsonInfo;
            }
            Observable rows = this.response.rows().map((Func1)new ByteBufToJsonObject()).map((Func1)new Func1<JsonObject, AsyncViewRow>(){

                public AsyncViewRow call(JsonObject row) {
                    return new DefaultAsyncViewRow(BuildViewResult.this.bucket, row.getString("id"), row.get("key"), row.get("value"));
                }
            });
            return new DefaultAsyncViewResult((Observable<AsyncViewRow>)rows, totalRows, success, error, debug);
        }
    }

    static class ByteBufToJsonObject
    implements Func1<ByteBuf, JsonObject> {
        ByteBufToJsonObject() {
        }

        public JsonObject call(ByteBuf byteBuf) {
            if (byteBuf == null || byteBuf.readableBytes() == 0) {
                return JsonObject.empty();
            }
            try {
                JsonObject decoded = TRANSCODER.byteBufToJsonObject(byteBuf);
                byteBuf.release();
                return decoded;
            }
            catch (Exception e) {
                throw new TranscodingException("Could not decode View JSON.", e);
            }
        }
    }
}

