/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.view.AsyncViewRow;
import com.couchbase.client.java.view.DefaultAsyncViewRow;
import com.couchbase.client.java.view.ViewRow;
import java.util.concurrent.TimeUnit;

public class DefaultViewRow
implements ViewRow {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final AsyncViewRow asyncViewRow;
    private final long timeout;

    public DefaultViewRow(CouchbaseEnvironment env, Bucket bucket, String id, Object key, Object value) {
        this.asyncViewRow = new DefaultAsyncViewRow(bucket.async(), id, key, value);
        this.timeout = env.kvTimeout();
    }

    @Override
    public String id() {
        return this.asyncViewRow.id();
    }

    @Override
    public Object key() {
        return this.asyncViewRow.key();
    }

    @Override
    public Object value() {
        return this.asyncViewRow.value();
    }

    @Override
    public JsonDocument document() {
        return this.document(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument document(long timeout, TimeUnit timeUnit) {
        return (JsonDocument)this.asyncViewRow.document().timeout(timeout, timeUnit).toBlocking().singleOrDefault(null);
    }

    @Override
    public <D extends Document<?>> D document(Class<D> target) {
        return this.document(target, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D document(Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)this.asyncViewRow.document(target).timeout(timeout, timeUnit).toBlocking().singleOrDefault(null));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultViewRow{");
        sb.append("id=").append(this.id());
        sb.append(", key=").append(this.key());
        sb.append(", value=").append(this.value());
        sb.append('}');
        return sb.toString();
    }
}

