/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.view.AsyncViewRow;
import rx.Observable;

public class DefaultAsyncViewRow
implements AsyncViewRow {
    private final String id;
    private final Object key;
    private final Object value;
    private final AsyncBucket bucket;

    public DefaultAsyncViewRow(AsyncBucket bucket, String id, Object key, Object value) {
        this.bucket = bucket;
        this.id = id;
        this.key = key;
        this.value = value;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Object key() {
        return this.key;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public Observable<JsonDocument> document() {
        if (this.id == null) {
            Observable.error((Throwable)new IllegalStateException("ID is null."));
        }
        return this.bucket.get(this.id);
    }

    @Override
    public <D extends Document<?>> Observable<D> document(Class<D> target) {
        if (this.id == null) {
            Observable.error((Throwable)new IllegalStateException("ID is null."));
        }
        return this.bucket.get(this.id, target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultViewRow{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", key=").append(this.key);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }
}

