/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption.internal;

import com.couchbase.client.encryption.Decrypter;
import com.couchbase.client.encryption.EncryptionResult;
import com.couchbase.client.encryption.Keyring;
import com.couchbase.client.encryption.errors.CryptoKeyNotFoundException;
import com.couchbase.client.encryption.errors.InvalidCiphertextException;
import com.couchbase.client.encryption.errors.InvalidCryptoKeyException;
import com.couchbase.client.encryption.internal.ZeroizableSecretKey;
import com.couchbase.client.encryption.internal.Zeroizer;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;

public class LegacyAesDecrypter
implements Decrypter {
    private final String algorithmName;
    private final int encryptionKeySize;
    private final Keyring keyring;
    private final Function<String, String> encryptionKeyNameToSigningKeyName;

    private LegacyAesDecrypter(String algorithmName, int encryptionKeySize, Keyring keyring, Function<String, String> encryptionKeyNameToSigningKeyName) {
        this.keyring = Objects.requireNonNull(keyring);
        this.encryptionKeyNameToSigningKeyName = Objects.requireNonNull(encryptionKeyNameToSigningKeyName);
        this.algorithmName = Objects.requireNonNull(algorithmName);
        this.encryptionKeySize = encryptionKeySize;
    }

    public static Decrypter aes128(Keyring keyring, Function<String, String> encryptionKeyNameToSigningKeyName) {
        return new LegacyAesDecrypter("AES-128-HMAC-SHA256", 16, keyring, encryptionKeyNameToSigningKeyName);
    }

    public static Decrypter aes256(Keyring keyring, Function<String, String> encryptionKeyNameToSigningKeyName) {
        return new LegacyAesDecrypter("AES-256-HMAC-SHA256", 32, keyring, encryptionKeyNameToSigningKeyName);
    }

    private int getKeySize() {
        return this.encryptionKeySize;
    }

    @Override
    public String algorithm() {
        return this.algorithmName;
    }

    @Override
    public byte[] decrypt(EncryptionResult encrypted) throws Exception {
        String alg = encrypted.getAlgorithm();
        String kid = encrypted.getString("kid");
        byte[] iv = encrypted.getBytes("iv");
        byte[] ciphertext = encrypted.getBytes("ciphertext");
        byte[] sig = encrypted.getBytes("sig");
        String signMe = kid + alg + encrypted.getString("iv") + encrypted.getString("ciphertext");
        byte[] calculatedSignature = this.sign(this.getSigningKeyName(kid), new byte[][]{signMe.getBytes(Charset.defaultCharset())});
        if (!MessageDigest.isEqual(sig, calculatedSignature)) {
            throw new InvalidCiphertextException("Signature does not match.");
        }
        try (ZeroizableSecretKey key = this.getAesKey(kid);){
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)key, ivParameterSpec);
            byte[] byArray = cipher.doFinal(ciphertext);
            return byArray;
        }
    }

    private ZeroizableSecretKey getKey(String keyId, String algorithm) {
        try (Zeroizer zeroizer = new Zeroizer();){
            byte[] keyBytes = zeroizer.add(this.keyring.getOrThrow(keyId).bytes());
            ZeroizableSecretKey zeroizableSecretKey = new ZeroizableSecretKey(keyBytes, algorithm);
            return zeroizableSecretKey;
        }
    }

    private ZeroizableSecretKey getAesKey(String keyName) {
        ZeroizableSecretKey key = this.getKey(keyName, "AES");
        int actualSize = key.size();
        if (actualSize != this.getKeySize()) {
            key.destroy();
            throw new InvalidCryptoKeyException(this.algorithm() + " requires key with " + this.getKeySize() + " bytes but key '" + keyName + "' has " + actualSize + " bytes.");
        }
        return key;
    }

    private String getSigningKeyName(String encryptionKeyName) {
        return Optional.of(this.encryptionKeyNameToSigningKeyName.apply(encryptionKeyName)).orElseThrow(() -> new CryptoKeyNotFoundException("No mapping to signature key name found for encryption key '" + encryptionKeyName + "'"));
    }

    private byte[] sign(String signingKeyName, byte[] ... signMe) throws Exception {
        try (ZeroizableSecretKey key = this.getKey(signingKeyName, "HMAC");){
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(key);
            for (byte[] array : signMe) {
                mac.update(array);
            }
            byte[] byArray = mac.doFinal();
            return byArray;
        }
    }
}

