/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.encryption.ListableKeyring;
import com.couchbase.client.encryption.deps.com.github.benmanes.caffeine.cache.Cache;
import com.couchbase.client.encryption.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.couchbase.client.encryption.errors.CryptoKeyNotFoundException;
import com.couchbase.client.encryption.internal.KeyImpl;
import com.couchbase.client.encryption.internal.LangHelper;
import com.couchbase.client.encryption.internal.Zeroizer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public interface Keyring {
    public Optional<Key> get(String var1);

    default public Key getOrThrow(String keyId) {
        return this.get(keyId).orElseThrow(() -> new CryptoKeyNotFoundException("Failed to locate crypto key '" + keyId + "'"));
    }

    public static Keyring caching(Duration expiry, int maxEntries, Keyring wrapped) {
        Objects.requireNonNull(wrapped);
        Cache cache = Caffeine.newBuilder().expireAfterWrite(expiry).maximumSize(maxEntries).build();
        return keyId -> cache.get(keyId, wrapped::get);
    }

    public static Keyring reloading(Duration reloadInterval, Supplier<Keyring> loader) {
        Objects.requireNonNull(loader);
        Cache cache = Caffeine.newBuilder().expireAfterWrite(reloadInterval).maximumSize(1L).build();
        return keyId -> cache.get("", arg_0 -> Keyring.lambda$reloading$2((Supplier)loader, arg_0)).get(keyId);
    }

    @Deprecated
    public static Keyring rotating(String versionDelimiter, Comparator<String> versionOrder, ListableKeyring wrapped) {
        Objects.requireNonNull(wrapped);
        Objects.requireNonNull(versionDelimiter);
        if (versionDelimiter.isEmpty()) {
            throw new IllegalArgumentException("Version delimiter must not be empty.");
        }
        return keyId -> {
            Optional<Key> exactMatch = wrapped.get(keyId);
            if (exactMatch.isPresent()) {
                return exactMatch;
            }
            String versionedKeyPrefix = keyId + versionDelimiter;
            String latestVersion = wrapped.keyIds().stream().filter(keyName -> keyName.startsWith(versionedKeyPrefix)).map(keyName -> LangHelper.removeStart(keyName, versionedKeyPrefix)).max(versionOrder).orElse(null);
            return latestVersion == null ? Optional.empty() : wrapped.get(versionedKeyPrefix + latestVersion);
        };
    }

    public static Keyring composite(Keyring ... keyrings) {
        return Keyring.composite(Arrays.asList(keyrings));
    }

    public static Keyring composite(List<Keyring> keyrings) {
        if (keyrings.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Keyring chain may not contain null keyring.");
        }
        List<Keyring> chain = LangHelper.copyToUnmodifiableList(keyrings);
        return keyId -> {
            for (Keyring keyring : chain) {
                Optional<Key> key = keyring.get(keyId);
                if (!key.isPresent()) continue;
                return key;
            }
            return Optional.empty();
        };
    }

    public static ListableKeyring fromMap(Map<String, byte[]> keyNameToBytes) {
        final HashMap nameToKey = new HashMap();
        keyNameToBytes.forEach((k, v) -> nameToKey.put(k, Key.create(k, v)));
        return new ListableKeyring(){

            public Set<String> keyIds() {
                return nameToKey.keySet();
            }

            @Override
            public Optional<Key> get(String keyId) {
                return Optional.ofNullable((Key)nameToKey.get(keyId));
            }
        };
    }

    private static /* synthetic */ Keyring lambda$reloading$2(Supplier loader, String ignore) {
        return (Keyring)loader.get();
    }

    public static interface Key {
        public static Key create(String id, byte[] material) {
            try (Zeroizer zeroizer = new Zeroizer();){
                KeyImpl keyImpl = new KeyImpl(id, zeroizer.add(material));
                return keyImpl;
            }
        }

        public String id();

        public byte[] bytes();
    }
}

