/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption.internal;

import com.couchbase.client.encryption.internal.Zeroizer;
import java.io.Closeable;
import java.util.Objects;
import javax.crypto.SecretKey;

public class ZeroizableSecretKey
implements SecretKey,
Closeable {
    private final byte[] bytes;
    private final String algorithm;
    private boolean destroyed;

    public ZeroizableSecretKey(byte[] bytes, String algorithm) {
        this.bytes = (byte[])bytes.clone();
        this.algorithm = Objects.requireNonNull(algorithm);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public synchronized byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("Key has been destroyed.");
        }
        return (byte[])this.bytes.clone();
    }

    @Override
    public synchronized void destroy() {
        this.destroyed = true;
        Zeroizer.zeroize(this.bytes);
    }

    public int size() {
        return this.bytes.length;
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void close() {
        this.destroy();
    }
}

