/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption.internal;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolId = new AtomicInteger();
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;

    public DaemonThreadFactory(String poolName) {
        this.prefix = poolName + '-' + poolId.incrementAndGet() + '-';
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.prefix + this.nextId.incrementAndGet());
        if (!t.isDaemon()) {
            t.setDaemon(true);
        }
        return t;
    }
}

