/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EncryptionResult {
    private final Map<String, Object> map = new HashMap<String, Object>();

    private EncryptionResult() {
    }

    public static EncryptionResult forAlgorithm(String algorithmName) {
        return EncryptionResult.fromMap(Collections.singletonMap("alg", algorithmName));
    }

    public String getAlgorithm() {
        return this.getString("alg");
    }

    public EncryptionResult put(String name, String value) {
        if ("alg".equals(name)) {
            throw new IllegalArgumentException("Attribute name 'alg' is reserved.");
        }
        this.map.put(name, value);
        return this;
    }

    public EncryptionResult put(String name, int value) {
        this.map.put(name, value);
        return this;
    }

    public EncryptionResult put(String name, boolean value) {
        this.map.put(name, value);
        return this;
    }

    public EncryptionResult put(String name, byte[] bytes) {
        return this.put(name, Base64.getEncoder().encodeToString(bytes));
    }

    public String getString(String name) {
        return (String)this.map.get(name);
    }

    public Integer getInt(String name) {
        Number number = (Number)this.map.get(name);
        return number == null ? null : Integer.valueOf(number.intValue());
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.map.get(name);
    }

    public byte[] getBytes(String name) {
        String s2 = this.getString(name);
        return s2 == null ? null : Base64.getDecoder().decode(s2);
    }

    public static EncryptionResult fromMap(Map<String, Object> map) {
        EncryptionResult r = new EncryptionResult();
        r.map.putAll(map);
        return r;
    }

    public Map<String, Object> asMap() {
        return this.map;
    }

    public String toString() {
        return this.map.toString();
    }
}

