package com.couchbase.client.encryption.deps.org.checkerframework.checker.tainting.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.SubtypeOf;

/**
 * Denotes a possibly-tainted value: at run time, the value might be tainted or might be untainted.
 *
 * <p>This is the top qualifier of the tainting type system. This annotation is associated with the
 * {@link com.couchbase.client.encryption.deps.org.checkerframework.checker.tainting.TaintingChecker}.
 *
 * @see Untainted
 * @see com.couchbase.client.encryption.deps.org.checkerframework.checker.tainting.TaintingChecker
 * @checker_framework.manual #tainting-checker Tainting Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@DefaultQualifierInHierarchy
@SubtypeOf({})
public @interface Tainted {}
