/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java;

import com.couchbase.columnar.client.java.DataConversionException;
import com.couchbase.columnar.client.java.codec.Deserializer;
import com.couchbase.columnar.client.java.codec.TypeRef;
import com.couchbase.columnar.client.java.internal.InternalJacksonSerDes;
import com.couchbase.columnar.client.java.json.JsonValue;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class Row {
    private final byte[] content;
    private final Deserializer deserializer;

    Row(byte[] content, Deserializer deserializer) {
        this.content = Objects.requireNonNull(content);
        this.deserializer = Objects.requireNonNull(deserializer);
    }

    public byte[] bytes() {
        return this.content;
    }

    public <T> T as(Class<T> type) {
        return Objects.requireNonNull(this.asNullable(type), "Row content was a literal null. If this is expected, call `row.asNullable(type)` instead of `row.as(type)`.");
    }

    public <T> @Nullable T asNullable(Class<T> type) {
        Objects.requireNonNull(type, "`type` argument must be non-null");
        try {
            String corePackage = "com.couchbase.client.core";
            if (type.getName().startsWith(corePackage)) {
                throw new IllegalArgumentException("Classes in internal API package '" + corePackage + "' are not valid deserialization targets. Did you mean to import this class from a different package? " + String.valueOf(type));
            }
            return JsonValue.class.isAssignableFrom(type) ? InternalJacksonSerDes.INSTANCE.deserialize(type, this.content) : this.deserializer.deserialize(type, this.content);
        }
        catch (Exception e) {
            throw new DataConversionException(e);
        }
    }

    public <T> T as(TypeRef<T> type) {
        return Objects.requireNonNull(this.asNullable(type), "Row content was a literal null. If this is expected, call `row.asNullable(type)` instead of `row.as(type)`.");
    }

    public <T> @Nullable T asNullable(TypeRef<T> type) {
        Objects.requireNonNull(type, "`type` argument must be non-null");
        try {
            return this.deserializer.deserialize(type, this.content);
        }
        catch (Exception e) {
            throw new DataConversionException(e);
        }
    }

    public String toString() {
        return new String(this.content, StandardCharsets.UTF_8);
    }
}

